/*
 * @Author        : Qinver
 * @Url           : zibll.com
 * @Date          : 2020-11-11 11:45:30
 * @LastEditTime: 2024-07-24 12:18:18
 * @Email         : 770349780@qq.com
 * @Project       : Zibll子比主题
 * @Description   : 一款极其优雅的Wordpress主题|Codestar Framework的自定义JS
 * @Read me       : 感谢您使用子比主题，主题源码有详细的注释，支持二次开发。
 * @Remind        : 使用盗版主题会存在各种未知风险。支持正版，从我做起！
 */

(function ($, window, document) {
    $(document).ready(function ($) {
        function cssTransition(n, t, o, i, e) {
            var r, a, s;
            i && ((t += 'px'), (o += 'px'), (r = 'translate3D(' + t + ',' + o + ' , 0)'), (a = {}), (s = cssT_Support()), (a[s + 'transform'] = r), (a[s + 'transition'] = s + 'transform 0s linear'), (a.cursor = e), 'null' == i && ((a[s + 'transform'] = ''), (a[s + 'transition'] = '')), n.css(a));
        }

        function cssT_Support() {
            var n = document.body || document.documentElement;
            n = n.style;
            return '' == n.WebkitTransition ? '-webkit-' : '' == n.MozTransition ? '-moz-' : '' == n.OTransition ? '-o-' : '' == n.transition ? '' : void 0;
        }
        $.fn.minitouch = function (n) {
            n = $.extend(
                {
                    direction: 'bottom',
                    selector: '',
                    depreciation: 50,
                    onStart: !1,
                    onEnd: !1,
                },
                n
            );
            var t = $(this),
                o = ($('body'), n.depreciation),
                i = 0,
                e = 0,
                r = 0,
                a = 0,
                s = 0,
                c = 0,
                u = 0,
                l = !1;
            t.on('touchstart pointerdown MSPointerDown', n.selector, function (n) {
                (i = 0), (e = 0), (r = 0), (a = 0), (s = 0), (c = 0), (u = 0), (i = n.originalEvent.pageX || n.originalEvent.touches[0].pageX), (e = n.originalEvent.pageY || n.originalEvent.touches[0].pageY), (l = !0);
            })
                .on('touchmove pointermove MSPointerMove', n.selector, function (t) {
                    (r = t.originalEvent.pageX || t.originalEvent.touches[0].pageX), (a = t.originalEvent.pageY || t.originalEvent.touches[0].pageY), (c = r - i), (u = a - e), (s = (180 * Math.atan2(u, c)) / Math.PI), 'right' == n.direction && ((u = 0), (c = s > -40 && s < 40 && c > 0 ? c : 0)), 'left' == n.direction && ((u = 0), (c = (s > 150 || s < -150) && 0 > c ? c : 0)), 'top' == n.direction && ((c = 0), (u = s > -130 && s < -50 && 0 > u ? u : 0)), 'bottom' == n.direction && ((c = 0), (u = s > 50 && s < 130 && u > 0 ? u : 0)), (0 === c && 0 === u) || (t.preventDefault(), cssTransition($(this), c, u, l, 'grab'));
                })
                .on('touchend touchcancel pointerup MSPointerUp', n.selector, function () {
                    (Math.abs(c) > o || Math.abs(u) > o) && 0 != n.onEnd && n.onEnd(t), cssTransition($(this), 0, 0, 'null', ''), (l = !1), (i = 0), (e = 0), (r = 0), (a = 0), (s = 0), (c = 0), (u = 0);
                });
        };

        $('body').on('click', '.ajax-get', function () {
            var _this = $(this);
            var confirm_text = _this.attr('data-confirm');
            if (confirm_text) {
                if (confirm(confirm_text) == true) {
                    return ajax_submit(_this, {}), !1;
                } else {
                    return !1;
                }
            } else {
                return ajax_submit(_this, {}), !1;
            }
        });

        function ajax_submit(_this, _data, success, notice) {
            var form = $(_this.parents('.ajax-form,ajaxform')[0]);
            var _notice = form.find('.ajax-notice');
            var _tt = _this.html();
            var ajax_url = form.attr('ajax-url') || _this.attr('ajax-url') || (wp && wp.ajax && wp.ajax.settings && wp.ajax.settings.url) || '/wp-admin/admin-ajax.php';
            var spin = '<i class="fa fa-spinner fa-spin fa-fw"></i> ';
            var n_type = 'warning';
            var n_msg = spin + '正在处理，请稍候...';
            var n_con;
            _this.attr('disabled', true).html(spin + '请稍候...');
            if (notice) {
                _notice.html('<div style="padding: 10px;margin: 0;" class="notice"></div>');
                notice = spin + notice;
            }
            _notice
                .find('.notice')
                .html(notice || n_msg)
                .removeClass('notice-error notice-info')
                .addClass('notice-warning');
            $.ajax({
                type: 'POST',
                url: ajax_url,
                data: _data,
                dataType: 'json',
                error: function (n) {
                    n_con = '<div style="padding: 10px;margin: 0;" class="notice notice-error"><b>' + '保存时发生错误，请排除插件和子主题，或通过错误日志进行排查！错误信息已输出至浏览器控制台，请对照分析。 ' + n.status + '|' + n.statusText + '</b></div>';
                    if (n.responseText && n.responseText.indexOf('致命错误') > -1) {
                        n_con = '<div style="padding: 10px;margin: 0;" class="notice notice-error"><b>网站遇到致命错误，请检查插件冲突或通过错误日志排除错误！错误信息已输出至浏览器控制台，请对照分析。 </b></div>';
                    }

                    console.error('保存时发生错误，以下是错误信息');
                    n.responseText && console.error(n.responseText);
                    console.error(n);

                    _notice.html(n_con);
                    _this.attr('disabled', false).removeClass('jb-blue').html('操作失败');
                    form.find('.progress').css('opacity', 0).find('.progress-bar').css({
                        width: '0',
                        transition: 'width .3s',
                    });
                },
                success: function (n) {
                    if (n.msg) {
                        n_type = n.error_type || (n.error ? 'error' : 'info');
                        n_con = '<div style="padding: 10px;margin: 0;" class="notice notice-' + n_type + '"><b>' + n.msg + '</b></div>';
                        _notice.html(n_con);
                    }
                    _this.attr('disabled', false).html(n.button || _tt);
                    if (n.reload) {
                        setTimeout(function () {
                            location.reload();
                        }, 300);
                    }
                    $.isFunction(success) && success(n, _this, _data);
                },
            });
        }

        function update_wait_for(_this) {
            var wait = 6,
                $submit_html = '<i class="fa fa-cloud-download fa-fw"></i>在线更新';

            function wait_ing() {
                if (wait > 0) {
                    _this.html('我已阅读更新提醒，确认更新 （' + wait + '）').attr('disabled', true);
                    wait--;
                    setTimeout(wait_ing, 1000);
                } else {
                    _this.html($submit_html).attr('disabled', false);
                    wait = 6;
                }
            }
            wait_ing();
        }

        $('body').on('click', '.online-update', function () {
            var _data = {};
            var _this = $(this);
            var _form = _this.parents('.ajax-form');
            var _progress = _form.find('.progress');
            var _notice = _form.find('.ajax-notice');

            if (_this.attr('disabled')) {
                return false;
            }

            //更新提醒
            if (!_this.attr('show-remind')) {
                _notice.html('<div style="padding:15px;margin:0;" class="notice notice-warning"><b><span class="c-red em12"><i class="fa fa-info-circle fa-fw" aria-hidden="true"></i> 更新提醒：</span><ul><li>更新主题会覆盖全部主题文件，如有修改过主题源码请自行备份</li><li>更新途中请勿刷新页面，避免出现文件损坏等意外</li><li>在线更新需要连接官方服务器，如连接失败请稍候再试</li><li>如您的网站套有CDN，请将CDN回源超时设置为60秒以上</li><li>如果在线更新失败，也可以使用手动更新哦，一样很简单</li><li class="c-yellow">涉及到文件替换，更新成功后可能会有几秒的白屏或者异常报错情况，稍等几秒后刷新即可</li><li class="c-red">更新主题涉及到各种兼容及未知问题，有极小概率会出现致命错误，请确认已知晓并接受此风险</li><li class="c-blue" style="margin: 10px 0 -15px 0;">确认更新请再次点击下方按钮</li></ul></b></div>');
                _this.attr('show-remind', true);
                update_wait_for(_this);
                return false;
            }

            _data.action = 'zibll_online_update';
            ajax_submit(
                _this,
                _data,
                function (n) {
                    update_file(n);
                },
                '正在获取更新文件，请稍候...'
            );
            var update_file = function (n) {
                if (n.error) {
                    //出现错误
                    _this.attr('disabled', false).html('<i class="fa fa-cloud-download fa-fw"></i> 在线更新').siblings('.ajax-submit').fadeIn(150);
                    _progress.css('opacity', 0).find('.progress-bar').css({
                        width: '0',
                        transition: 'width .3s',
                    });
                } else {
                    //未出现错误
                    if (n.action) {
                        _data = n;
                        ajax_submit(
                            _this,
                            _data,
                            function (n) {
                                update_file(n);
                            },
                            n.msg
                        );
                    }
                    if (n.progress) {
                        //进度条
                        _this.attr('disabled', true).siblings('.ajax-submit').fadeOut(150);
                        _progress.css('opacity', 1);
                        _progress.find('.progress-bar').css({
                            width: n.progress + '%',
                            transition: 'width .5s',
                        });
                    }
                    if (n.progress_end && n.progress_time) {
                        //进度条
                        setTimeout(function () {
                            _progress.find('.progress-bar').css({
                                width: n.progress_end + '%',
                                transition: 'width ' + n.progress_time + 's',
                            });
                        }, 500);
                    }
                }
            };
        });

        $('body').on('click', '.ajax-submit', function () {
            var _data = {};
            var _this = $(this);

            var confirm_text = _this.attr('data-confirm');

            if (confirm_text && confirm(confirm_text) != true) {
                return false;
            }

            var form = $(_this.parents('.ajax-form')[0]);
            if (_this.attr('disabled')) {
                return false;
            }
            form.find('input,[ajax-name],[name]').each(function () {
                var n = $(this).attr('ajax-name') || $(this).attr('name');
                var v = $(this).val() || $(this).find('option:selected').val();
                if (n) {
                    _data[n] = v;
                }
            });
            var is_aut = _this.attr('id') == 'authorization_submit' ? !0 : !1;
            return ajax_submit(_this, _data, function (n) {
                if (n.error && is_aut) {
                    form.find('.hide-box').slideDown(300);
                }
            });
        });

        $(window).on('scroll resize', function () {
            var Top = document.documentElement.scrollTop + document.body.scrollTop;
            var ontop = $('.csf-container');

            Top > 300 ? ontop.addClass('sticky-sm') : ontop.removeClass('sticky-sm');
        });
        var _wid = $(window).width();

        $(document).on('click', '.csf-menu', function () {
            $('.csf-nav-options').toggleClass('show');
        });

        $(document).on('click', '.remove-readonly', function () {
            var readonly_id = $(this).attr('readonly-id');
            $('[data-readonly-id=' + readonly_id + ']')
                .attr('readonly', false)
                .focus();
            $(this).slideUp(200);
        });

        if (_wid < 783) {
            $('.csf-nav-options').minitouch({
                direction: 'right',
                onEnd: function (e) {
                    e.removeClass('show');
                },
            });
        }
        //svg图标
        function show_svg() {
            var zib_svgs = [];
            zib_svgs['like'] = '<path d="M914.8609675 357.03388929a127.72961679 127.72961679 0 0 0-103.22061319-41.94810354l-200.07831191 3.29928854 21.68104159-77.29762723c19.79573404-85.78151462-20.03139801-168.02807537-94.26539927-195.36504236a126.07997321 126.07997321 0 0 0-161.90082481 74.46966663L291.0596813 353.73459937h-151.06030332a58.91587557 58.91587557 0 0 0-58.91587559 58.91587557v471.32700047a58.91587557 58.91587557 0 0 0 58.91587559 58.91587557h638.41242277a105.57724866 105.57724866 0 0 0 104.63459419-88.60947662l64.80746217-388.60911182a128.2009447 128.2009447 0 0 0-32.99288961-108.64087325zM275.97721821 872.19430084h-124.19466567V424.4336495h124.19466567z m602.12024323-418.06705027L813.52566185 843.44335425A35.34952507 35.34952507 0 0 1 778.41180075 872.19430084H351.38953789l-4.47760696-445.16835192a109.81919168 109.81919168 0 0 1 6.59857847-37.94182448L443.53396703 144.70107491a55.14525911 55.14525911 0 0 1 70.69905015-32.75722702 92.85141965 92.85141965 0 0 1 50.66765214 111.70449921l-47.13269963 166.84975833 296.93601058-4.71326954a58.68021163 58.68021163 0 0 1 62.4508267 68.34241468z"></path>';
            zib_svgs['view'] = '<path d="M512 146.285714c248.758857 0 457.142857 156.013714 512 365.714286-54.857143 209.700571-263.314286 365.714286-512 365.714286S54.857143 721.700571 0 512c54.784-209.700571 263.241143-365.714286 512-365.714286z m0 73.142857C312.027429 219.428571 139.849143 335.36 80.749714 498.395429L76.141714 512l4.608 13.677714c57.197714 157.696 220.306286 271.36 412.013715 278.528L512 804.571429c199.972571 0 372.150857-115.931429 431.250286-278.966858L947.785143 512l-4.534857-13.604571c-57.197714-157.769143-220.306286-271.433143-412.013715-278.674286L512 219.428571z"></path><path d="M511.5 689.8c-97.9 0-180.7-82.7-180.7-180.7s82.7-180.7 180.7-180.7 180.7 82.7 180.7 180.7-82.8 180.7-180.7 180.7z m0-279.6c-54.5 0-98.9 44.4-98.9 98.9 0 54.5 44.4 98.9 98.9 98.9 25.9 0 49.9-10.3 67.7-28.9 17.8-18.6 27.5-43.4 27.5-70 0.1-55.4-41.8-98.9-95.2-98.9z"></path>';
            zib_svgs['comment'] = '<path d="M176 193c-17.673 0-32 14.327-32 32v481c0 17.673 14.327 32 32 32h27c51.915 0 94 42.085 94 94v45.5a1.94 1.94 0 0 0 3.293 1.388l117.045-114.176A94 94 0 0 1 482.976 738H848c17.673 0 32-14.327 32-32V225c0-17.673-14.327-32-32-32H176z m0-80h672c61.856 0 112 50.144 112 112v481c0 61.856-50.144 112-112 112H482.976a14 14 0 0 0-9.776 3.978L356.156 936.154c-32.394 31.6-84.271 30.956-115.87-1.437A81.94 81.94 0 0 1 217 877.5V832c0-7.732-6.268-14-14-14h-27c-61.856 0-112-50.144-112-112V225c0-61.856 50.144-112 112-112z m336 438c-35.346 0-64-28.654-64-64 0-35.346 28.654-64 64-64 35.346 0 64 28.654 64 64 0 35.346-28.654 64-64 64z m228 0c-35.346 0-64-28.654-64-64 0-35.346 28.654-64 64-64 35.346 0 64 28.654 64 64 0 35.346-28.654 64-64 64z m-456 0c-35.346 0-64-28.654-64-64 0-35.346 28.654-64 64-64 35.346 0 64 28.654 64 64 0 35.346-28.654 64-64 64z" p-id="24020"></path>';
            zib_svgs['time'] = '<path d="M528.384 76.223488c-236.78976 0-428.736512 191.945728-428.736512 428.736512S291.59424 933.695488 528.384 933.695488s428.736512-191.945728 428.736512-428.736512S765.17376 76.223488 528.384 76.223488zM528.384 838.42048c-184.152064 0-333.461504-149.331968-333.461504-333.461504 0-184.152064 149.30944-333.461504 333.461504-333.461504 184.128512 0 333.461504 149.30944 333.461504 333.461504C861.84448 689.088512 712.512512 838.42048 528.384 838.42048z" p-id="2512"></path><path d="M576.02048 314.409984c26.331136 0 47.637504 21.32992 47.637504 47.637504l0 190.548992c0 26.331136-21.307392 47.637504-47.637504 47.637504-26.30656 0-47.637504-21.307392-47.637504-47.637504L528.382976 362.047488C528.384 335.739904 549.71392 314.409984 576.02048 314.409984z" p-id="2513"></path><path d="M385.471488 504.96 576.02048 504.96c26.331136 0 47.637504 21.32992 47.637504 47.637504 0 26.331136-21.307392 47.637504-47.637504 47.637504L385.471488 600.235008c-26.307584 0-47.637504-21.307392-47.637504-47.637504C337.833984 526.28992 359.163904 504.96 385.471488 504.96z" p-id="2514"></path>';
            zib_svgs['search'] = '<path d="M1010.896786 956.77807l-171.035567-183.288862c69.435335-84.241399 107.216326-190.947171 107.216326-300.205713 0-260.382506-212.390436-473.283495-473.79405-473.283495S0 212.90099 0 473.794049c0 261.403613 212.90099 473.794049 473.794049 473.79405 67.393119 0 134.275684-14.29551 196.052711-42.375977 9.700525-4.084431 16.84828-12.253294 20.422157-21.953819 3.573878-9.700525 3.063324-20.422157-1.021108-29.612128-4.084431-9.700525-12.253294-16.84828-21.953819-20.422157-9.700525-3.573878-20.422157-3.573878-29.612128 1.021108-51.565947 23.485481-107.72688 35.228221-163.887813 35.228221-218.006529 0-395.168744-177.162215-395.168743-395.168744S255.276966 79.13586 473.283495 79.13586s395.168744 177.162215 395.168744 395.168743c0 102.110787-39.312653 200.647695-110.279649 274.167462-7.147755 7.658309-10.721633 17.358834-11.232187 28.080466 0 10.721633 4.594985 20.422157 12.253295 28.080467 0.510554 0.510554 1.531662 1.021108 2.552769 1.531662 0.510554 0 0.510554 0.510554 1.021108 0.510553 0 0.510554 0.510554 0.510554 0.510554 1.021108 0.510554 1.531662 1.531662 2.55277 2.55277 3.573878l187.373293 200.647695c14.806064 15.316618 39.312653 16.337726 55.139825 1.531662 7.658309-7.147755 12.253294-16.84828 12.763848-27.059358 1.021108-11.74274-3.063324-21.443265-10.211079-29.612128z"></path>';
            zib_svgs['money'] = '<path d="M940.169 692.661c0 283.552-369.536 293.951-423.799 293.951h-13.107c-54.263 0-423.799-10.398-423.799-293.951 0-305.835 343.278-450.451 343.278-450.451s-115.038-40.633-115.038-126.703c0-69.905 171.092-72.701 198.486-72.701h7.34c27.394 0 198.486 2.796 198.486 72.701 0 86.202-115.038 126.703-115.038 126.703s343.19 144.442 343.19 450.451zM573.561 299.663c-19.442-8.459-32.789-27.502-32.789-49.661 0-23.282 14.734-43.123 35.386-50.707 15.317-5.582 69.625-32.059 75.653-66.268-16.034-10.529-68.027-22.981-138.455-22.981h-7.165c-70.43 0-122.334 12.496-138.455 22.85 6.073 34.515 61.167 61.167 75.279 66.147 21.027 7.705 35.76 27.546 35.76 50.828 0 22.16-13.347 41.202-32.442 49.525-3.276 1.359-300.852 130.858-300.852 388.021 0 220.463 298.101 231.561 357.87 231.561h13.020c59.725 0 357.87-11.185 357.87-231.561 0-258.474-297.534-386.619-300.505-387.886zM626.775 649.188c10.214 0.479 18.956 6.343 23.493 14.801 2.151 3.658 3.492 8.307 3.492 13.27 0 4.963-1.341 9.612-3.68 13.605-4.658 8.401-13.478 14.154-23.668 14.48l-89.684-0.015v70.822c-0.002 10.383-5.662 19.442-14.065 24.265-4.084 2.469-8.858 3.888-13.963 3.888-5.105 0-9.879-1.419-13.948-3.885-8.418-4.827-14.078-13.887-14.079-24.27v-70.821h-85.678c-14.85-0.854-26.57-13.105-26.57-28.093s11.719-27.239 26.494-28.090l85.709-0.003v-51.73h-87.819c-9.655 0-18.525-7.383-23.375-15.729-2.271-3.867-3.612-8.516-3.612-13.478 0-4.963 1.341-9.612 3.68-13.605 4.737-8.218 13.65-15.601 23.306-15.601h46.225l-44.564-42.423c-5.041-4.903-8.17-11.753-8.17-19.331 0-14.889 12.069-26.957 26.957-26.957 7.547 0 14.369 3.101 19.262 8.098l76.158 74.278 76.153-74.274c4.898-5.002 11.721-8.102 19.266-8.102 14.889 0 26.957 12.069 26.957 26.957 0 7.579-3.127 14.428-8.163 19.325l-44.571 42.43h46.225c14.898 0 26.957 14.331 26.957 29.229s-12.059 29.229-26.957 29.229h-87.819v51.73z"></path>';
            zib_svgs['tags'] = '<path d="M541.2 632.8c-91.1 0-171.8 41.5-223.3 105.5l231.8 231.8c28.1 28.1 73.8 28.1 101.9 0l155.7-155.7c-37.9-105.6-142.6-181.6-266.1-181.6z" fill="#4EEAAB"></path><path d="M970.2 549.8l-496-496a71.91 71.91 0 0 0-50.9-21.1c-2.4 0-4.9 0.1-7.3 0.4L126.9 62.6C92.9 66 66 92.9 62.6 126.9L33.1 416a71.99 71.99 0 0 0 20.7 58.2l495.9 495.9c14.1 14.1 32.5 21.1 50.9 21.1s36.9-7 50.9-21.1L970 651.6c28.3-28.1 28.3-73.7 0.2-101.8zM600.7 912.5l-491-491 28.8-283 283-28.8 491 491-311.8 311.8z"></path><path d="M310.8 210.4c-49.5 0-89.6 40.1-89.6 89.6s40.1 89.6 89.6 89.6 89.6-40.1 89.6-89.6-40.1-89.6-89.6-89.6z m0 102.4c-7.1 0-12.8-5.7-12.8-12.8 0-7.1 5.7-12.8 12.8-12.8 7.1 0 12.8 5.7 12.8 12.8 0 7.1-5.7 12.8-12.8 12.8z"></path>';
            zib_svgs['right'] = '<path d="M294.4 908.8 684.8 512 294.4 115.2c-25.6-25.6-25.6-70.4 0-96 25.6-25.6 70.4-25.6 96 0L832 460.8c12.8 12.8 19.2 32 19.2 51.2S844.8 544 832 563.2l-441.6 441.6c-25.6 25.6-70.4 25.6-96 0C262.4 979.2 262.4 934.4 294.4 908.8z" p-id="1915" data-spm-anchor-id="a313x.7781069.0.i2"></path>';
            zib_svgs['left'] = '<path d="M704 908.8 307.2 512 704 115.2c25.6-25.6 25.6-70.4 0-96-25.6-25.6-70.4-25.6-96 0L166.4 460.8C147.2 480 140.8 492.8 140.8 512s6.4 32 19.2 51.2l441.6 441.6c25.6 25.6 70.4 25.6 96 0C729.6 979.2 729.6 934.4 704 908.8z" p-id="2034" data-spm-anchor-id="a313x.7781069.0.i4"></path>';
            zib_svgs['reply'] = '<path d="M415.937331 320 415.937331 96 20.001331 438.176C-6.718669 461.28-6.622669 498.784 20.033331 521.824L415.937331 864 415.937331 640C639.937331 640 847.937331 688 1023.937331 928 943.937331 480 607.937331 320 415.937331 320" p-id="4051" data-spm-anchor-id="a313x.7781069.0.i0"></path>';
            zib_svgs['circle'] = '<path d="M908.548 205.661L582.454 20.479c-21.959-12.5-46.417-18.694-70.876-18.694-24.458 0-48.917 6.194-70.875 18.693L114.591 205.661c-44.496 25.298-71.976 72.312-71.976 123.281v367.902c0 50.932 27.48 97.982 71.976 123.242l326.112 185.223C462.661 1017.77 487.12 1024 511.578 1024c24.459 0 48.917-6.23 70.876-18.691l326.094-185.223c44.514-25.26 71.975-72.311 71.975-123.242V328.942c-0.001-50.969-27.461-97.983-71.975-123.281zM548.257 945.83a74.699 74.699 0 0 1-36.679 9.664 74.6 74.6 0 0 1-36.679-9.664L235.427 809.826c15.597-8.58 31.623-14.551 45.26-15.709 16.53-1.418 39.645-7.162 64.123-13.246 9.179-2.313 18.414-4.588 27.145-6.604 51.547-11.902 68.749-22.723 77.199-29.85a34.271 34.271 0 0 0 12.202-26.865c-0.504-22.5-8.209-44.402-22.425-63.619-2.258-3.955-5.317-7.424-8.993-10.223-46.827-35.635-74.793-97.236-74.793-164.734 0-106.64 70.503-193.393 157.162-193.393 86.64 0 157.123 86.64 157.123 193.204 0 67.35-27.966 128.803-74.793 164.438-2.238 1.68-4.328 3.768-6.101 5.969-16.306 20.41-24.794 42.76-25.297 66.379a34.32 34.32 0 0 0 12.014 26.717c7.594 6.455 23.173 15.484 76.66 27.908 32.237 7.539 69.475 14.031 90.52 15.822 17.816 1.566 37.76 8.357 55.503 17.982L548.257 945.83z m363.35-248.986c0 26.268-14.273 50.744-37.257 63.805l-9.981 5.672c-0.337-0.299-0.466-0.709-0.803-0.971-32.312-26.342-75.37-44.104-115.184-47.537-17.574-1.529-52.275-7.686-80.745-14.326-11.978-2.762-21.249-5.225-28.282-7.24 0.355-0.559 0.728-1.117 1.138-1.715 61.361-48.844 97.87-129.027 97.87-215.743 0-144.324-101.415-261.709-226.057-261.709-124.68 0-226.077 117.46-226.077 261.898 0 86.49 36.193 166.525 97.087 215.406a52.32 52.32 0 0 1 3.283 5c-7.239 2.313-17.071 5.111-30.242 8.133-9.123 2.127-18.73 4.516-28.264 6.902-19.832 4.926-42.293 10.484-53.32 11.455-34.477 2.947-73.281 20.297-105.8 46.193l-20.186-11.418c-22.965-13.061-37.256-37.537-37.256-63.805V328.942c0-26.306 14.291-50.745 37.256-63.804l326.112-185.22a74.608 74.608 0 0 1 36.679-9.664 74.701 74.701 0 0 1 36.679 9.664l326.094 185.22c22.983 13.06 37.257 37.499 37.257 63.804v367.902z" p-id="6675"></path>';
            zib_svgs['add'] = '<path d="M861.541 469.516h-307.058v-307.058c0-23.464-19.020-42.484-42.484-42.484-23.463 0-42.484 19.020-42.484 42.484v307.058h-307.058c-23.464 0-42.484 19.020-42.484 42.484 0 23.463 19.020 42.484 42.484 42.484h307.058v307.058c0 23.463 19.020 42.484 42.484 42.484 23.463 0 42.484-19.021 42.484-42.484v-307.058h307.058c23.463 0 42.484-19.020 42.484-42.484-0.001-23.463-19.022-42.484-42.485-42.484z"></path>';
            zib_svgs['add-ring'] = '<path d="M512 1024C229.229714 1024 0 794.770286 0 512S229.229714 0 512 0s512 229.229714 512 512-229.229714 512-512 512z m0-928C282.258286 96 96 282.258286 96 512S282.258286 928 512 928 928 741.741714 928 512 741.741714 96 512 96z m208.018286 463.981714h-160v160.036572a48.018286 48.018286 0 0 1-96.036572 0v-160.036572H303.981714a47.981714 47.981714 0 0 1 0-95.963428h160V304.018286a48.018286 48.018286 0 0 1 96.036572 0v160h160a47.981714 47.981714 0 0 1 0 95.963428z"></path>';
            zib_svgs['post'] = '<path d="M260.737 62c-89.263 0-157.827 78.218-157.827 168.382v573.463c0 90.246 67.909 158.154 158.073 158.154h491.809c90 0 168.3-68.237 168.3-158.727v-490.746l-250.527-250.527h-409.827zM260.982 880.182c-45 0-76.254-31.337-76.254-76.337v-573.463c0-44.754 31.663-86.563 76.009-86.563h333.082v168.054c0 46.554 31.827 77.4 77.4 77.4h168.054v414c0 45.327-41.646 76.909-86.482 76.909h-491.809zM716.546 716.546c22.593 0 40.909-18.316 40.909-40.909 0-22.593-18.316-40.909-40.909-40.909h-409.091c-22.593 0-40.909 18.316-40.909 40.909 0 22.593 18.316 40.909 40.909 40.909h409.091zM716.546 552.909c22.593 0 40.909-18.316 40.909-40.909s-18.316-40.909-40.909-40.909h-409.091c-22.593 0-40.909 18.316-40.909 40.909 0 22.593 18.316 40.909 40.909 40.909h409.091zM471.091 389.273c22.593 0 40.909-18.316 40.909-40.909s-18.316-40.909-40.909-40.909h-163.637c-22.593 0-40.909 18.316-40.909 40.909s18.316 40.909 40.909 40.909h163.637z"></path>';
            zib_svgs['favorite'] = '<g style="transform: scale(1.05);transform-origin: center;-webkit-transform-origin: center;-webkit-transform: scale(1.05);"><path d="M950.4 508c43.2-41.6 44-110.4 2.4-153.6-16.8-16.8-38.4-28-62.4-32l-176.8-25.6c-11.2-1.6-21.6-8.8-26.4-19.2L608 116.8c-26.4-53.6-92-76-145.6-49.6-21.6 10.4-38.4 28-49.6 49.6l-79.2 160.8c-4.8 10.4-15.2 17.6-26.4 19.2l-176.8 25.6c-59.2 8.8-100.8 64-92 123.2 3.2 24 14.4 45.6 32 62.4l128 124.8c8 8 12 20 10.4 31.2l-30.4 176.8c-10.4 59.2 29.6 115.2 88 125.6 24 4 48 0 69.6-11.2L492.8 872c10.4-5.6 22.4-5.6 32.8 0l158.4 83.2c52.8 28 119.2 7.2 146.4-45.6 11.2-20.8 15.2-45.6 11.2-68.8L812 664c-1.6-11.2 1.6-23.2 10.4-31.2l128-124.8z m-179.2 72c-25.6 24.8-37.6 60.8-31.2 96l30.4 176.8c3.2 19.2-9.6 37.6-28.8 40.8-8 1.6-15.2 0-22.4-3.2L560 807.2c-32-16.8-69.6-16.8-100.8 0l-158.4 83.2c-17.6 8.8-38.4 2.4-48-15.2-4-7.2-4.8-14.4-3.2-22.4L280 676c6.4-35.2-5.6-71.2-31.2-96L120 455.2c-14.4-13.6-14.4-36-0.8-50.4 5.6-5.6 12.8-9.6 20-10.4l176.8-25.6c35.2-4.8 65.6-27.2 81.6-59.2l79.2-160.8c8.8-17.6 29.6-24.8 47.2-16 7.2 3.2 12.8 8.8 16 16l79.2 160.8c16 32 46.4 54.4 81.6 59.2l176.8 25.6c19.2 3.2 32.8 20.8 29.6 40-0.8 8-4.8 15.2-10.4 20L771.2 580z"></path><path d="M355.2 646.4c0 20 16 36 36 36h236.8c20 0 36-16 36-36s-16-36-36-36H391.2c-20 0-36 16-36 36z" style="opacity:.6;"></path></g>';
            zib_svgs['menu'] = '<path d="M230.60033 921.5c-28.3 0.3-51.4-22.4-51.7-50.6-0.3-28.3 22.4-51.4 50.6-51.7H972.80033c28.3 0.3 50.9 23.5 50.6 51.7-0.3 27.8-22.8 50.3-50.6 50.6H230.60033zM51.40033 563.2C23.10033 563.2 0.20033 540.3 0.20033 512c0-28.3 22.9-51.2 51.2-51.2h921.4c28.3 0 51.2 22.9 51.2 51.2 0 28.3-22.9 51.2-51.2 51.2H51.40033z m0-358.3c-28.3 0.1-51.3-22.7-51.4-51-0.1-28.3 22.7-51.3 51-51.4h921.9c28.3 0.1 51.1 23.1 51 51.4-0.1 28.1-22.9 50.8-51 51H51.40033z"></path>';
            zib_svgs['d-qq'] = '<path d="M889.6 782.933c-12.8 2.134-42.667-25.6-61.867-76.8-14.933 57.6-42.666 104.534-81.066 140.8 46.933 12.8 76.8 34.134 76.8 61.867 0 40.533-66.134 72.533-147.2 72.533-61.867 0-113.067-17.066-136.534-44.8H512c-10.667 0-21.333 0-32-2.133-21.333 27.733-74.667 44.8-136.533 44.8-81.067 0-147.2-32-147.2-72.533 0-27.734 34.133-51.2 81.066-64C241.067 806.4 211.2 759.467 196.267 704c-21.334 51.2-49.067 78.933-61.867 78.933-17.067-2.133-34.133-53.333-25.6-134.4 6.4-51.2 34.133-119.466 64-138.666v-19.2c4.267-49.067 12.8-93.867 34.133-96-2.133-17.067-4.266-36.267-4.266-53.334C204.8 177.067 347.733 42.667 512 42.667s307.2 134.4 307.2 298.666c0 19.2-2.133 36.267-4.267 53.334 17.067 0 32 44.8 36.267 96v19.2c29.867 25.6 57.6 87.466 61.867 136.533 12.8 83.2-4.267 134.4-23.467 136.533z"></path>';
            zib_svgs['d-weibo'] = '<path d="M996.243 460.502c0 0.03 0 0.091 0 0.152-6.479 19.983-27.916 30.943-47.838 24.465-19.983-6.48-30.944-27.917-24.464-47.959l-0.062-0.03c19.862-61.524 7.267-131.707-38.996-183.179-46.325-51.472-114.632-71.152-177.729-57.709-20.529 4.391-40.755-8.75-45.114-29.308-4.359-20.558 8.721-40.814 29.248-45.205l0 0c88.713-18.923 184.874 8.69 250.031 81.144C1006.477 275.265 1024.037 373.939 996.243 460.502zM733.072 318.107l0-0.03c-17.621 3.845-35.001-7.479-38.756-25.16-3.814-17.712 7.509-35.182 25.131-38.937 43.236-9.235 90.105 4.178 121.775 39.451 31.791 35.304 40.269 83.354 26.705 125.531-5.571 17.258-23.98 26.644-41.177 21.133-17.198-5.571-26.585-24.101-21.014-41.298l-0.061 0c6.661-20.648 2.482-44.145-13.02-61.403C777.156 320.166 754.205 313.657 733.072 318.107zM524.853 378.239c100.976-42.419 189.143-44.932 221.359 1.241 17.138 24.585 15.501 59.071-0.303 99.038-7.327 18.408 2.24 21.285 16.229 25.493C818.999 521.693 882.4 564.506 882.4 639.896c0 124.865-179.545 282.065-449.348 282.065-205.825 0-416.224-100.036-416.224-264.564 0-86.049 54.348-185.51 147.936-279.4 124.955-125.288 270.681-182.362 325.483-127.348 24.191 24.192 26.522 66.186 10.991 116.266C493.123 392.136 524.853 378.178 524.853 378.239zM395.024 471.373c-164.225 16.289-288.787 117.173-278.099 225.263 10.658 108.151 152.447 182.634 316.672 166.346 164.256-16.29 288.756-117.113 278.099-225.326C701.037 529.564 559.279 455.083 395.024 471.373zM327.384 816.535C248.42 790.98 214.994 712.804 249.57 642.318c33.941-69.033 122.291-108.091 200.437-87.684 80.902 20.951 122.17 97.493 89.108 171.794C505.597 802.486 409.194 842.998 327.384 816.535zM371.982 668.479c-25.433-10.658-58.315 0.303-73.997 25.008-15.896 24.768-8.418 54.319 16.834 65.824 25.614 11.747 59.616 0.605 75.512-24.828C405.923 708.808 397.718 679.5 371.982 668.479zM434.687 642.441c-9.779-3.877-21.981 0.785-27.703 10.414-5.542 9.689-2.482 20.71 7.295 24.768 9.962 4.117 22.648-0.666 28.4-10.477C448.161 657.216 444.588 646.074 434.687 642.441z" p-id="3731" data-spm-anchor-id="a313x.7781069.0.i4"></path>';
            zib_svgs['d-wechat'] = '<path d="M670.564352 367.904768c10.274816 0 20.453376 0.751616 30.539776 1.878016-27.439104-127.772672-164.050944-222.703616-319.975424-222.703616-174.32576 0-317.126656 118.816768-317.126656 269.703168 0 87.095296 47.511552 158.611456 126.900224 214.081536L159.1808 726.26176l110.860288-55.59296c39.66976 7.856128 71.503872 15.9232 111.087616 15.9232 9.955328 0 19.820544-0.49152 29.607936-1.255424-6.201344-21.202944-9.787392-43.411456-9.787392-66.445312-0.002048-138.555392 118.976512-250.986496 269.615104-250.986496z m-170.512384-85.981184c23.877632 0 39.694336 15.712256 39.694336 39.571456 0 23.769088-15.816704 39.696384-39.694336 39.696384-23.775232 0-47.622144-15.925248-47.622144-39.696384 0-23.86944 23.851008-39.571456 47.622144-39.571456z m-221.949952 79.265792c-23.764992 0-47.753216-15.925248-47.753216-39.70048 0-23.863296 23.988224-39.56736 47.753216-39.56736 23.771136 0 39.58784 15.702016 39.58784 39.56736 0 23.775232-15.816704 39.70048-39.58784 39.70048z" p-id="2048"></path><path d="M960 615.069696c0-126.785536-126.871552-230.127616-269.365248-230.127616-150.888448 0-269.727744 103.340032-269.727744 230.127616 0 127.008768 118.837248 230.135808 269.727744 230.135808 31.578112 0 63.4368-7.964672 95.15008-15.919104l86.984704 47.634432-23.846912-79.251456c63.65184-47.755264 111.077376-111.079424 111.077376-182.59968z m-356.818944-39.677952c-15.792128 0-31.721472-15.70816-31.721472-31.735808 0-15.798272 15.929344-31.709184 31.721472-31.709184 23.988224 0 39.696384 15.910912 39.696384 31.709184 0 16.027648-15.70816 31.735808-39.696384 31.735808z m174.434304 0c-15.67744 0-31.496192-15.70816-31.496192-31.735808 0-15.798272 15.818752-31.709184 31.496192-31.709184 23.771136 0 39.696384 15.910912 39.696384 31.709184 0 16.027648-15.925248 31.735808-39.696384 31.735808z"></path>';
            zib_svgs['d-email'] = '<path d="M512.012 630.535L927.56 284.31c-2.251-0.41-4.274-1.348-6.61-1.348H103.074c-2.288 0-4.323 0.927-6.574 1.348l415.512 346.226z m446.122-310.391c0-3.9-1.072-7.513-2.252-11.066L661.313 554.602l295.014 295.075c0.759-2.974 1.807-5.84 1.807-9.055V320.144z m-889.98-11.102c-1.144 3.577-2.288 7.14-2.288 11.102V840.61c0 3.25 1.12 6.105 1.855 9.079L362.83 554.59 68.154 309.042z" p-id="2793"></path><path d="M632.583 578.493l-108.698 90.539c-3.408 2.902-7.622 4.299-11.873 4.299-4.214 0-8.453-1.397-11.897-4.3l-108.601-90.49L94.079 875.963c2.926 0.77 5.828 1.842 8.995 1.842h817.888c3.227 0 6.129-1.06 9.115-1.842l-297.494-297.47z"></path>';
            zib_svgs['user'] = '<path d="M603.136 505.856c-7.168 2.048-13.312 5.12-19.456 7.168-20.48 8.192-38.912 14.336-70.656 14.336-31.744 0-49.152-7.168-70.656-14.336-6.144-2.048-13.312-5.12-20.48-7.168-21.504-7.168-45.056 4.096-52.224 25.6-6.144 22.528 5.12 45.056 26.624 52.224 6.144 2.048 11.264 4.096 16.384 6.144 23.552 9.216 53.248 20.48 99.328 20.48 46.08 0 75.776-11.264 99.328-20.48 5.12-2.048 11.264-4.096 16.384-6.144 21.504-7.168 32.768-30.72 25.6-52.224-6.144-20.48-28.672-32.768-50.176-25.6z"></path><path d="M921.6 418.816c0-226.304-183.296-409.6-409.6-409.6s-409.6 183.296-409.6 409.6c0 174.08 109.568 322.56 263.168 381.952-48.128 40.96-78.848 102.4-78.848 171.008 0 22.528 18.432 40.96 40.96 40.96s40.96-18.432 40.96-40.96c0-78.848 64.512-143.36 143.36-143.36s143.36 64.512 143.36 143.36c0 22.528 18.432 40.96 40.96 40.96s40.96-18.432 40.96-40.96c0-68.608-30.72-129.024-78.848-171.008 153.6-59.392 263.168-207.872 263.168-381.952z m-409.6 327.68c-180.224 0-327.68-147.456-327.68-327.68s147.456-327.68 327.68-327.68 327.68 147.456 327.68 327.68-147.456 327.68-327.68 327.68z"></path>';
            zib_svgs['theme'] = '<path d="M512 33.408c288.832 0 480 227.008 480 428.16 0 126.528-84.864 225.6-186.048 264.576-23.36 8.96-52.224 14.464-86.016 17.28-31.68 2.56-63.104 2.752-99.392 1.472l-20.672-0.64c-6.4 0-21.248 16.256-21.248 42.88 0 10.496 0.384 11.456 6.08 17.472l3.392 3.584c18.176 19.648 26.496 41.28 26.496 79.68 0 45.184-23.232 76.16-59.328 91.712-19.52 8.384-38.4 11.072-52.736 10.88-291.776 0-470.528-237.12-470.528-480C32 269.568 215.936 33.472 512 33.472z m87.872 646.784c3.2 0 29.76 1.024 23.04 0.768 33.92 1.152 63.104 1.024 91.712-1.28 28.224-2.432 51.584-6.784 68.288-13.248 78.528-30.272 145.088-107.904 145.088-204.8 0-168.064-165.184-364.224-416-364.224-256.704 0-416 204.416-416 413.12 0 210.752 154.688 416 406.848 416 6.464 0 17.216-1.472 27.008-5.76 13.952-5.952 20.736-14.976 20.736-32.896 0-22.4-2.304-28.48-9.472-36.224l-3.008-3.2c-16.192-17.152-23.488-33.28-23.488-61.376 0-60.672 42.112-106.88 85.248-106.88zM238.912 512a77.76 77.76 0 1 1-0.064-155.52 77.76 77.76 0 0 1 0 155.52z m146.688-192.512a77.76 77.76 0 1 1-0.064-155.52 77.76 77.76 0 0 1 0.064 155.52z m249.472 0a77.824 77.824 0 1 1 0.064-155.648 77.824 77.824 0 0 1 0 155.648zM783.232 512a77.824 77.824 0 1 1 0-155.648 77.824 77.824 0 0 1 0 155.648z"></path>';
            zib_svgs['signout'] = '<path d="M630.093 487.772L450.318 314.694c-14.382-13.851-35.955-13.851-50.336 0-14.382 13.842-14.382 34.614 0 48.465l118.647 114.228H173.461c-21.573 0-35.955 13.842-35.955 34.614s14.382 34.614 35.955 34.614h345.168L399.99 660.843c-14.382 13.851-14.382 34.623 0 48.465 7.192 6.93 14.382 10.386 25.164 10.386 10.792 0 17.982-3.465 25.173-10.386l179.775-176.535s0-3.465 3.6-3.465c10.782-10.386 10.782-31.149-3.6-41.535z"></path><path d="M170.99 269.693c21.573 0 35.955-13.851 35.955-34.614v-69.237c0-20.763 14.382-34.614 35.955-34.614h611.235c21.573 0 35.955 13.851 35.955 34.614v692.317c0 20.763-14.382 34.614-35.955 34.614H242.9c-21.573 0-35.955-13.851-35.955-34.614v-69.237c0-20.764-14.382-34.614-35.955-34.614s-35.955 13.851-35.955 34.614v69.237c0 58.842 46.736 103.842 107.865 103.842h611.235c61.119 0 107.865-45 107.865-103.842V165.842C962 107 915.253 62 854.135 62H242.9c-61.128 0-107.865 45-107.865 103.842v69.237c0 20.764 14.382 34.614 35.955 34.614z"></path>';
            zib_svgs['set'] = '<path d="M973.4144 422.4c-6.9632-36.352-26.112-58.88-61.44-71.5776-60.928-21.8112-81.92-60.1088-70.4512-125.2352 6.656-37.5808-2.1504-68.1984-31.3344-93.9008-39.5264-35.0208-82.944-62.976-131.8912-83.0464-39.1168-16.0768-72.3968-11.776-104.0384 17.7152-41.3696 38.6048-83.8656 43.1104-124.1088 6.5536-47.0016-42.5984-92.4672-41.5744-142.5408-10.9568-28.4672 17.408-56.7296 35.1232-84.8896 52.9408-44.032 27.7504-60.5184 65.4336-52.4288 118.4768 9.6256 63.2832-8.192 90.624-66.56 115.9168-32.8704 14.2336-57.0368 36.2496-63.3856 71.7824-10.1376 55.7056-12.6976 111.8208-3.072 168.7552 7.5776 44.4416 26.5216 73.8304 71.68 88.064 51.2 16.1792 75.0592 63.7952 64.6144 117.0432-1.9456 9.9328-3.3792 19.968-3.072 18.2272-2.1504 36.864 8.4992 57.1392 25.8048 73.8304 45.568 44.032 98.5088 76.0832 158.6176 96.5632 29.184 9.9328 54.4768 1.9456 77.7216-15.1552 73.728-54.4768 82.3296-54.5792 158.4128 2.56 25.1904 18.944 51.4048 24.9856 81.408 11.8784 52.224-22.8352 100.7616-51.712 144.1792-88.6784 26.4192-22.528 36.7616-50.4832 30.4128-85.504-13.2096-72.192 2.6624-102.7072 67.4816-131.1744 34.7136-15.2576 56.2176-40.0384 62.2592-77.6192 9.5232-59.2896 7.9872-118.3744-3.3792-177.4592zM850.7392 620.7488c-69.8368 33.6896-95.1296 100.352-85.1968 175.7184 3.7888 28.672-4.3008 43.52-25.8048 56.7296-13.6192 8.3968-27.2384 16.6912-40.2432 26.0096-33.28 23.8592-61.1328 30.1056-99.1232-0.512-56.7296-45.7728-137.5232-40.8576-193.024 7.0656-23.7568 20.48-42.3936 19.7632-65.6384 6.5536-17.6128-10.0352-35.1232-20.3776-52.3264-31.1296-28.7744-17.8176-43.7248-36.864-35.7376-77.4144 13.6192-69.12-37.6832-149.8112-106.9056-176.9472-25.1904-9.8304-33.5872-24.7808-34.816-47.616-1.3312-24.6784-1.7408-49.3568-1.1264-74.0352 0.7168-33.4848 10.4448-56.5248 46.6944-73.3184 68.608-31.5392 100.4544-92.672 91.8528-167.6288-4.608-40.3456 9.4208-62.7712 41.6768-80.2816 14.0288-7.5776 27.7504-15.872 40.96-24.7808 28.0576-18.944 49.7664-20.2752 79.6672 4.7104 58.88 49.152 143.36 46.1824 200.192-4.5056 22.528-20.0704 39.0144-18.0224 60.5184-5.632 13.824 7.9872 28.16 15.0528 41.6768 23.552 32.8704 20.8896 53.3504 42.1888 46.7968 90.3168-9.0112 65.8432 20.5824 129.7408 81.1008 156.4672 59.0848 26.112 65.024 65.4336 61.3376 119.6032 5.9392 42.8032-4.5056 73.8304-52.5312 97.0752z"></path><path d="M507.1872 321.024c-100.2496-1.4336-187.5968 87.4496-187.392 190.7712 0.2048 103.6288 87.6544 192.3072 187.6992 190.3616 98.9184-1.8432 184.1152-90.112 184.0128-190.6688 0-99.9424-86.2208-189.0304-184.32-190.464z m-3.2768 299.008c-58.6752-1.2288-107.2128-52.3264-105.2672-110.8992 2.048-59.2896 51.3024-105.472 111.104-104.0384 56.6272 1.4336 104.0384 50.688 103.3216 107.4176-0.7168 58.368-52.0192 108.7488-109.1584 107.52z"></path>';
            zib_svgs['signup'] = '<path d="M722.6 645.295c17.497-26.999 9.793-63.072-17.206-80.567a433.17 433.17 0 0 0-69.045-36.377c69.66-51.387 114.937-134.006 114.937-227.013 0-155.467-126.483-281.951-281.951-281.951S187.384 145.87 187.384 301.338c0 92.95 45.223 175.527 114.811 226.919-51.763 21.557-99.309 53.261-140.153 94.103-82.08 82.08-127.284 191.213-127.284 307.292 0 32.174 26.082 58.254 58.254 58.254s58.254-26.08 58.254-58.254c0-175.385 142.685-318.068 318.068-318.068 61.579 0 121.298 17.606 172.699 50.915 27.002 17.498 63.074 9.793 80.567-17.206zM469.334 135.897c91.225 0 165.442 74.218 165.442 165.442s-74.218 165.442-165.442 165.442c-91.225 0-165.442-74.217-165.442-165.442s74.218-165.442 165.442-165.442zM926.63 743.197h-66.992v-66.992c0-32.174-26.08-58.254-58.254-58.254s-58.254 26.08-58.254 58.254v66.992h-66.992c-32.174 0-58.254 26.08-58.254 58.254s26.08 58.254 58.254 58.254h66.992v66.992c0 32.174 26.08 58.254 58.254 58.254s58.254-26.08 58.254-58.254v-66.992h66.992c32.174 0 58.254-26.08 58.254-58.254s-26.08-58.254-58.254-58.254z"></path>';
            zib_svgs['user_rp'] = '<path d="M523.56129 558.245161c-45.419355 0-82.580645 37.16129-82.580645 82.580645 0 33.032258 18.993548 61.109677 47.070968 74.322581v90.83871c0 19.819355 15.690323 35.509677 35.509677 35.509677s35.509677-15.690323 35.509678-35.509677v-90.83871c28.077419-13.212903 47.070968-41.290323 47.070967-74.322581-0.825806-45.419355-37.16129-82.580645-82.580645-82.580645z m341.058065-164.335484H157.729032c-38.812903 0-71.019355 31.380645-71.019355 71.019355v471.535484c0 38.812903 31.380645 71.019355 71.019355 71.019355h706.890323c38.812903 0 71.019355-31.380645 71.019355-71.019355V464.103226c0-38.812903-32.206452-70.193548-71.019355-70.193549z m0 494.658065c0 38.812903-8.258065 47.070968-47.070968 47.070968H204.8c-38.812903 0-47.070968-8.258065-47.070968-47.070968V511.174194c0-38.812903 8.258065-47.070968 47.070968-47.070968H817.548387c38.812903 0 47.070968 8.258065 47.070968 47.070968v377.393548zM177.548387 358.4c19.819355 0 35.509677-15.690323 36.335484-35.509677C246.090323 187.458065 366.658065 87.535484 512 87.535484c113.135484 0 211.406452 61.935484 264.258065 152.774193 5.780645 12.387097 18.167742 21.470968 32.206451 21.470968 19.819355 0 35.509677-15.690323 35.509678-35.509677 0-7.432258-2.477419-14.864516-6.606452-20.645162C772.129032 92.490323 650.735484 16.516129 511.174194 16.516129 328.670968 16.516129 177.548387 142.03871 142.03871 313.806452c0 0.825806 0 1.651613-0.825807 2.477419 0 0.825806 0 1.651613-0.825806 2.477419v3.303226c0.825806 19.819355 17.341935 36.335484 37.16129 36.335484z m0 0"></path>';
            zib_svgs['close'] = '<path d="M573.44 512.128l237.888 237.696a43.328 43.328 0 0 1 0 59.712 43.392 43.392 0 0 1-59.712 0L513.728 571.84 265.856 819.712a44.672 44.672 0 0 1-61.568 0 44.672 44.672 0 0 1 0-61.568L452.16 510.272 214.208 272.448a43.328 43.328 0 0 1 0-59.648 43.392 43.392 0 0 1 59.712 0l237.952 237.76 246.272-246.272a44.672 44.672 0 0 1 61.568 0 44.672 44.672 0 0 1 0 61.568L573.44 512.128z" p-id="35424" data-spm-anchor-id="a313x.7781069.0.i48"></path>';
            zib_svgs['pan_baidu'] = '<path d="M1008.45542717 705.56838367c0 133.69628798-108.3823688 242.0786568-242.0786568 242.0786568-58.29538853 0-111.75541773-20.63131534-153.53741716-54.95832779-15.23567982-11.3243619-25.10886432-29.45747728-25.10886432-49.89927221 0-34.31795067 27.81988637-62.13783703 62.13783703-62.13783705 15.29626421 0 29.2925531 5.53725801 40.11877667 14.70336569l0.08699297-0.09709037c20.55959792 17.50992466 47.18074185 28.11348765 76.30267481 28.11348765 65.06064555 0 117.80298272-52.74233717 117.80298272-117.80298272s-52.74233717-117.80298272-117.80298272-117.80298271c-31.58103786 0-60.23383015 12.45061019-81.38244299 32.68476118l-3.72878802 3.72878804c-1.17906546 1.23265934-2.33767721 2.48499566-3.46263098 3.76762419l-144.2234732 144.2232143c-0.02278387-0.07974355-0.04142523-0.16078165-0.0642091-0.24078412l-100.65837677 100.65863566c-44.08912555 46.24349614-106.29609093 75.05914134-175.23361968 75.05914134-133.69628798 0-242.0786568-108.3823688-242.0786568-242.07865678 0-133.41123067 107.92151318-241.61236411 241.22452045-242.07321974a259.95985503 259.95985503 0 0 1-2.2527555-34.18124742c0-142.27571092 115.33740512-257.61311605 257.61311605-257.61311606s257.61311605 115.33740512 257.61311604 257.61311606c0 11.58948333-0.77025027 22.99876693-2.2530144 34.18280086 133.18390974 0.60040685 240.96587169 108.74716969 240.9658717 242.0719252z m-868.63518026 0c0 65.06064555 52.74207826 117.80298272 117.80298272 117.80298272 33.27584736 0 63.32466973-13.80159033 84.74746576-35.98661051l-0.03158673-0.03158673 1.23602515-1.23576623c19.7507704-21.06679803 31.85107854-49.39284884 31.85107854-80.54876034 0-65.06064555-52.74207826-117.80298272-117.80298272-117.80298272-65.06090445-0.0002589-117.80298272 52.74207826-117.80298272 117.80272381z m372.30920692-409.59190913c-73.64032739 0-133.33744197 59.69737349-133.33744198 133.33744198 0 73.64032739 59.69711458 133.33744197 133.33744198 133.33744196s133.33744197-59.69711458 133.33744198-133.33744196c0-73.64006849-59.69711458-133.33744197-133.33744198-133.33744198z"></path>';
            zib_svgs['weiyun'] = '<path d="M987.909224 900.576653c10.971429-8.986122 21.545796-18.348408 31.681307-28.212245 96.193306-93.748245 149.169633-222.187102 149.169632-361.680979 0-14.524082-0.543347-28.88098-1.609143-43.070694a243.168653 243.168653 0 0 1 91.324082 189.962449c0 143.318204-103.006041 234.809469-270.607673 242.980571l0.041795 0.020898z m-532.500897 0.647837c-110.592 0-199.68-26.791184-257.609143-77.406041-50.823837-44.408163-77.656816-107.52-77.656817-182.522776 0-79.307755 28.065959-148.145633 79.119674-193.870367a211.800816 211.800816 0 0 1 142.774857-54.104816c8.463673 0 16.990041 0.459755 25.558204 1.421061 63.38351 7.000816 112.64 37.114776 135.188898 82.546939 16.509388 33.353143 15.610776 69.820082-2.507755 99.996734-14.085224 23.44751-33.248653 37.908898-56.967837 42.987103-27.397224 5.851429-60.666776-1.191184-84.78302-18.014041l-60.144327 104.155428c50.364082 31.764898 113.099755 43.509551 170.067592 31.305143 56.717061-12.099918 103.340408-46.205388 134.791837-98.617469 39.079184-64.992653 41.712327-145.387102 7.188898-215.123592-36.884898-74.396735-108.105143-125.680327-198.133551-143.777959a257.609143 257.609143 0 0 1 61.565387-84.365061c53.707755-48.817633 129.107592-75.692408 212.365062-75.692409 99.22351 0 190.840163 39.998694 257.94351 112.681796 67.37502 72.933878 104.489796 171.593143 104.489796 277.859266 0 106.788571-40.124082 204.716408-112.911674 275.602285-77.176163 75.190857-183.484082 114.938776-307.388081 114.938776h-172.95151z m677.302857-587.734204C1061.219265 127.749224 890.420245 0 686.226286 0c-113.204245 0-217.338776 37.971592-293.198368 106.976653a381.471347 381.471347 0 0 0-107.770775 170.819918A329.310041 329.310041 0 0 0 119.118367 357.982041C42.360163 426.736327 0 527.36 0 641.295673 0 751.992163 41.085388 846.367347 118.742204 914.285714c80.164571 70.029061 196.545306 107.081143 336.666123 107.081143h507.611428c248.602122 0 415.618612-146.181224 415.618612-363.791673 0-159.346939-103.026939-295.01649-245.885387-344.084898h-0.041796z"></path>';
            zib_svgs['lanzou'] = '<path d="M829.248 420.576C815.264 274.56 693.696 160 544 160c-115.808 0-214.944 68.736-260.672 167.36A142.72 142.72 0 0 0 240.032 320a144.032 144.032 0 0 0-144 144c0 15.808 3.168 30.752 7.872 44.928C42.048 544.992 0.032 611.168 0.032 687.936a208 208 0 0 0 208 208V896H784v-0.064c132.576 0 240-107.424 240-240 0-116.992-83.872-214.176-194.752-235.36zM784 831.936V832H208.032a144.256 144.256 0 0 1-144-144.064c0-51.2 26.976-97.44 72.128-123.744 43.872-25.184 46.88-30.176 28.48-75.424a78.56 78.56 0 0 1-4.608-24.736c0-44.128 35.872-80 80-80 0 0 20.992-1.504 43.296 7.36 36.704 14.624 40.704 0.64 58.048-37.088C378.08 275.168 457.6 224 544 224c115.2 0 210.432 87.136 221.568 202.688 3.936 45.824 3.936 45.824 51.68 56.736A175.872 175.872 0 0 1 960 655.936c0 97.056-78.944 176-176 176z"></path>';
            zib_svgs['onedrive'] = '<path d="M350.868 828.388c-60.274-15.06-93.856-62.97-93.962-134.064-0.032-22.726 1.612-33.62 7.286-48.236 13.908-35.834 50.728-62.872 99.176-72.822 24.11-4.95 31.536-10.266 31.536-22.572 0-3.862 2.872-15.36 6.378-25.552 15.932-46.306 45.43-84.91 76.948-100.702 32.99-16.526 49.642-20.254 89.548-20.04 56.674 0.304 84.952 12.598 124.496 54.128l21.75 22.842 19.484-6.742c94.3-32.636 188.306 22.916 195.888 115.756l2.072 25.398 18.57 6.65c53.032 19.004 77.96 58.904 73.442 117.556-2.958 38.358-20.89 68.98-49.3 84.184l-13.356 7.146-296.822 0.57c-228.094 0.44-300.6-0.368-313.134-3.5zM103.218 785.966c-36.176-9.086-74.506-42.854-92.48-81.47C0.542 682.59 0 679.368 0 640.616c0-36.864 0.87-42.778 8.988-61.08 17.11-38.582 49.894-66.46 91.03-77.408 8.684-2.312 16.842-6 18.128-8.196 1.29-2.198 2.722-14.164 3.182-26.592 2.866-77.196 50.79-145.214 117.708-167.056 36.154-11.8 83.572-12.898 122.896 3.726 12.47 5.274 11.068 6.404 37.438-30.14 15.594-21.612 45.108-44.49 70.9-58.18 27.838-14.776 56.792-21.584 91.412-21.494 96.768 0.252 180.166 64.22 211.004 161.848 9.854 31.192 9.362 39.926-2.26 40.184-5.072 0.112-19.604 3.064-32.292 6.558l-23.072 6.358-21.052-22.25c-59.362-62.734-156.238-76.294-238.592-33.396-32.9 17.138-59.34 41.746-79.31 73.81-14.236 22.858-32.39 65.504-32.39 76.094 0 7.51-5.754 11.264-30.332 19.782-76.094 26.376-120.508 87.282-120.476 165.218 0.01 28.368 6.922 63.074 16.52 82.956 3.618 7.494 5.634 14.622 4.484 15.836-2.946 3.106-97.608 2.06-110.696-1.228z"></path>';
            zib_svgs['tianyi'] = '<path d="M838.4 416c-6.4-70.4-64-115.2-134.4-115.2-19.2 0-38.4 6.4-51.2 6.4-44.8-51.2-115.2-83.2-185.6-83.2-89.6 0-172.8 51.2-211.2 128h-12.8C115.2 352 19.2 448 12.8 576s96 224 224 230.4h294.4c25.6 0 44.8-19.2 44.8-44.8s-19.2-44.8-44.8-44.8H249.6c-70.4 0-134.4-57.6-134.4-128s51.2-128 121.6-134.4c12.8 0 25.6 0 38.4 6.4h6.4l25.6 6.4C320 390.4 390.4 320 473.6 320c57.6 0 108.8 32 140.8 83.2 6.4 6.4 6.4 12.8 6.4 19.2l6.4-6.4c19.2-19.2 51.2-19.2 70.4-19.2 44.8 0 70.4 38.4 70.4 76.8 0 12.8-6.4 25.6-6.4 38.4 12.8 6.4 19.2 19.2 38.4 19.2 6.4-6.4 19.2-12.8 19.2-19.2 64 6.4 115.2 57.6 108.8 128-6.4 57.6-57.6 108.8-121.6 108.8-51.2 0-96-32-115.2-83.2h51.2c6.4 0 12.8-6.4 12.8-12.8s0-6.4-6.4-6.4l-96-128c-6.4-6.4-12.8-12.8-19.2-6.4h-6.4l-96 128c-6.4 6.4-6.4 19.2 6.4 19.2 6.4 0 6.4 6.4 6.4 6.4h57.6c19.2 115.2 128 192 243.2 172.8 115.2-19.2 192-128 172.8-243.2-25.6-96-89.6-160-179.2-179.2z"></path>';
            zib_svgs['ctfile'] = '<path d="M732.719113 649.59415l128.975799 32.518323q-40.546284 158.91298-145.946298 242.363126T458.101875 1007.966394q-157.591923 0-256.305357-64.162716t-150.2753-185.821892Q0 636.281962 0 496.676736q0-152.246724 58.16715-265.634051t165.558912-172.204844Q330.99588 0 460.113947 0q146.332454 0 245.919818 74.46696t138.954859 209.438324l-126.984052 29.916857q-33.819056-106.35524-98.408575-154.909161T457.370213 110.359059q-112.37113 0-187.833963 53.858472t-106.050381 144.625242a581.793447 581.793447 0 0 0-30.587548 187.163273q0 124.362262 36.237607 217.08013t112.696313 138.629676a316.037452 316.037452 0 0 0 165.558912 45.891483q108.367311 0 183.504961-62.496152t101.822999-185.517033zM1194.58092 893.806756l14.023527 85.685781a360.973709 360.973709 0 0 1-73.288171 8.617356q-52.842275 0-81.905526-16.706289t-40.952763-43.92006q-11.869188-27.193448-11.848864-114.505145v-329.24802h-71.133831v-75.44251h71.133831v-141.779888l96.437152-58.187474v199.906391h97.554969v75.442509h-97.554969v334.69484q0 41.481186 5.121636 53.350373a40.42434 40.42434 0 0 0 16.706288 18.860628q11.584653 7.011763 33.148366 7.011763a314.757043 314.757043 0 0 0 42.558355-3.780255z"></path>';
            zib_svgs['vip_2'] = '<path d="M 1005.8172,351.70336 821.76656,101.2173 C 807.32558,81.588994 784.94516,70.064114 761.241,70.064114 H 259.20108 c -23.47379,0 -45.62431,11.284778 -60.06529,30.552936 L 19.285135,340.53863 c -22.9559861,30.61296 -21.3450398,74.07136 3.79723,102.76351 L 446.1382,928.77022 c 38.51883,40.57913 99.0787,40.87926 147.84328,-0.10692 L 1000.9268,454.40684 c 25.4875,-28.39202 27.5587,-71.85042 4.8904,-102.70348 z M 771.19435,468.39276 545.31666,727.28238 c -7.13419,8.22348 -17.26014,12.84544 -27.9039,12.84544 h -0.23013 c -10.70936,-0.0493 -20.88658,-4.8776 -27.96143,-13.26562 L 270.70784,469.95343 c -13.82618,-16.26491 -12.41002,-41.14051 3.16435,-55.58354 15.59983,-14.39456 39.41935,-12.91852 53.2763,3.3014 L 517.8155,641.86621 715.4441,415.39032 c 14.02155,-16.07753 37.88698,-17.23375 53.2763,-2.58109 15.38525,14.641 16.4925,39.518 2.47395,55.58353 z" fill="#8576e8" /><path d="M 761.18347,70.004089 H 259.20108 c -23.47402,0 -45.62431,11.284778 -60.06529,30.552931 L 19.285135,340.53863 c -22.9559861,30.61296 -21.3450398,74.07136 3.854764,102.76351 L 414.83,889.65112 c 260.51304,-95.26033 447.32529,-354.02989 447.32529,-658.35874 0,-27.49164 -1.55342,-54.62313 -4.54517,-81.33444 L 821.76656,101.15728 C 807.32558,81.528968 784.94493,70.004089 761.18347,70.004089 Z M 771.19435,468.39276 545.31666,727.28238 c -7.13419,8.22348 -17.26014,12.84544 -27.9039,12.84544 h -0.23013 c -10.70936,-0.0493 -20.88658,-4.8776 -27.96143,-13.26562 L 270.70784,469.95343 c -13.82618,-16.26491 -12.41002,-41.14051 3.16435,-55.58354 15.59983,-14.39456 39.41935,-12.91852 53.2763,3.3014 L 517.8155,641.86621 715.4441,415.39032 c 14.02155,-16.07753 37.88698,-17.23375 53.2763,-2.58109 15.38525,14.641 16.4925,39.518 2.47395,55.58353 z" fill="#9487f0" /><path d="m 270.6503,469.95343 c -13.82617,-16.26491 -12.41001,-41.14051 3.16436,-55.58354 15.59983,-14.39456 39.41935,-12.91852 53.2763,3.3014 l 97.00198,114.04829 C 559.0097,420.79261 651.98432,256.8632 674.13483,70.004089 H 259.20108 c -23.47379,0 -45.62431,11.284778 -60.06529,30.552931 L 19.285135,340.53863 c -22.9559861,30.61296 -21.3450398,74.07136 3.854764,102.76351 L 205.40697,650.99007 c 55.57765,-17.64747 108.04848,-42.61804 156.49194,-73.83125 z" fill="#a19ceb" /><path d="M 429.96139,70.004089 H 259.20108 c -23.47577,0 -45.62431,11.284778 -60.06529,30.552931 L 19.285135,340.53863 C 3.8868015,361.06061 -0.88602596,388.1564 6.5126313,413.04933 189.12491,365.029 341.87714,238.55545 429.96139,70.004089 Z" fill="#c0bdeb" />';
            zib_svgs['vip_1'] = '<path d="m 950.3677,301.98155 c -40.45962,0 -73.22375,33.23643 -73.22375,74.14736 0,4.66372 0.4664,9.26841 1.28258,13.696 L 689.12913,505.9458 552.53419,236.2171 c 30.60706,-15.82125 51.59476,-47.99506 51.59476,-85.18682 0,-52.835883 -42.3252,-95.694942 -94.50296,-95.694942 -52.17775,0 -94.50294,42.859059 -94.50294,95.694942 0,38.78569 22.79497,72.08117 55.5008,87.07592 L 343.76487,505.9458 148.46265,387.28642 c 0.5247,-3.66013 0.93279,-7.32027 0.93279,-11.09848 0,-40.96996 -32.82244,-74.14735 -73.223756,-74.14735 -40.401324,0 -73.340354,33.17739 -73.340354,74.14735 0,36.12912 25.535036,66.17769 59.290253,72.78956 l 82.085227,413.65486 c 8.04529,63.58477 43.31361,109.33254 84.2423,109.33254 h 570.80715 c 40.92602,0 76.13872,-45.74777 84.2423,-109.33254 l 82.08522,-413.891 c 33.17224,-7.08414 58.00772,-36.89657 58.00772,-72.55342 0.058,-40.96996 -32.76417,-74.20639 -73.2238,-74.20639 z M 680.67576,864.76789 H 345.80534 c -22.62008,0 -40.98432,-21.05375 -40.98432,-46.98664 0,-25.93289 18.36424,-46.98665 40.98432,-46.98665 h 334.87042 c 22.61779,0 40.98431,21.05376 40.98431,46.98665 0,25.93289 -18.36075,46.98664 -40.98431,46.98664 z" fill="#fc7032" /><path d="M 878.01844,390.06105 689.12913,505.9458 552.53419,236.2171 c 30.60706,-15.82125 51.59476,-47.99506 51.59476,-85.18682 0,-52.835883 -42.3252,-95.694942 -94.50296,-95.694942 -52.17775,0 -94.50294,42.859059 -94.50294,95.694942 0,38.78569 22.79497,72.08117 55.5008,87.07592 L 343.76487,505.9458 148.46265,387.28642 c 0.5247,-3.6011 0.93279,-7.32027 0.93279,-11.09848 0,-40.96996 -32.82244,-74.14735 -73.223756,-74.14735 -40.459623,0 -73.2237557,33.23643 -73.2237557,74.14735 0,36.12912 25.5350357,66.17769 59.2902537,72.78956 l 82.085228,413.65486 c 8.04529,63.58477 43.30989,109.33254 84.24229,109.33254 h 369.32524 c 169.18418,-180.95783 280.4773,-350.96082 280.4773,-573.16674 -0.11661,-2.89269 -0.2915,-5.78538 -0.3498,-8.73711 z M 680.67576,864.76789 H 345.80534 c -22.62008,0 -40.98432,-21.05375 -40.98432,-46.98664 0,-25.93289 18.36424,-46.98665 40.98432,-46.98665 h 334.87042 c 22.61779,0 40.98431,21.05376 40.98431,46.98665 0,25.93289 -18.36075,46.98664 -40.98431,46.98664 z M 877.96014,386.45995 c -0.1166,-5.90346 -0.17489,-11.86595 -0.46639,-17.71036 -0.2332,2.47946 -0.3498,4.9589 -0.3498,7.43835 0,3.48303 0.3498,6.90703 0.81619,10.27201 z" fill="#ff7e3e" /><path d="m 324.00144,778.01304 c 3.21091,-2.35768 6.70765,-4.15942 10.37726,-5.34699 140.67589,-74.18944 253.60138,-199.30282 316.21468,-342.87477 l -98.0009,-193.51514 c 30.60706,-15.82125 51.59476,-47.99507 51.59476,-85.18681 0,-52.835898 -42.32519,-95.694957 -94.50294,-95.694957 -52.17776,0 -94.50296,42.859059 -94.50296,95.694957 0,38.78567 22.79498,72.08114 55.50081,87.07591 L 343.82316,506.00484 148.46265,387.28642 c 0.5247,-3.6011 0.93279,-7.32027 0.93279,-11.09848 0,-40.96996 -32.82244,-74.14735 -73.223756,-74.14735 -40.459623,0 -73.2237557,33.23643 -73.2237557,74.14735 0,36.12912 25.5350357,66.17769 59.2902537,72.78956 l 71.707978,361.35028 c 66.92745,-6.848 130.82333,-2.5053 190.05528,-32.31474 z" fill="#ff9552" /><path d="m 534.16995,58.759342 c -7.81209,-2.125243 -16.03227,-3.364969 -24.54396,-3.364969 -52.17775,0 -94.50294,42.859059 -94.50294,95.694957 0,38.78567 22.79497,72.08114 55.5008,87.07591 l -18.42253,38.90375 C 491.90305,211.12743 520.00325,137.39331 534.16995,58.759342 Z M 148.46265,387.28642 c 0.5247,-3.6011 0.93279,-7.32027 0.93279,-11.09848 0,-40.96996 -32.82244,-74.14735 -73.223756,-74.14735 -40.459623,0 -73.2237557,33.23643 -73.2237557,74.14735 0,36.12912 25.5350357,66.17769 59.2902537,72.78956 L 84.508464,561.08405 C 154.05441,540.90524 219.67547,508.81894 278.52809,466.21558 Z" fill="#ffa56a" />';
            zib_svgs['menu_2'] = '<path d="M123.605 383.202C55.368 383.202 0.021 438.52 0.021 506.785c0 68.272 55.34 123.584 123.584 123.584 68.242 0 123.584-55.305 123.584-123.584-0.016-68.25-55.342-123.583-123.584-123.583z m388.398 0c-68.237 0-123.584 55.318-123.584 123.583 0 68.272 55.34 123.584 123.584 123.584 68.235 0 123.577-55.305 123.577-123.584 0-68.25-55.349-123.583-123.577-123.583z m388.392 0c-68.23 0-123.584 55.318-123.584 123.583 0 68.272 55.34 123.584 123.584 123.584 68.242 0 123.584-55.305 123.584-123.584 0-68.25-55.342-123.583-123.584-123.583z m0 0"></path>';
            zib_svgs['alipay'] = '<path d="M653.80568 617.306394c70.196759-127.645169 95.735411-248.897743 95.735411-248.897743l-12.766768 0 0 0L628.282377 368.408651 513.408069 368.408651l0-89.352027 280.800337 0 0-38.283931L513.408069 240.772692 513.408069 106.752326 385.771087 106.752326l0 134.020366L130.495076 240.772692l0 38.283931 255.277034 0 0 89.352027L168.784124 368.408651l0 38.289048 440.3481 0c0 6.383384 0 6.383384-6.383384 12.761652 0 44.669362-31.906687 108.49604-57.434084 159.542646C219.835847 451.360921 124.105552 527.945157 98.578156 540.718065c-216.981846 153.159262-12.761652 344.616782 19.154245 338.239538 229.749638 51.051723 376.530632-44.673455 478.639195-165.93217 6.382361 6.383384 12.761652 6.383384 19.149129 6.383384 70.196759 38.284955 408.436296 197.836811 408.436296 197.836811L1023.957021 725.798341C972.901205 725.798341 787.829116 661.980873 653.80568 617.306394L653.80568 617.306394 653.80568 617.306394zM487.874533 674.742525c-159.542646 204.221218-351.002212 140.39761-382.9089 127.635959-76.574003-19.150152-102.107539-159.547763-6.387477-204.226335 159.547763-51.051723 299.954583 6.387477 402.063145 57.4392C494.263034 668.358117 487.874533 674.742525 487.874533 674.742525L487.874533 674.742525 487.874533 674.742525zM487.874533 674.742525"></path>';
            zib_svgs['baidu'] = '<path d="M412.54 94.74c13.82-2.69 28.21 0.67 40.52 7.13 18.32 10.72 32.2 27.86 41.03 46.99 18.82 40.57 19.04 88.91 2.38 130.23-7.83 18.05-19.17 35.23-35.44 46.7-14.17 10.44-32.65 15.51-50.08 12.14-14.7-2.84-28.09-10.75-38.4-21.51-16.41-16.26-26.44-37.85-32.21-59.97-7.82-32.14-6.07-66.64 5.6-97.63 7.58-20.05 19.98-38.77 37.36-51.6 8.68-6.21 18.62-10.89 29.24-12.48zM642.54 112.74c14.09-3.24 28.43 1.98 40.47 9.09 12.5 7.77 23.39 18.14 31.82 30.2 13.27 17.99 21.69 39.65 23.54 61.95 1.2 20.12-4.42 39.95-11.88 58.44-8.6 20.17-20.6 39.39-37.41 53.73-11.2 9.99-25.06 17.06-39.91 19.51-15.25 2.42-31.08 0-45.41-5.48-16.19-6.35-29.7-18.93-37.51-34.43-9.97-19.57-12.73-42-12.38-63.72 0.38-12.08 1-24.34 4.57-35.97 5.44-18.49 15.28-35.39 26.82-50.71 9.67-12.59 21.15-23.86 34.29-32.81 7.03-4.53 14.79-8.01 22.99-9.8zM228.55 276.76c14.19-2.87 29.11-0.38 42.36 5.14 27.56 12.82 48.47 37.44 59.87 65.31 4.69 11.29 5.89 23.58 6.5 35.67 1.23 21.99-0.51 44.34-7.05 65.44-5.65 17.81-15.84 34.6-30.88 46-15.06 11.23-33.63 17.35-52.32 18.33-20.48 1.2-41.53-6-56.36-20.3-14.41-13.11-24.12-30.65-30.28-48.96-6.19-18.39-9.2-38.17-6.38-57.49 3.11-23.27 9.52-46.34 20.89-66.98 5.74-10.16 12.93-19.57 21.82-27.18 9.15-7.51 20.19-12.76 31.83-14.98zM773.09 335.14c16.95-1.24 34.45 1.2 49.77 8.79 16.02 7.8 28.92 21.02 38.19 36.07 10.21 17.52 16.89 37.52 16.85 57.94 0.51 21.72 0.12 43.77-5.45 64.91-4.39 15.87-11.71 31.45-23.77 42.96-14.07 13.2-33.49 19.59-52.57 19.96-19.19 0.57-39.12-0.89-56.7-9.27-17.16-7.33-30.5-22.16-37.31-39.39-7.85-19.67-9.44-41.14-9.35-62.12-0.01-24.34 2.7-49.22 12.47-71.74 6.11-13.99 15.56-26.85 28.47-35.25 11.5-8.11 25.55-11.68 39.4-12.86zM499.58 415.76c19.31-2.26 39.11 0.99 56.87 8.84 27.51 12.15 49.18 34.47 65.89 59.02 21.56 32.4 47.59 61.52 74.73 89.3 23.38 23.32 47.52 45.93 72.92 67.05 5.74 4.96 11.94 9.4 17.25 14.85 18.04 18.41 29.75 42.69 33.91 68.05 5.31 31.4-1.18 63.71-13.33 92.79-8.36 21.32-23.98 39.76-43.85 51.21-21.13 12.43-45.72 17.37-69.93 18.95-34.13 1.93-68.29-3.36-101.12-12.43-41.83-13.18-86.85-16.16-130.03-8.51-21.43 4.49-42.94 8.86-64.77 10.85-26.62 2.82-53.48 3.1-80.2 1.62-19.06-0.37-38.15-5.73-54.21-16.1-17.72-10.45-31.47-26.56-41.39-44.4-8.27-15.27-13.79-31.93-17.34-48.89-5.11-24.73-3.54-50.94 5.59-74.56 12.72-33.67 37.73-61.18 65.64-83.21 6.93-5.78 14.54-10.69 21.4-16.56 14.15-13.89 29.74-26.2 43.84-40.14 21.96-21.36 42.44-44.56 58.28-70.89 20.78-35.88 58.42-62.08 99.85-66.84z"></path>';
            zib_svgs['gitee'] = '<path d="M978.5 409.6H455.1c-25.1 0-45.5 20.3-45.5 45.5v113.7c0 25.1 20.3 45.5 45.5 45.5h318.6c25.1 0 45.5 20.4 45.5 45.5v22.6c0 75.4-61.2 136.5-136.5 136.5H250.3c-25.1 0-45.5-20.4-45.5-45.5V341.2c0-75.5 61.2-136.5 136.5-136.5h637c25.1 0 45.5-20.3 45.5-45.5l0.1-113.6c0-25.1-20.3-45.5-45.5-45.5H341.3C152.9 0 0 152.9 0 341.3v637.2c0 25.1 20.4 45.5 45.5 45.5h671.3c169.6 0 307.2-137.5 307.2-307.2V455.1c0-25.1-20.4-45.5-45.5-45.5z"></path>';
            zib_svgs['comment-fill'] = '<path d="M512 115.6c-249.9 0-448.5 174-448.5 386.7 0 58 19.2 116 44.9 167.6l44.9 238.5L371 869.7c44.9 12.9 89.7 19.3 141 19.3 249.9 0 448.5-174 448.5-386.7 0-212.6-198.6-386.7-448.5-386.7zM255.7 437.9c38.4 0 64.1 25.8 64.1 64.4 0 38.7-25.6 64.4-64.1 64.4-38.4 0-64.1-25.8-64.1-64.4 0-38.6 25.7-64.4 64.1-64.4zM512 566.8c-38.4 0-64.1-25.8-64.1-64.4 0-38.7 25.6-64.4 64.1-64.4 38.4 0 64.1 25.8 64.1 64.4 0 38.6-25.7 64.4-64.1 64.4z m256.3 0c-38.4 0-64.1-25.8-64.1-64.4 0-38.7 25.6-64.4 64.1-64.4 38.4 0 64.1 25.8 64.1 64.4 0 38.6-25.7 64.4-64.1 64.4z"></path>';
            zib_svgs['private'] = '<path d="M469.942857 512c0 25.6 19.2 51.2 51.2 51.2 25.6 0 51.2-19.2 51.2-51.2 0-25.6-19.2-51.2-51.2-51.2-25.6 0-51.2 25.6-51.2 51.2z m204.8 0c0 25.6 19.2 51.2 51.2 51.2s51.2-19.2 51.2-51.2c0-25.6-19.2-51.2-51.2-51.2s-51.2 25.6-51.2 51.2zM271.542857 512c0 25.6 19.2 51.2 51.2 51.2s44.8-25.6 44.8-51.2-19.2-51.2-51.2-51.2-44.8 25.6-44.8 51.2z m665.6-172.8c-25.6-57.6-57.6-102.4-96-147.2-38.4-38.4-89.6-76.8-140.8-96C642.742857 76.8 578.742857 64 521.142857 64 457.142857 64 399.542857 76.8 341.942857 102.4c-51.2 19.2-96 51.2-140.8 96S130.742857 288 105.142857 339.2C85.942857 396.8 73.142857 454.4 73.142857 512c0 70.4 19.2 140.8 51.2 198.4v153.6c0 25.6 19.2 44.8 44.8 44.8h153.6c64 32 128 44.8 198.4 51.2 57.6 0 115.2-12.8 172.8-32 51.2-19.2 102.4-51.2 140.8-96 38.4-38.4 76.8-89.6 96-140.8 25.6-57.6 38.4-115.2 38.4-179.2 0-57.6-12.8-115.2-32-172.8z m-153.6 435.2C713.142857 844.8 617.142857 883.2 521.142857 883.2c-57.6 0-121.6-12.8-172.8-44.8l-6.4-6.4H194.742857V691.2l-6.4-6.4C162.742857 633.6 149.942857 576 149.942857 512c0-102.4 38.4-192 108.8-262.4C329.142857 179.2 418.742857 140.8 521.142857 140.8c51.2 0 96 12.8 147.2 32 44.8 19.2 83.2 44.8 121.6 76.8 32 32 64 76.8 76.8 121.6 19.2 44.8 32 96 32 147.2-6.4 96-44.8 185.6-115.2 256z"></path>';
            zib_svgs['hot-fill'] = '<path d="M921.053465 625.705187c0 230.830879-173.604142 398.335748-412.826638 398.335748C270.846393 1024.040935 102.44096 856.495131 102.44096 625.705187c0-122.558548 72.208844-254.573016 75.278948-260.058268a31.519733 31.519733 0 0 1 31.437864-16.128279c12.730698 1.678323 23.169051 11.052374 26.443828 23.619332 0.163739 0.77776 19.60773 74.828666 45.314734 116.049928 17.233517 27.630935 34.753576 47.197731 54.443176 60.788057-13.344718-58.782256-23.537463-147.119379-6.917968-237.789781C374.042819 63.262152 566.599736 3.743071 574.827614 1.327922a30.578235 30.578235 0 0 1 29.964214 7.204511 32.256558 32.256558 0 0 1 9.660594 29.636736c-0.327478 1.801128-32.092819 176.01929 35.367597 324.489515 6.099273 13.508457 14.613695 29.227389 23.864941 44.864452 2.578887-21.531662 6.672359-44.373235 12.894436-66.600787 24.765505-88.091515 88.74647-118.178533 91.448162-119.406575a31.31506 31.31506 0 0 1 32.338428 4.011603c9.210312 7.368249 13.631261 19.321187 11.54359 31.028516-0.327478 2.16954-9.292181 62.138903 40.852849 147.160314 45.232864 76.752598 58.291039 126.57015 58.29104 221.98898z"></path>';
            zib_svgs['hot'] = '<path d="M429.568429 1023.994675S87.04221 973.306939 87.04221 681.468456c0-291.838482 447.485673-319.486339 348.670187-681.468456 0 0 335.358256 104.959454 253.438682 431.613756 0 0 44.543768-28.159854 78.335592-83.455566 0 0 169.471119 131.071318 169.471119 330.75028 0 199.678962-235.006778 346.1102-346.622197 345.086205 0 0 120.319374-162.303156 10.751944-267.26261-155.135193-148.479228-89.087537-244.22273-89.087537-244.22273S133.633968 697.852371 429.568429 1023.994675"></path>';
            zib_svgs['topping'] = '<path d="M256 51.2h512a51.2 51.2 0 0 1 0 102.4H256a51.2 51.2 0 1 1 0-102.4z"></path><path d="M876.4928 432.9984l-234.1888-193.1264a204.8 204.8 0 0 0-260.608 0L147.456 432.9984A102.4 102.4 0 0 0 212.6848 614.4H307.2v153.6a204.8 204.8 0 1 0 409.6 0v-153.6h94.5152a102.4 102.4 0 0 0 65.1776-181.4016z m-302.336-108.2368L819.2 512h-102.4a102.4 102.4 0 0 0-102.4 102.4v153.6a102.4 102.4 0 1 1-204.8 0v-153.6a102.4 102.4 0 0 0-102.4-102.4H204.8l245.0432-187.2384a102.4 102.4 0 0 1 124.3136 0z"></path>';
            zib_svgs['topic'] = '<path d="M434.432 802.901333a58.197333 58.197333 0 1 1-116.352 0l-0.042667-96.981333h-174.506666a58.197333 58.197333 0 1 1 0-116.352h174.506666V395.605333H221.098667a58.197333 58.197333 0 1 1 0-116.352h96.938666V143.530667a58.197333 58.197333 0 0 1 116.394667 0l-0.042667 135.722666h193.962667V221.098667a58.197333 58.197333 0 0 1 116.394667 0l-0.042667 58.154666h135.765333a58.197333 58.197333 0 1 1 0 116.394667l-135.765333-0.042667v193.962667h58.197333a58.197333 58.197333 0 1 1 0 116.352h-58.197333v174.549333a58.197333 58.197333 0 1 1-116.352 0v-174.549333h-193.962667v96.981333z m-0.042667-213.333333h193.962667V395.605333h-193.962667v193.962667z"></path>';
            zib_svgs['plate-fill'] = '<path d="M383.02 501.504L112.856 366.805l-0.853-0.426c-12.203-5.675-24.32-8.534-35.968-8.534-15.19 0-29.099 5.206-39.125 14.635a49.963 49.963 0 0 0-15.574 36.864v363.35c0 15.103 6.272 31.829 17.707 47.06 11.179 14.934 26.539 27.52 43.307 35.414l270.08 134.699 0.768 0.426 0.213 0.043c12.288 5.675 24.405 8.533 35.968 8.533 15.19 0 29.099-5.162 39.125-14.592 10.027-9.429 15.574-22.528 15.574-36.906V584.107c0-15.147-6.315-31.872-17.707-47.104a117.76 117.76 0 0 0-43.35-35.414zM953.9 372.48a56.49 56.49 0 0 0-39.125-14.635c-11.69 0-23.765 2.902-35.968 8.534L607.79 501.547c-16.768 7.893-32.128 20.48-43.307 35.413-11.435 15.232-17.707 32-17.707 47.104v363.307c0 14.378 5.547 27.477 15.574 36.906 9.984 9.387 23.893 14.592 39.082 14.592h0.17a86.109 86.109 0 0 0 36.012-8.618l269.78-135.083c16.769-7.893 32.172-20.48 43.35-35.413 11.392-15.232 17.664-32 17.664-47.147l1.024-363.264c0-14.336-5.546-27.435-15.53-36.864z m-96-118.272c23.894-11.477 37.462-29.867 37.334-50.432-0.17-20.395-13.696-38.4-37.205-49.365L557.655 12.928c-16.213-7.595-37.12-11.733-58.794-11.733-22.87 0-44.928 4.522-62.08 12.8L133.207 161.536c-23.808 11.52-37.418 29.91-37.248 50.475 0.128 20.352 13.654 38.357 37.163 49.322l300.373 141.483c11.52 5.419 25.515 9.088 40.534 10.752l-1.11 1.024h19.37c22.828 0 44.886-4.565 62.124-12.885L857.9 254.208z"></path><';
            zib_svgs['extra-points'] = '<path d="M949.79 815.69L551.71 126.21a45.27 45.27 0 0 0-78.42 0L75.21 815.69c-17.42 30.18 4.36 67.92 39.22 67.92h796.14c34.86 0 56.64-37.74 39.22-67.92zM185 797.61l327.5-567.32L840 797.61z"></path>';
            zib_svgs['deduct-points'] = '<g style="transform-origin:center;transform:rotate(180deg);"><path d="M949.79 815.69L551.71 126.21a45.27 45.27 0 0 0-78.42 0L75.21 815.69c-17.42 30.18 4.36 67.92 39.22 67.92h796.14c34.86 0 56.64-37.74 39.22-67.92zM185 797.61l327.5-567.32L840 797.61z"></path></g>';
            zib_svgs['share'] = '<path d="M823.04 1024H200.96a172.8 172.8 0 0 1-170.24-174.72V249.984a172.8 172.8 0 0 1 170.24-174.784h202.88v96H200.96a78.592 78.592 0 0 0-77.44 78.912v599.296a78.528 78.528 0 0 0 77.44 78.848h622.08a78.144 78.144 0 0 0 77.44-78.848V564.032h92.8v285.376A172.8 172.8 0 0 1 823.04 1024z m-345.6-293.824l-91.52-17.088a880.832 880.832 0 0 1 120.96-294.848 669.376 669.376 0 0 1 202.88-206.016 604.8 604.8 0 0 1 102.4-51.712L638.08 89.024l34.56-89.088 290.56 121.6 28.8 22.272 1.92 44.416-16.64 45.824-128.64 245.504-81.92-45.44 100.48-192a488.768 488.768 0 0 0-108.16 51.584A576 576 0 0 0 584.32 471.04a803.008 803.008 0 0 0-106.88 259.136z m495.36-491.328l-1.92 1.664z m-22.4-60.416l-3.2 0.96z m-11.52-17.984l-1.28 1.856 1.92-1.856h-0.64z m12.8-45.888l2.56 1.344a15.488 15.488 0 0 1-2.56-1.344z" style="transform:scale(.85);transform-origin: center;"></path>';
            zib_svgs['approve'] = '<path d="M856 633.6h-137.6c-8-4.8-16-11.2-22.4-19.2-28.8-28.8-30.4-52.8-28.8-62.4v-6.4c0-3.2 4.8-16 16-35.2 4.8-8 8-14.4 12.8-20.8 9.6-16 20.8-30.4 32-44.8 40-48 62.4-108.8 62.4-171.2C792 128 673.6 6.4 523.2 0h-20.8C352 6.4 232 128 232 273.6c0 62.4 22.4 123.2 62.4 171.2l1.6 3.2c11.2 14.4 20.8 28.8 32 43.2 20.8 30.4 28.8 51.2 27.2 54.4v6.4c0 9.6-1.6 33.6-27.2 62.4l-1.6 1.6c-6.4 6.4-14.4 12.8-22.4 19.2h-137.6c-91.2 0-132.8 35.2-132.8 116.8v179.2c0 25.6 9.6 49.6 27.2 67.2 20.8 16 44.8 25.6 70.4 25.6l763.2-1.6c52.8 0 94.4-43.2 94.4-94.4V750.4c-1.6-80-41.6-116.8-132.8-116.8zM105.6 929.6V750.4c0-22.4 3.2-32 9.6-38.4 8-6.4 22.4-8 51.2-8h158.4l8-4.8c16-9.6 30.4-20.8 43.2-33.6 44.8-46.4 49.6-92.8 49.6-115.2 1.6-24-11.2-52.8-40-96l-38.4-52.8c-28.8-35.2-44.8-80-46.4-126.4 0-108.8 88-198.4 201.6-203.2h17.6c112 4.8 200 94.4 200 203.2 0 46.4-16 91.2-46.4 126.4-12.8 16-25.6 33.6-36.8 51.2-4.8 8-11.2 16-16 25.6-17.6 32-25.6 52.8-25.6 73.6-1.6 24 3.2 68.8 49.6 115.2 12.8 12.8 27.2 24 43.2 35.2l8 4.8h158.4c56 0 60.8 8 60.8 46.4V928c0 6.4-3.2 12.8-8 17.6-4.8 4.8-11.2 8-17.6 8H131.2c-6.4 0-12.8-3.2-17.6-8-4.8-3.2-8-9.6-8-16z"></path><path d="M328 804.8h368v70.4h-368v-70.4z"></path>';
            zib_svgs['qzone-color'] = '<path d="M1016.86385778 416.68152889c9.54026667-9.99537778 4.27804445-26.77873778-9.18528-29.30119111l-314.97329778-58.99832889c-5.50456889-1.03082667-10.26275555-4.53632-12.94791111-9.53799111L527.78439111 35.53166222c-3.18350222-5.95057778-9.49134222-8.93155555-15.78666666-8.98389333-6.29418667 0.0512-12.60088889 3.03445333-15.78439112 8.98389333L344.24376889 318.84401778c-2.68515555 5.00167111-7.44448 8.50716445-12.94904889 9.53799111L16.32142222 387.38033778c-13.46332445 2.52245333-18.72554667 19.30581333-9.18528 29.30119111L236.24817778 656.59562667c4.05504 4.24732445 5.92213333 10.18538667 5.04376889 16.04266666l-52.35484445 320.88974222c-2.06961778 13.79669333 11.82606222 24.35640889 24.23239111 18.41152L504.03555555 871.34094222a18.31594667 18.31594667 0 0 1 7.96444445-1.79768889 18.31822222 18.31822222 0 0 1 7.96785778 1.79768889L810.83050667 1011.93955555c12.40632889 5.94488889 26.30200889-4.61482667 24.23239111-18.41152l-53.33902223-326.88128 235.13998223-249.96522666z" fill="#FFCD00"></path><path d="M565.95342222 491.09902222c-5.13934222-4.29169778-126.27854222-45.88885333-311.71470222-18.20444444-3.59537778 0.53475555-6.72768-0.44828445-9.14773333-2.26645333-0.81578667 4.55111111 4.08120889 8.13738667 10.22634666 8.56405333 130.91726222 9.12611555 204.14008889 62.56298667 226.97756445 81.35224889 46.39857778-32.90794667 81.78574222-57.57838222 83.12945777-58.62627556 4.17336889-3.24949333 4.20408889-7.74940445 0.52906667-10.82026666m154.33955556-34.10147556c-47.49539555 40.01336889-182.22535111 133.00280889-229.28497778 168.92359111-5.53415111 4.22229333-3.61472 10.72241778 2.38705778 13.0048 19.39342222 7.38190222 41.22168889 13.59644445 64.19456 18.71075555l181.79868444-173.20163555c14.27228445-15.00046222 5.95968-33.16849778-11.85792-37.16096-1.16622222 3.42584889-3.70801778 6.75043555-7.23626667 9.72344889M859.23498667 657.63555555l-0.11491556 0.0512c-80.16327111 33.80224-274.81884445 90.59328-514.00476444 82.29546667-28.88362667-1.00124445-57.60568889-4.22684445-73.71207112-7.19644444-2.35178667-0.43235555-4.41230222-1.15143111-6.2304711-2.10033778-12.02289778 13.90819555 2.35861333 24.41898667 53.64394666 34.79324445 150.05696 30.35136 325.45792 44.29824 472.52366222 34.88995555l-10.10801778-61.80864c49.75160889-35.76149333 73.95100445-66.61233778 76.82730667-71.19075555 3.29841778-5.25198222 1.17532445-9.73368889 1.17532445-9.7336889" fill="#F1A308"></path><path d="M861.14190222 665.59431111c-60.65493333 5.84476445-245.63939555 4.19384889-354.78869333-37.73667556-5.81063111-2.23232-7.77557333-8.60842667-2.42232889-12.73628444 45.53955555-35.08906667 175.9232-125.92924445 221.88259555-165.0176 8.95658667-7.61856 11.32088889-17.56387555 0.42666667-25.64778666-20.8896-15.49994667-94.62670222-41.19096889-179.99416889-41.88842667-122.16661333-1.00124445-242.18510222 33.56216889-294.83576888 61.5424-12.49621333 6.64120889-4.99712 24.14478222 7.77102222 22.18097777 186.84928-28.71751111 308.90097778 14.51349333 314.07786666 18.96675556 3.70346667 3.18350222 3.49752889 7.85749333-0.56888888 11.05351111-3.45429333 2.71815111-226.71701333 163.11182222-293.80835556 219.71626667-10.56540445 8.91335111-7.78808889 27.58656 9.50044444 30.74048 16.10183111 2.93774222 44.83527111 6.15765333 73.70979556 7.14979556 239.13016889 8.20792889 433.85059555-48.05973333 513.9968-81.49902223 0 0-2.44394667-8.02929778-14.94698667-6.82439111" fill="#FFFFFF"></path>';
            zib_svgs['qq-color'] = '<path d="M686.293 1024c91.136 0 164.352-34.304 164.352-76.288S776.917 870.4 686.293 870.4s-164.352 33.792-164.352 76.288S595.67 1024 686.293 1024z m-348.672 0c90.624 0 164.352-34.304 164.352-76.288S428.245 870.4 337.621 870.4 173.27 904.192 173.27 946.688 246.997 1024 337.621 1024z" fill="#F5B824"></path><path d="M166.613 724.48a354.816 354.816 0 0 0 343.552 243.712h3.072A354.816 354.816 0 0 0 856.79 724.48c51.2 108.032 51.2 86.016 61.44 77.312 85.504-137.216-39.936-294.912-39.936-294.912L843.99 388.096C840.917 0 528.597 0 512.213 0S183.51 0 183.51 388.096L146.133 506.88s-125.44 158.72-40.96 294.912c9.728 6.656 10.24 30.72 61.44-77.312z" fill="#121213"></path><path d="M593.11 348.16c36.863 0 66.56-41.984 66.56-93.696s-29.697-93.696-66.56-93.696S526.55 204.8 526.55 256s29.695 92.16 66.56 92.16z m-171.009 0c36.864 0 66.56-40.96 66.56-92.16s-29.696-93.696-66.56-93.696-66.56 42.496-66.56 93.696 27.648 92.16 66.56 92.16z" fill="#FFFFFF"></path><path d="M443.605 294.912c15.872 0 28.672-17.92 28.672-40.448s-12.8-40.448-28.672-40.448-28.672 18.432-28.672 40.448 12.8 40.448 28.672 40.448z m172.544 5.632c15.872 0 28.672-17.92 28.672-40.448s-12.8-40.448-28.672-40.448-28.672 18.432-28.672 40.448 12.8 40.448 28.672 40.448z" fill="#161616"></path><path d="M512.213 951.808c376.832 0 269.312-484.864 269.312-484.864A421.376 421.376 0 0 1 512.213 550.4a420.864 420.864 0 0 1-269.312-83.456s-107.52 484.864 269.312 484.864z" fill="#FAFAFB"></path><path d="M275.67 606.72c-3.073 34.816-7.68 88.064-7.169 115.2 0 42.496 26.624 45.056 86.528 51.2s47.616-10.24 47.616-37.376V650.24a414.208 414.208 0 0 0 109.056 7.68 465.408 465.408 0 0 0 366.08-153.6 475.648 475.648 0 0 0-36.864-117.76 371.712 371.712 0 0 1-328.704 161.792A371.712 371.712 0 0 1 183.51 388.096a531.456 531.456 0 0 0-37.376 118.784 455.168 455.168 0 0 0 129.536 99.84z" fill="#D53118"></path><path d="M512.725 486.912a409.6 409.6 0 0 0 209.408-51.2v-4.096c0-1.024-8.192-15.36-31.744-22.016a494.08 494.08 0 0 0-178.176-35.84 494.08 494.08 0 0 0-175.616 35.84c-25.6 8.704-35.84 15.36-35.84 24.064a7.68 7.68 0 0 0 0 4.096 409.6 409.6 0 0 0 211.968 49.152z" fill="#F0B225"></path>';
            zib_svgs['weibo-color'] = '<path d="M1010.912 451.136a39.104 39.104 0 1 1-74.624-23.424 197.184 197.184 0 0 0-40.224-190.944 191.168 191.168 0 0 0-183.616-60 37.824 37.824 0 0 1-29.248-5.856 44.8 44.8 0 0 1-17.536-26.336 38.784 38.784 0 0 1 29.984-46.816 268.256 268.256 0 0 1 258.24 84.864 276.832 276.832 0 0 1 57.056 268.48z" fill="#FF9933"></path><path d="M738.88 302.592a35.2 35.2 0 0 1-25.6-4.384 36.352 36.352 0 0 1-14.624-21.216 33.696 33.696 0 0 1 25.6-40.224 131.424 131.424 0 0 1 125.824 40.96 135.072 135.072 0 0 1 27.808 130.944 32.416 32.416 0 0 1-16.832 19.744 34.464 34.464 0 0 1-47.552-41.6 66.656 66.656 0 0 0-13.152-64.384 62.752 62.752 0 0 0-61.472-19.84z" fill="#FF9933"></path><path d="M768.864 496.48c58.528 18.304 124.352 62.912 124.352 141.92 0 130.208-185.088 294.816-463.808 294.816-212.16 0-429.44-104.608-429.44-276.544 0-89.984 56.32-193.856 152.896-291.904C281.632 233.824 432.32 174.56 488.64 231.616c24.864 25.6 27.072 69.504 11.712 121.44-8.768 27.072 23.424 12.448 23.424 12.448 104.608-44.64 195.2-46.816 228.256 1.472a108.8 108.8 0 0 1-0.736 103.136c-6.592 19.008 2.912 21.952 17.568 26.336z" fill="#E6162D"></path><path d="M429.44 870.944c169.6-16.832 298.464-122.176 286.784-235.552-10.24-112.672-156.544-190.208-326.4-173.376s-297.6 122.176-286.784 235.552c11.104 112.736 157.408 190.304 326.4 173.376z" fill="#FFFFFF"></path><path d="M447.072 549.152a128.8 128.8 0 0 1 92.192 179.2 181.184 181.184 0 0 1-218.752 93.632 128 128 0 0 1-80.48-182.176 184.736 184.736 0 0 1 207.04-90.656z" fill="#1A1A1A"></path><path d="M384.864 737.184a45.984 45.984 0 0 0-19.2-68.928 64 64 0 0 0-76.096 25.6 46.016 46.016 0 0 0 17.568 68.768 63.008 63.008 0 0 0 77.728-25.44z" fill="#FFFFFF"></path>';
            zib_svgs['poster-color'] = '<path d="M800.614 930.765H230.042c-73.524 0-133.12-59.597-133.12-133.12V226.304c0-73.523 59.596-133.12 133.12-133.12h570.572c73.524 0 133.12 59.597 133.12 133.12v571.29c0 73.523-59.596 133.17-133.12 133.17z" fill="#FFB96E"></path><path d="M933.734 451.123l-352 218.42a46.454 46.454 0 0 1-57.292-6.554L409.907 548.915a46.5 46.5 0 0 0-65.126-0.46L96.92 788.53v12.8c0 71.475 57.908 129.383 129.383 129.383h578.048c71.475 0 129.382-57.908 129.382-129.383V451.123z" fill="#FF7C0E"></path><path d="M268.442 335.718a68.864 68.864 0 1 0 137.728 0 68.864 68.864 0 1 0-137.728 0z" fill="#FFFFFF"></path>';
            zib_svgs['copy-color'] = '<path d="M736.341333 130.474667a75.904 75.904 0 0 0-107.349333 0l-154.453333 154.496a75.904 75.904 0 0 0 0 107.349333l45.909333 45.952 95.146667-95.146667a44.757333 44.757333 0 0 1 63.274666 63.317334l-95.146666 95.146666 45.269333 45.226667a75.904 75.904 0 0 0 107.349333 0l154.496-154.496a75.904 75.904 0 0 0 0-107.349333l-154.496-154.496z" fill="#41d2d2"></path><path d="M345.6 613.12a44.757333 44.757333 0 1 0 63.317333 63.274667l95.146667-95.146667 45.226667 45.269333a75.904 75.904 0 0 1 0 107.349334l-154.496 154.496a75.904 75.904 0 0 1-107.349334 0L132.949333 733.866667a75.904 75.904 0 0 1 0-107.349334l154.453334-154.453333a75.904 75.904 0 0 1 107.392 0l45.952 45.909333-95.146667 95.146667z" fill="#4193db"></path>';
            zib_svgs['user-auth'] = '<defs><linearGradient id="a"><stop offset="0" stop-color="#5fb5ff"/><stop offset="1" stop-color="#0060ef"/></linearGradient><linearGradient xlink:href="#a" id="b" x1="104.617" x2="899.526" y1="120.692" y2="896.775" gradientUnits="userSpaceOnUse"/></defs><path fill="url(#b)" d="M37.187 583.527c54.417 45.581 92.125 139.24 84.635 209.533l1.088-9.987c-7.49 70.548 43.597 122.275 114.084 116.065l-10.052.833c70.679-6.21 163.572 33.353 208.002 88.345l-6.338-7.874c44.622 55.248 117.348 55.632 162.739 1.408l-6.467 7.746c45.583-54.415 139.244-92.122 209.538-84.632l-10.051-1.088c70.614 7.49 122.342-43.597 116.068-114.017l.896 10.05c-6.21-70.74 33.355-163.63 88.348-208.06l-7.874 6.338c55.185-44.62 55.633-117.346 1.408-162.735l7.747 6.466c-54.417-45.581-92.125-139.176-84.635-209.533l-1.088 10.051c7.49-70.612-43.598-122.275-114.084-116.065l10.051-.897c-70.678 6.274-163.571-33.29-208-88.281l6.337 7.81C554.917-10.181 482.19-10.629 436.8 43.595l6.466-7.747c-45.582 54.416-139.243 92.123-209.537 84.697l10.05 1.024c-70.613-7.49-122.278 43.66-116.068 114.081l-.896-10.05c6.21 70.676-33.354 163.567-88.348 208.06l7.875-6.402c-55.185 44.685-55.634 117.346-1.409 162.735Z"/><path fill="#fff" d="M447.4 743.76c-10.126 11.545-23.881 17.089-38.178 17.089-14.424 0-28.148-5.65-38.273-17.23L232.916 585.79c-21.027-24.283-20.928-62.672.223-86.822 20.922-23.92 55.581-23.76 76.324.352l99.887 114.61 288.866-329.39c20.825-24.036 55.5-24.036 76.324 0 21.11 24.044 21.11 63.06 0 87.07L447.432 743.76Z"/>';
            zib_svgs['money-color'] = '<path d="M 719.32938,307.05566 C 918.05422,52.24491 687.49053,37.028543 634.34172,56.683017 566.06158,-7.5427338 462.91632,-4.1824527 394.63617,61.311329 73.032287,16.930257 288.46465,307.05566 288.46465,307.05566 -14.603353,490.53969 -0.41772812,735.84021 12.317811,859.3464 28.079617,1011.51 178.06896,1019.1817 178.06896,1019.1817 h 702.7874 c 85.36594,0 122.87904,-88.12817 134.29054,-156.72862 C 1058.3973,503.09319 877.07352,419.97379 719.32938,307.05566 Z m 19.2294,433.47627 c 20.49034,0 37.13481,21.42972 37.13481,42.03522 0,20.60549 -16.64447,41.27439 -37.13481,41.27439 H 553.76737 v 72.46795 c 0,20.60262 -19.10331,37.34351 -39.59366,37.34351 -20.49035,0 -39.34147,-16.73801 -39.34147,-37.34351 V 823.84154 H 289.85168 c -20.49034,0 -37.1348,-22.44415 -37.1348,-43.04964 0,-20.60549 16.64359,-40.32337 37.1348,-40.32337 H 474.89529 V 673.0093 H 289.85168 c -20.49034,0 -37.00871,-22.00034 -37.00871,-42.66923 0,-20.6689 16.45408,-40.70378 37.00871,-40.70378 h 154.71789 l -109.82826,-99.4136 c -15.25073,-13.80557 -16.46524,-37.43704 -2.71103,-52.75008 13.72842,-15.33643 37.22782,-16.55778 52.45529,-2.72627 L 514.74113,552.73659 647.64468,434.55614 c 15.36792,-13.68859 38.86498,-12.24017 52.45529,3.23348 13.6121,15.45428 12.17177,39.08339 -3.21541,52.75007 l -111.59358,99.2234 h 153.3939 c 20.49034,0 37.1348,19.97148 37.1348,40.64038 0,20.60549 -16.64446,42.73263 -37.1348,42.73263 H 553.89346 v 67.45923 h 184.66532 z" fill="#fc7032" /><path d="M 763.0211,243.40053 C 774.55874,194.45455 781.3048,143.73332 782.94402,91.680662 748.01586,45.777953 663.59563,45.904756 634.02648,56.80982 565.74634,-7.4159308 462.60108,-4.0556496 394.32094,61.438132 72.717052,17.057061 288.14942,307.18247 288.14942,307.18247 9.4176387,475.89394 -0.98515309,696.91168 9.1024026,827.39203 c 6.1786284,0.1268 12.4203024,0.2536 18.6619774,0.2536 79.3134,0 155.72664,-9.38343 227.53743,-32.14457 -1.89141,-4.50151 -2.58493,-9.06643 -2.58493,-14.20194 0,-20.6055 16.32923,-40.64039 36.81957,-40.64039 h 89.52706 c 34.17159,-18.06944 64.68645,-30.11572 95.51654,-53.06708 V 673.1995 h -185.0436 c -20.49034,0 -37.00871,-22.00033 -37.00871,-42.66922 0,-20.6055 16.45407,-40.70379 37.00871,-40.70379 h 154.71789 l -109.82826,-99.477 c -15.25074,-13.80557 -16.46525,-37.43703 -2.71103,-52.75008 13.72841,-15.33643 37.22782,-16.55777 52.45529,-2.72626 L 514.4259,552.8634 647.32945,434.68294 c 12.60944,-11.22207 30.70399,-12.10969 44.25914,-3.48708 18.97421,-35.04013 35.18506,-71.52345 48.48333,-109.11403 -6.99825,-4.88192 -14.05954,-9.82724 -20.99473,-14.77256 18.03151,-23.33177 32.53237,-44.50788 43.94391,-63.90874 z" fill="#ff9552" />';
            zib_svgs['order-color'] = '<path d="M 702.98231,186.42345 H 327.31182 c -15.78609,0 -28.63225,-12.92529 -28.63225,-28.80859 V 32.413259 c 0,-15.883302 12.84616,-28.8085861 28.63225,-28.8085861 h 375.67049 c 15.78609,0 28.63226,12.9252811 28.63226,28.8085861 V 157.61486 c 0,15.94758 -12.84617,28.80859 -28.63226,28.80859 z" fill="#8486f8" /><path d="m 834.89519,97.747017 h -31.63608 v 97.614803 c 0,32.21675 -25.94798,58.32453 -57.96753,58.32453 H 285.00256 c -32.01955,0 -57.96754,-26.10778 -57.96754,-58.32453 V 97.747017 h -31.63607 c -70.62196,0 -127.82256,57.552863 -127.82256,128.609763 v 663.04761 c 0,71.05689 57.2006,128.60971 127.82256,128.60971 h 639.49624 c 70.62197,0 127.82255,-57.55283 127.82255,-128.60971 V 226.35678 c 0,-71.0569 -57.20058,-128.609763 -127.82255,-128.609763 z M 735.89663,746.58325 H 294.39752 c -28.44052,0 -51.44858,-23.14976 -51.44858,-51.76543 0,-28.61567 23.00806,-51.76542 51.44858,-51.76542 h 441.49911 c 28.44051,0 51.44857,23.14975 51.44857,51.76542 0,28.55137 -23.07197,51.76543 -51.44857,51.76543 z m 0,-203.52494 H 294.39752 c -28.44052,0 -51.44858,-23.14976 -51.44858,-51.76543 0,-28.61567 23.00806,-51.76543 51.44858,-51.76543 h 441.49911 c 28.44051,0 51.44857,23.14976 51.44857,51.76543 0,28.61567 -23.07197,51.76543 -51.44857,51.76543 z" fill="#6c6cea" /><path d="m 962.71774,226.35678 c 0,-71.0569 -57.20058,-128.609763 -127.82255,-128.609763 h -31.63608 v 97.614803 c 0,32.21675 -25.94798,58.32453 -57.96753,58.32453 H 285.00256 c -32.01955,0 -57.96754,-26.10778 -57.96754,-58.32453 V 97.747017 h -31.63607 c -70.62196,0 -127.82256,57.552863 -127.82256,128.609763 v 663.04761 c 0,71.05689 57.2006,128.60971 127.82256,128.60971 H 446.1868 C 710.58775,935.06085 912.41957,709.47934 962.71774,430.71768 Z M 735.89663,746.58325 H 294.39752 c -28.44052,0 -51.44858,-23.14976 -51.44858,-51.76543 0,-28.61567 23.00806,-51.76542 51.44858,-51.76542 h 441.49911 c 28.44051,0 51.44857,23.14975 51.44857,51.76542 0,28.55137 -23.07197,51.76543 -51.44857,51.76543 z m 0,-203.52494 H 294.39752 c -28.44052,0 -51.44858,-23.14976 -51.44858,-51.76543 0,-28.61567 23.00806,-51.76543 51.44858,-51.76543 h 441.49911 c 28.44051,0 51.44857,23.14976 51.44857,51.76543 0,28.61567 -23.07197,51.76543 -51.44857,51.76543 z" fill="#757bf2" /><path d="m 268.32172,739.3811 c -15.69769,-9.28354 -25.32929,-26.24265 -25.30888,-44.56328 0,-28.61567 23.00807,-51.76542 51.44858,-51.76542 h 157.60522 c 41.09495,-29.45164 79.12216,-63.01879 113.57034,-99.99409 H 294.39752 c -28.44052,0 -51.44858,-23.14976 -51.44858,-51.76543 0,-28.61567 23.00806,-51.76543 51.44858,-51.76543 h 351.9594 c 37.13245,-57.10273 66.78729,-119.47846 87.62236,-185.90541 H 285.00256 c -32.01955,0 -57.96754,-26.10778 -57.96754,-58.32452 V 97.747017 h -31.63607 c -70.62196,0 -127.82256,57.552863 -127.82256,128.609763 v 554.8868 c 69.98285,-4.75856 137.34534,-19.16285 200.74533,-41.86248 z" fill="#8486f8" /><path d="M 538.66642,3.6046729 H 337.02634 c -21.15463,0 -38.28286,17.2337081 -38.28286,38.5186231 V 147.84052 c 0,21.2849 17.12823,38.51862 38.28286,38.51862 H 446.95373 C 485.23659,130.4782 516.29747,69.06704 538.66642,3.6046729 Z" fill="#8d92f8" />';
            zib_svgs['user-color'] = '<path d="M 776.46153,309.90478 H 977.5329 c 25.6088,0 46.3426,-21.46588 46.3426,-47.9788 0,-26.51292 -20.7338,-47.97881 -46.3426,-47.97881 H 776.46153 c -25.60875,0 -46.34258,21.46589 -46.34258,47.97881 0,26.51292 20.79554,47.9788 46.34258,47.9788 z M 977.59461,458.88824 H 812.00525 c -25.60875,0 -46.34259,21.46589 -46.34259,47.97881 0,26.51292 20.73384,47.9788 46.34259,47.9788 h 165.58936 c 25.60879,0 46.34259,-21.46588 46.34259,-47.9788 -0.062,-26.51292 -20.7955,-47.97881 -46.34259,-47.97881 z m 0,260.72105 h -53.21939 c -25.60875,0 -46.34259,21.46588 -46.34259,47.97881 0,26.51292 20.73384,47.97881 46.34259,47.97881 h 53.21939 c 25.60879,0 46.34259,-21.46589 46.34259,-47.97881 -0.062,-26.51293 -20.7955,-47.97881 -46.34259,-47.97881 z M 571.4064,479.77915 c 52.20483,-43.44286 85.71218,-110.01266 85.71218,-184.56827 0,-130.52025 -102.55842,-236.699708 -228.62753,-236.699708 -126.0691,0 -228.62752,106.179458 -228.62752,236.699708 0,74.55561 33.50735,141.12541 85.71217,184.56827 C 122.04994,533.50775 3.2006527,692.07419 3.2006527,878.94237 c 0,52.57864 41.2825423,95.31875 92.0680903,95.31875 H 761.83677 c 50.78556,0 92.06809,-42.74011 92.06809,-95.31875 C 853.78146,692.07419 734.93217,533.44386 571.4064,479.77915 Z m 12.83523,371.05313 H 272.74047 c -25.60875,0 -46.34258,-21.46588 -46.34258,-47.9788 0,-26.51293 20.73383,-47.97881 46.34258,-47.97881 h 311.50116 c 25.60876,0 46.34259,21.46588 46.34259,47.97881 0,26.51292 -20.79554,47.9788 -46.34259,47.9788 z" fill="#2595E8" /><path d="m 866.7401,213.94717 h -90.27856 c -25.60875,0 -46.34259,21.46589 -46.34259,47.97881 0,26.51292 20.73384,47.9788 46.34259,47.9788 h 100.39864 c -1.11074,-32.64603 -4.56638,-64.6532 -10.12008,-95.95761 z m -54.79656,244.94107 c -25.60875,0 -46.34258,21.46589 -46.34258,47.97881 0,26.51292 20.73383,47.9788 46.34258,47.9788 h 29.61976 c 10.42863,-30.98498 18.69748,-63.05603 24.68314,-95.95761 z M 571.4064,479.77915 c 52.20483,-43.44286 85.71218,-110.01266 85.71218,-184.56827 0,-130.52025 -102.55842,-236.699708 -228.62753,-236.699708 -126.0691,0 -228.62753,106.179458 -228.62753,236.699708 0,74.55561 33.50736,141.12541 85.71219,184.56827 C 122.04994,533.50775 3.2006527,692.07418 3.2006527,878.94237 c 0,52.57864 41.2825423,95.31875 92.0680903,95.31875 H 418.98805 C 579.92208,924.11017 714.19833,810.71152 795.0973,661.85585 744.62029,576.18397 665.44914,510.63636 571.4064,479.77915 Z m 12.83523,371.05313 H 272.74048 c -25.60875,0 -46.34259,-21.46588 -46.34259,-47.9788 0,-26.51292 20.73384,-47.9788 46.34259,-47.9788 h 311.50115 c 25.60875,0 46.34258,21.46588 46.34258,47.9788 0,26.44903 -20.79554,47.9788 -46.34258,47.9788 z" fill="#3A9CED" /><path d="m 18.627612,764.266 c 12.588398,0.76664 25.238504,1.27773 38.012026,1.27773 217.211582,0 409.184652,-111.35427 525.997592,-281.80362 -3.70247,-1.34161 -7.40494,-2.68323 -11.16912,-3.89708 15.98233,-13.28839 30.23684,-28.81283 42.26987,-46.0622 11.66278,-20.69925 22.21482,-42.03736 31.71782,-64.07822 7.52836,-23.38248 11.66278,-48.42601 11.66278,-74.42785 0,-130.52024 -102.55842,-236.699701 -228.62753,-236.699701 -126.0691,0 -228.62753,106.179461 -228.62753,236.699701 0,74.55562 33.50736,141.12542 85.71219,184.56827 C 156.79145,522.00817 55.775728,629.33759 18.627612,764.266 Z" fill="#59adf8" /><path d="m 506.11951,72.566216 c -24.25118,-9.071892 -50.4153,-14.055044 -77.62846,-14.055044 -126.0691,0 -228.62753,106.179458 -228.62753,236.699708 0,48.4899 14.25451,93.59381 38.50569,131.15911 124.64983,-81.64703 220.35868,-206.22583 267.7503,-353.803774 z" fill="#6bc2fc" />';
            zib_svgs['user-color-2'] = '<path d="m 663.80596,435.43096 c 54.78277,-44.03343 89.94476,-111.50819 89.94476,-187.07733 0,-132.29455 -107.62289,-239.2698887 -239.91744,-239.2698887 -132.29456,0 -239.91745,106.9753387 -239.91745,239.2698887 0,75.56914 35.16199,143.0439 89.94476,187.07733 -171.60087,54.45899 -296.319087,215.18102 -296.319087,404.58952 0,53.29341 48.999157,125.97022 103.952207,155.31599 102.83616,54.91613 233.16134,0 349.742,0 116.58067,0 248.83587,58.38663 349.742,0 C 922.66429,965.4294 960.25456,893.31389 960.25456,840.02048 960.12505,650.61198 835.40683,489.8252 663.80596,435.43096 Z m 13.46905,376.0973 H 350.39154 c -26.87334,0 -48.63104,-21.75769 -48.63104,-48.63103 0,-26.87335 21.7577,-48.63104 48.63104,-48.63104 h 326.88347 c 26.87334,0 48.63104,21.75769 48.63104,48.63104 0,26.87334 -21.82245,48.63103 -48.63104,48.63103 z" fill="#2595E8" /><path d="m 663.80596,435.43096 c 54.78277,-44.03343 89.94476,-111.50819 89.94476,-187.07733 0,-132.29455 -107.62289,-239.9174391 -239.91744,-239.9174391 -132.29456,0 -239.91745,107.6228891 -239.91745,239.9174391 0,75.56914 35.16199,143.0439 89.94476,187.07733 -171.60087,54.45899 -296.319087,215.18102 -296.319087,404.58952 0,53.29341 34.441907,77.78436 96.614527,96.61453 191.55794,58.017 339.70497,0 339.70497,0 176.36556,0 309.78814,-165.77291 394.682,-316.65217 C 845.57337,533.14632 762.49265,466.70765 663.80596,435.43096 Z m 13.46905,376.0973 H 350.39154 c -26.87334,0 -48.63104,-21.75769 -48.63104,-48.63103 0,-26.87335 21.7577,-48.63104 48.63104,-48.63104 h 326.88347 c 26.87334,0 48.63104,21.75769 48.63104,48.63104 0,26.80858 -21.82245,48.63103 -48.63104,48.63103 z" fill="#3a9ced" /><path d="m 83.730264,723.78518 c 13.210029,0.77706 26.484816,1.2951 39.889106,1.2951 227.93776,0 429.39071,-112.86805 551.97201,-285.63451 -3.8853,-1.35985 -7.77061,-2.71971 -11.72066,-3.95005 16.77155,-13.46905 31.72997,-29.20453 44.3572,-46.68839 12.23871,-20.98064 23.31182,-42.60882 33.2841,-64.94931 7.90011,-23.70035 12.2387,-49.08433 12.2387,-75.43963 0,-132.29456 -107.62289,-239.9174441 -239.91744,-239.9174441 -132.29456,0 -239.91745,107.6228841 -239.91745,239.9174441 0,75.56914 35.16199,143.04389 89.94476,187.07733 C 228.71681,478.23405 122.7128,587.02252 83.730264,723.78518 Z" fill="#59ADF8" /><path d="M 595.29512,22.682301 C 569.84639,13.487084 542.39025,8.4361909 513.83328,8.4361909 c -132.29456,0 -239.91745,107.6228891 -239.91745,239.9174391 0,49.14908 14.95842,94.86615 40.40715,132.94211 C 445.12817,298.53879 545.56325,172.26646 595.29512,22.682301 Z" fill="#6BC2FC" />';
            zib_svgs['gift-color'] = '<path d="M 960.50258,200.79974 H 618.15627 L 726.18827,95.952356 C 746.22761,76.534996 746.69414,44.536769 727.2294,24.543448 707.81203,4.5041121 675.81381,4.0375857 655.82049,23.502323 L 506.14349,168.76984 371.28722,25.094632 C 352.17952,4.7620784 320.21087,3.7209536 299.87831,22.828655 c -20.33255,19.1077 -21.37367,51.076354 -2.26597,71.408907 L 397.62156,200.79974 H 65.012828 c -33.98966,0 -61.4876019,27.55918 -61.4876019,61.4876 V 406.0238 c 0,33.98966 27.5591839,61.4876 61.4876019,61.4876 h 46.973092 v 411.79544 c 0,77.83939 63.07991,140.98056 140.98054,140.98056 h 519.58248 c 77.83939,0 140.98054,-63.07993 140.98054,-140.98056 V 467.5114 h 46.9731 c 33.98966,0 61.48762,-27.55919 61.48762,-61.4876 V 262.28734 c 0,-33.98966 -27.49796,-61.4876 -61.48762,-61.4876 z m -397.2197,590.07274 c 0,27.92665 -22.59854,50.52518 -50.52517,50.52518 -27.92665,0 -50.52518,-22.59853 -50.52518,-50.52518 V 622.27152 c 0,-27.92663 22.59853,-50.52517 50.52518,-50.52517 27.92663,0 50.52517,22.59854 50.52517,50.52517 z" fill="#ff3369" /><path d="M 958.35908,200.79974 H 618.15627 L 726.18827,95.952356 C 746.22761,76.534996 746.69414,44.536769 727.2294,24.543448 707.81548,4.5171078 675.78558,4.0271668 655.82049,23.502323 L 506.14349,168.76984 371.28722,25.094632 C 352.17952,4.7620784 320.21087,3.7209536 299.87831,22.828655 c -20.33255,19.1077 -21.37367,51.076354 -2.26597,71.408907 L 397.62156,200.79974 H 65.012828 c -33.98966,0 -61.4876019,27.55918 -61.4876019,61.4876 V 406.0238 c 0,33.98966 27.5591839,61.4876 61.4876019,61.4876 h 46.973092 v 411.79544 c 0,77.83939 63.07991,140.98056 140.98054,140.98056 H 364.97923 C 617.91129,965.2915 823.74778,784.31952 913.52948,546.33066 V 467.5114 h 25.04824 c 15.81643,-61.79387 23.79976,-125.33136 23.76214,-189.11725 -0.0613,-26.21184 -1.34735,-52.11748 -3.98078,-77.59441 z m -395.0762,590.07274 c 0,27.92665 -22.59854,50.52518 -50.52517,50.52518 -27.92665,0 -50.52518,-22.59853 -50.52518,-50.52518 V 622.27152 c 0,-27.92663 22.59853,-50.52517 50.52518,-50.52517 27.92663,0 50.52517,22.59854 50.52517,50.52517 z" fill="#ff4d7c" /><path d="M 618.15627,200.79974 726.18827,95.952356 C 746.22761,76.534996 746.69414,44.536769 727.2294,24.543448 707.81548,4.5171078 675.78558,4.0271668 655.82049,23.502323 L 506.14349,168.76984 371.28722,25.094632 C 352.17952,4.7620784 320.21087,3.7209536 299.87831,22.828655 c -20.33255,19.1077 -21.37367,51.076354 -2.26597,71.408907 L 397.62156,200.79974 H 65.012828 c -33.98966,0 -61.4876019,27.55918 -61.4876019,61.4876 V 406.0238 c 0,33.98966 27.5591839,61.4876 61.4876019,61.4876 h 46.973092 v 291.6374 c 132.22284,-20.39379 253.05456,-75.08346 353.43123,-154.39266 6.12426,-16.47428 20.57752,-28.84528 38.2154,-32.09115 C 611.97076,474.92175 692.01489,346.37347 729.98531,200.86098 H 618.15627 Z" fill="#ff5f89" />';
            zib_svgs['security-color'] = '<path d="M 919.69915,164.38967 549.01842,10.797004 C 529.75915,2.7923704 508.21285,2.5516296 488.71284,10.014596 L 106.05526,157.04707 c -31.401937,12.07822 -52.12183,42.24887 -52.120399,75.89355 v 293.4631 c 0,113.9908 83.657449,321.1483 411.125189,483.46778 21.30557,10.5325 46.28243,11.1945 68.06948,1.625 332.16219,-145.76855 436.7039,-381.45384 436.7039,-499.35667 V 239.50081 c 0,-32.86112 -19.80093,-62.53243 -50.13428,-75.11114 z M 554.43509,497.09352 v 234.66215 c 0,23.47223 -19.07871,42.55095 -42.55094,42.55095 -23.47224,0 -42.55095,-19.07872 -42.55095,-42.55095 V 497.09352 c -44.53706,-17.15278 -76.25466,-60.24539 -76.25466,-110.80097 0,-65.60188 53.20372,-118.80561 118.80561,-118.80561 65.60188,0 118.80561,53.20373 118.80561,118.80561 0,50.55558 -31.65742,93.64819 -76.25467,110.80097 z" fill="#6c6cea" /><path d="m 897.00932,251.41749 c 0,-33.64354 -2.34722,-66.74541 -6.86111,-99.18524 L 548.95824,10.857189 C 529.69897,2.8525556 508.15266,2.6118148 488.65265,10.074781 L 106.05526,157.04707 c -31.401937,12.07822 -52.12183,42.24887 -52.120399,75.89355 v 293.4631 c 0,100.02783 64.458359,271.79642 301.527919,422.0789 C 666.7407,869.33907 897.00932,587.25097 897.00932,251.41749 Z M 554.43509,497.09352 v 234.66215 c 0,23.47223 -19.07871,42.55095 -42.55094,42.55095 -23.47224,0 -42.55095,-19.07872 -42.55095,-42.55095 V 497.09352 c -44.59724,-17.15278 -76.25466,-60.24539 -76.25466,-110.80097 0,-65.60188 53.20372,-118.80561 118.80561,-118.80561 65.60188,0 118.80561,53.20373 118.80561,118.80561 0,50.55558 -31.65742,93.64819 -76.25467,110.80097 z" fill="#757bf2" /><path d="M 548.95824,10.797004 C 529.69897,2.7923704 508.15266,2.5516296 488.65265,10.014596 L 106.05526,157.04707 c -31.401937,12.07822 -52.12183,42.24887 -52.120399,75.89355 v 293.4631 c 0,46.76391 14.143525,109.17598 53.324099,177.72694 138.42599,-24.49538 263.12975,-88.59264 362.07424,-180.13435 v -26.90279 c -44.59724,-17.15278 -76.25466,-60.24539 -76.25466,-110.80097 0,-65.60188 53.20372,-118.80561 118.80561,-118.80561 45.86113,0 85.58337,26.06019 105.3843,64.15743 41.76854,-79.02318 69.27318,-166.71304 79.02319,-259.759375 z" fill="#8486f8" />';
            zib_svgs['trend-color'] = '<path d="M 904.33245,30.216169 H 122.79236 C 57.093827,30.216169 3.8689304,83.441066 3.8689304,149.1396 v 547.93184 c 0,65.69854 53.2248966,118.92343 118.9234296,118.92343 h 781.54009 c 65.69854,0 118.92345,-53.22489 118.92345,-118.92343 V 149.1396 c 0,-65.698534 -53.22491,-118.923431 -118.92345,-118.923431 z M 774.93359,370.39531 629.48853,504.21445 c -22.283,20.52701 -56.55523,20.46646 -78.83824,-0.0605 L 455.64476,416.65677 331.57444,533.4609 c -10.79251,10.17425 -25.07137,15.82946 -39.90354,15.80398 -16.05162,0.0381 -31.39994,-6.58364 -42.38615,-18.2866 -22.0408,-23.43349 -20.95087,-60.24889 2.48262,-82.28969 L 415.31736,294.70576 c 22.25031,-20.94998 56.91046,-21.13504 79.38321,-0.42386 l 95.42939,87.92099 106.02593,-97.48815 c 23.6757,-21.7986 60.4911,-20.22425 82.28969,3.45144 21.67749,23.61514 20.1637,60.43054 -3.51199,82.22913 z m 7.81116,504.15301 H 244.38007 c -32.15293,0 -58.25069,26.0372 -58.25069,58.25068 0,32.15292 26.03721,58.25068 58.25069,58.25068 h 538.36468 c 32.15292,0 58.25068,-26.03721 58.25068,-58.25068 0,-32.15292 -26.09776,-58.25068 -58.25068,-58.25068 z" fill="#6C6CEA" /><path fill="#757bf2" d="M 904.33245,30.216169 H 122.79236 C 57.093827,30.216169 3.8689304,83.441066 3.8689304,149.1396 v 547.93184 c 0,65.69854 53.2248966,118.92343 118.9234296,118.92343 H 663.57911 C 877.87138,678.36098 1019.8044,437.97095 1019.8044,164.39862 c 0,-16.71226 -0.6055,-33.24286 -1.6349,-49.65235 C 1003.3949,65.820537 958.04176,30.216169 904.33245,30.216169 Z M 774.93359,370.39531 629.48853,504.21445 c -22.283,20.52701 -56.55523,20.46646 -78.83824,-0.0605 L 455.64476,416.65677 331.57444,533.4609 c -10.79251,10.17425 -25.07137,15.82946 -39.90354,15.80398 -16.05162,0.0381 -31.39994,-6.58364 -42.38615,-18.2866 -22.0408,-23.43349 -20.95087,-60.24889 2.48262,-82.28969 L 415.31736,294.70576 c 22.25031,-20.94998 56.91046,-21.13504 79.38321,-0.42386 l 95.42939,87.92099 106.02593,-97.48815 c 23.6757,-21.7986 60.4911,-20.22425 82.28969,3.45144 21.67749,23.61514 20.1637,60.43054 -3.51199,82.22913 z M 553.73842,874.54832 H 244.38007 c -32.15293,0 -58.25069,26.0372 -58.25069,58.25068 0,1.08993 0.12111,2.11931 0.18166,3.20924 19.67928,1.51379 39.54022,2.24041 59.58282,2.24041 109.41682,0 213.5051,-22.70687 307.84456,-63.70033 z" id="path2136" /><path d="M 122.79236,30.216169 C 57.093827,30.216169 3.8689304,83.441066 3.8689304,149.1396 v 513.65961 c 10.0515736,0.36331 20.1636976,0.66607 30.2758226,0.66607 188.255067,0 360.827257,-67.27288 494.949147,-178.99067 L 455.64476,416.65677 331.57444,533.4609 c -10.79251,10.17425 -25.07137,15.82946 -39.90354,15.80398 -16.05162,0.0381 -31.39994,-6.58364 -42.38615,-18.2866 -22.0408,-23.43349 -20.95087,-60.24889 2.48262,-82.28969 L 415.31736,294.70576 c 22.25031,-20.94998 56.91046,-21.13504 79.38321,-0.42386 l 95.42939,87.92099 106.02593,-97.48815 c 2.11931,-1.93766 4.35972,-3.6331 6.66069,-5.20745 44.3238,-75.81066 76.11341,-159.85634 92.52291,-249.230569 H 122.79236 Z" fill="#8486f8" />';
            zib_svgs['msg-color'] = '<path d="M 568.39536,1021.6475 H 459.38412 c -41.47503,0 -75.02647,-33.61333 -75.02647,-75.02646 0,-41.47503 33.61334,-75.02647 75.02647,-75.02647 h 109.01124 c 41.47503,0 75.02648,33.61334 75.02648,75.02647 0,41.41313 -33.61335,75.02646 -75.02648,75.02646 z M 875.62011,579.78367 H 844.73049 V 332.23345 C 844.73049,149.4957 696.59654,1.3617451 513.85879,1.3617451 331.12104,1.3617451 182.98708,149.4957 182.98708,332.23345 v 247.48832 h -30.88961 c -68.588557,0 -124.17748,55.58892 -124.17748,124.17748 0,68.58856 55.588923,124.17748 124.17748,124.17748 h 723.52264 c 68.58856,0 124.17748,-55.58892 124.17748,-124.17748 0.0619,-68.52665 -55.58892,-124.11558 -124.17748,-124.11558 z M 386.02903,512.06176 c 0,28.4787 -23.08654,51.5652 -51.56523,51.5652 -28.47868,0 -51.56522,-23.0865 -51.56522,-51.5652 V 301.59145 c 0,-28.47871 23.08654,-51.5652 51.56522,-51.5652 28.47869,0 51.56523,23.08649 51.56523,51.5652 z" fill="#fc7032" /><path d="M 844.73049,579.78367 V 332.23345 C 844.73049,149.4957 696.59654,1.3617451 513.85879,1.3617451 331.12104,1.3617451 182.98708,149.4957 182.98708,332.23345 v 247.48832 h -30.88961 c -68.588557,0 -124.17748,55.58892 -124.17748,124.17748 0,68.58856 55.588923,124.17748 124.17748,124.17748 H 625.34615 C 726.86712,767.90699 811.36476,682.17129 870.04883,579.65987 H 844.73049 Z M 386.02903,512.06176 c 0,28.4787 -23.08654,51.5652 -51.56523,51.5652 -28.47868,0 -51.56522,-23.0865 -51.56522,-51.5652 V 301.59145 c 0,-28.47871 23.08654,-51.5652 51.56522,-51.5652 28.47869,0 51.56523,23.08649 51.56523,51.5652 z m 152.65288,359.4709 h -79.29779 c -29.58965,0 -55.0937,17.14714 -67.28859,42.03216 50.94619,-8.60452 100.0972,-22.84222 146.58638,-42.03216 z" fill="#ff7e3e" /><path d="m 30.581821,678.3333 c 20.304194,1.79519 40.856,2.78564 61.655419,2.78564 336.8763,0 616.5542,-244.57888 671.33838,-565.85562 C 702.91065,45.498607 613.58457,1.3617451 513.92069,1.3617451 331.18294,1.3617451 183.04899,149.4957 183.04899,332.23345 V 579.72177 H 152.15937 C 92.299143,579.78367 42.4053,622.00154 30.581821,678.3333 Z M 282.83668,301.59145 c 0,-28.47871 23.08653,-51.5652 51.56522,-51.5652 28.47869,0 51.56523,23.08649 51.56523,51.5652 v 210.47031 c 0,28.4787 -23.08654,51.5652 -51.56523,51.5652 -28.47869,0 -51.56522,-23.0865 -51.56522,-51.5652 z" fill="#ff9552" />';
            zib_svgs['home-color'] = '<path d="M 1006.2514,425.49937 551.5932,63.42086 C 528.86313,45.308141 497.09785,45.308141 474.36778,63.479476 L 20.391461,425.49937 c -29.6627416,20.7505 -15.4564478,68.58214 20.400238,68.58214 H 133.92816 V 905.1054 c 0,41.14928 52.27913,74.50247 72.2248,74.50247 0,0 52.46333,7.94426 76.79922,0 37.5989,-12.27387 70.20152,-70.00748 95.80126,-70.00748 h 76.79922 76.79922 76.79923 76.79922 c 25.59974,0 32.531,58.10265 57.7972,70.00748 25.2662,11.90483 76.79922,0 76.79922,0 19.94564,0 72.2248,-33.35319 72.2248,-74.50247 V 494.08151 h 93.19328 c 35.74347,0 49.94937,-47.83164 20.28657,-68.58214 z M 673.36955,658.62954 c 24.1507,0 43.69856,20.16432 43.69856,45.07662 0,24.91232 -19.54786,45.07665 -43.69856,45.07665 -181.89773,1.13067 -121.82819,0 -316.85718,0 -24.15074,0 -43.69856,-20.16433 -43.69856,-45.07665 0,-24.9123 19.54786,-45.07662 43.69856,-45.07662 189.23552,-1.02371 4.40318,0.11724 316.85718,0.11724 z" fill="#2ed2f2" /><path d="M 474.36778,63.42086 20.391461,425.49937 c -29.6627416,20.7505 -15.4564478,68.58214 20.400238,68.58214 H 133.92816 V 905.1054 c 0,41.14928 57.33572,91.50429 156.23377,68.50183 0,0 61.03326,-54.70147 76.3507,-65.00694 8.89538,-5.98476 153.35892,-1.00011 153.35892,-1.00011 221.55091,-70.34427 372.50222,-255.95561 372.50222,-564.57521 0,-2.81364 -0.17048,-5.56866 -0.2273,-8.38227 L 551.5932,63.42086 c -22.74724,-18.113443 -54.47818,-18.113443 -77.22542,0 z m 199.00177,595.15005 c 24.15078,0 43.69856,20.16433 43.69856,45.07665 0,24.91231 -19.54786,45.07663 -43.69856,45.07663 -179.89752,3.13089 -121.82818,0 -316.85718,0 -24.15125,0 -43.69856,-20.16432 -43.69856,-45.07663 0,-24.91232 19.54786,-45.07665 43.69856,-45.07665 207.25458,0.9602 4.38835,0 316.85718,0 z" fill="#4cd7f2" /><path d="M 474.36778,63.42086 20.391461,425.49937 c -29.6627416,20.7505 -15.4564478,68.58214 20.400238,68.58214 h 93.136461 v 269.053 c 62.67817,-5.09969 122.7992,-33.51953 179.05613,-56.02854 -0.0568,-1.11373 -0.17048,-2.28607 -0.17048,-3.39981 0,-24.9123 19.54565,-45.07662 43.69856,-45.07662 C 553.07296,584.6626 674.91397,384.09552 713.48812,192.49596 L 551.53637,63.538094 C 528.8063,45.308141 497.09785,45.308141 474.36778,63.42086 Z" fill="#60daf2" /><path d="m 535.5685,54.335192 c -20.17294,-7.971941 -43.41444,-5.04108 -61.20072,9.085668 L 20.391461,425.49937 c -29.6627416,20.7505 -15.4564478,68.58214 20.400238,68.58214 h 93.136461 v 2.63778 C 328.61121,426.32001 479.87983,260.90225 535.5685,54.335192 Z" fill="#74e6f8" />';
            zib_svgs['add-color'] = '<path d="m 132.75454,821.87989 h 762.27705 c 71.02097,6.77839 127.34791,-54.93705 127.34791,-118.50996 l 0,-373.0267 C 1027.6842,259.49724 964.56765,201.93479 899.54336,201.85 603.52363,201.46306 433.38233,201.07891 137.3626,200.69169 66.49123,193.75246 4.5811081,254.4676 4.0885562,317.87001 L 3.890813,694.25518 C 3.8566897,759.20555 67.804167,821.87989 132.75454,821.87989 Z M 663.21747,468.67994 c 25.03862,0.0645 40.74679,18.80225 40.74679,42.03175 0,23.22954 -18.22743,42.03179 -40.74679,42.03179 -27.12309,0 -68.09943,0.15711 -82.35641,0.15711 -14.25697,0 -17.81575,2.53062 -17.81575,16.70032 0,16.45124 -1.18173,75.76021 -1.18173,75.76021 -0.23541,12.81018 -17.7735,28.66366 -40.52453,28.66366 -20.73987,0 -43.93049,-13.84667 -44.20397,-30.66184 l -1.22664,-75.41982 c -0.25727,-15.81807 -8.7481,-15.10147 -16.10808,-15.10147 -13.5192,0 -58.5187,-0.0972 -92.03683,-0.0982 -22.51939,0 -40.74679,-18.80225 -40.74679,-42.03179 0,-23.2295 18.22743,-42.03175 40.74679,-42.03175 0.83475,0 1.88552,10e-5 3.13862,3.1e-4 32.14879,0.0101 62.55932,0.0185 94.50761,0.0347 7.52081,0.003 10.55106,-4.53477 10.5534,-10.40981 0.002,-5.20596 0.0139,-60.74822 0.0205,-77.41089 0,-22.57185 20.88677,-38.51906 42.96811,-38.51906 21.70493,0 41.01475,15.21214 41.01475,35.07288 0,17.71 0.36656,74.64185 0.36529,80.89233 -10e-4,7.8219 6.90728,10.41677 13.55884,10.41941 27.29749,0.005 59.54003,0.0296 86.72208,0.0299 1.08085,2e-4 1.95363,3.1e-4 2.60466,3.1e-4 z" fill="#fb5e99" /><path d="m 132.75414,821.76984 c 0,0 451.31832,-24.18823 643.4704,-128.70718 102.74959,-55.88949 244.74016,-219.67378 244.74016,-251.46024 l 1.4144,-111.36924 C 1027.6838,259.38719 964.56726,201.82474 899.54297,201.73995 603.52327,201.35301 433.38197,200.96886 137.3622,200.58164 66.49083,193.64241 4.580714,254.35755 4.088164,317.75996 L 3.890414,694.14513 C 3.856314,759.0955 67.80377,821.76984 132.75414,821.76984 Z M 663.21707,468.56989 c 25.0386,0.0645 40.7468,18.80225 40.7468,42.03175 0,23.22954 -18.2274,42.03179 -40.7468,42.03179 -27.1231,0 -68.0994,0.15711 -82.3564,0.15711 -14.257,0 -17.8158,2.53062 -17.8158,16.70032 0,16.45124 -1.1817,75.76021 -1.1817,75.76021 -0.2354,12.81018 -17.7735,28.66366 -40.5245,28.66366 -20.7399,0 -43.9305,-13.84667 -44.204,-30.66184 l -1.2266,-75.41982 c -0.2573,-15.81807 -8.7481,-15.10147 -16.1081,-15.10147 -13.5192,0 -58.5187,-0.0972 -92.0368,-0.0982 -22.5194,0 -40.7468,-18.80225 -40.7468,-42.03179 0,-23.2295 18.2274,-42.03175 40.7468,-42.03175 0.8347,0 1.8855,10e-5 3.1386,3.1e-4 32.1488,0.0101 62.5593,0.0185 94.5076,0.0347 7.5208,0.003 10.5511,-4.53477 10.5534,-10.40981 0,-5.20596 0.014,-60.74822 0.021,-77.41089 0,-22.57185 20.8868,-38.51906 42.9681,-38.51906 21.7049,0 41.0148,15.21214 41.0148,35.07288 0,17.71 0.3665,74.64185 0.3652,80.89233 -10e-4,7.8219 6.9073,10.41677 13.5589,10.41941 27.2975,0.005 59.54,0.0296 86.7221,0.0299 1.0808,2e-4 1.9536,3.1e-4 2.6046,3.1e-4 z" fill="#fb71ac" /><path d="M 562.65545,212.17869 C 668.25792,187.56834 245.79263,201.20966 137.3622,200.58164 66.49083,193.64241 4.58071,254.35755 4.08816,317.75996 L 9.5478685,514.52082 C 117.73973,720.64396 214.81282,514.1631 299.95919,395.14608 385.10555,276.12906 496.51304,244.57588 562.65545,212.17869 Z" fill="#fb84b7" />';
            zib_svgs['tag-color'] = ' <path d="M 335.62909,311.2937 584.9847,80.429349 C 625.1003,43.262523 690.09617,42.955359 730.70323,79.692156 L 892.39428,226.14788 c 24.02022,21.80863 25.24887,57.25534 2.64161,80.35406 z" fill="#1dce75" /><path d="M 155.93823,310.80224 308.78297,82.333765 c 27.03041,-43.002939 84.28576,-60.879876 133.92343,-41.835717 37.35113,14.313836 72.42924,27.890478 71.38488,27.890478 -2.27301,0 -263.30085,241.369354 -263.30085,241.369354 z" fill="#48e1aa" /><path d="M 889.99841,384.82873 H 134.68249 c -72.367799,0 -131.0360949,58.66829 -131.0360949,131.0361 v 342.91772 c 0,72.3678 58.6682959,131.0361 131.0360949,131.0361 h 755.31592 c 72.3678,0 131.03609,-58.6683 131.03609,-131.0361 V 515.86483 c 0,-72.36781 -58.66829,-131.0361 -131.03609,-131.0361 z M 196.85246,767.37059 c -44.2316,0 -80.0469,-35.81531 -80.0469,-80.0469 0,-44.2316 35.8153,-80.0469 80.0469,-80.0469 44.23159,0 80.0469,35.8153 80.0469,80.0469 0,44.17016 -35.81531,80.0469 -80.0469,80.0469 z" fill="#05c46d" /><path d="m 134.68249,384.82873 c -72.367799,0 -131.0360949,58.66829 -131.0360949,131.0361 v 342.91772 c 0,72.3678 58.6682959,131.0361 131.0360949,131.0361 H 653.85084 C 827.88988,857.30816 940.18898,648.00671 940.18898,412.41204 c 0,-5.89755 -0.0614,-11.73366 -0.24573,-17.63121 -15.83388,-6.55581 -32.80747,-9.91713 -49.94484,-9.89067 H 134.68249 Z m 62.16997,382.54186 c -44.2316,0 -80.0469,-35.81531 -80.0469,-80.0469 0,-44.2316 35.8153,-80.0469 80.0469,-80.0469 44.23159,0 80.0469,35.8153 80.0469,80.0469 0,44.17016 -35.81531,80.0469 -80.0469,80.0469 z" fill="#1dce75" /><path d="m 720.38253,307.97633 c 13.94524,-51.97212 21.3786,-106.27869 21.3786,-162.24395 0,-19.71992 -0.98292,-39.1941 -2.76447,-58.483994 l -8.35486,-7.55623 C 690.03474,42.955359 625.1003,43.262523 584.92327,80.429349 L 335.62909,311.2937 Z m -15.91109,76.8524 H 134.68249 c -72.367799,0 -131.0360949,58.66829 -131.0360949,131.0361 v 342.91772 c 0,7.24907 0.7371932,14.31384 1.8429831,21.19431 3.6245334,0.0614 7.2490668,0.12286 10.9350328,0.12286 320.187599,0 591.843309,-207.45846 688.047029,-495.27099 z M 196.85246,767.37059 c -44.2316,0 -80.0469,-35.81531 -80.0469,-80.0469 0,-44.2316 35.8153,-80.0469 80.0469,-80.0469 44.23159,0 80.0469,35.8153 80.0469,80.0469 0,44.17016 -35.81531,80.0469 -80.0469,80.0469 z" fill="#3cd38e" /><path d="m 414.63163,310.61794 c 39.86987,-49.20765 72.5521,-103.69852 96.75661,-162.05965 L 335.62909,311.2937 Z m -279.94914,74.21079 c -72.367799,0 -131.0360949,58.66829 -131.0360949,131.0361 v 87.54169 C 147.89054,568.81987 275.36354,491.23028 371.75156,384.82873 Z" fill="#48e1aa" />';
            zib_svgs['ontop-color'] = '<path d="m 569.79003,20.140354 -0.0393,0.03144 C 542.22372,-5.5823944 518.51356,2.7819611 491.41948,23.32867 253.25786,207.61093 644.58124,154.94155 657.85324,375.31211 668.3103,548.94303 440.9803,723.99696 503.98839,724.55322 c 68.3366,0.60331 71.74508,-1.49019 98.54665,-4.33347 85.39163,-13.64557 131.11031,20.35632 162.66781,93.52401 4.83748,11.26564 23.45091,25.08955 33.25811,23.41783 10.16842,-1.70337 22.13943,-19.73438 25.09102,-32.53681 19.35439,-82.96466 11.3184,-164.73215 -25.36148,-241.07671 -17.68718,-36.79453 -20.69584,-71.75392 -19.02723,-111.16922 3.213,-76.73377 -3.89769,-138.04489 -29.91868,-199.79823 0.0156,-0.14136 -0.008,-0.25128 0.039,-0.35341 C 703.74191,125.89678 569.79003,20.140354 569.79003,20.140354 Z" fill="#f23d4f" /><path d="m 618.95449,832.97623 -171.47832,-0.75921 c -0.17646,39.5085 26.84357,114.89391 50.73867,168.68578 12.86777,28.9293 56.39691,28.9772 69.31836,0.069 24.30618,-54.26551 51.42129,-140.60393 51.42129,-167.99575 z" fill="#f23d4f" /><path d="m 533.93534,761.91918 c 0,-0.14222 -0.29053,0.0395 -0.4319,0.0239 l -0.42409,-0.0468 c -40.40373,-0.16798 -85.45567,34.31467 -85.60318,70.32071 -0.0848,24.74482 10.41049,63.49979 24.19611,102.26031 51.72665,-17.07141 99.97811,-43.26815 142.46956,-77.34975 5.19043,-5.82055 4.72067,-16.86239 4.81265,-24.15132 0.15531,-36.07671 -44.36469,-70.77503 -85.01915,-71.05699 z" fill="#fc4956" /><path d="M 448.15913,59.404218 C 331.43645,165.99614 370.04052,202.40237 370.04052,202.40237 c 0,0 19.24198,434.00789 23.60284,517.02068 69.52305,0.80721 112.13504,11.79273 179.53751,1.02612 C 693.46339,556.21317 741.9076,407.30172 637.52525,226.51243 574.55198,147.90896 538.46988,83.826476 448.15913,59.404218 Z m 155.8077,387.011462 c -40.28853,40.91091 -99.44535,40.49693 -140.97747,-0.96911 -39.92113,-39.85731 -41.66155,-102.82917 -4.01099,-142.85084 37.52502,-39.85666 106.09684,-40.47803 146.01751,-1.26467 41.08371,40.34338 40.62495,102.82205 -1.02905,145.08462 z" fill="#fc4956" /><path d="m 287.77243,466.23854 c 1.48035,28.06553 -4.36393,59.2931 -16.08626,84.79211 -38.12309,82.86003 -48.17036,167.71073 -27.78498,255.88546 2.59929,11.12586 15.3307,24.76541 25.93417,27.54578 7.71309,2.06778 22.46061,-9.68278 29.23131,-18.8441 19.77852,-26.86323 35.3928,-56.83333 56.31073,-82.67647 7.3754,-9.13034 25.30056,-13.69765 38.30521,-13.54971 C 514.51696,574.15867 539.58891,546.36287 503.33647,470.66352 418.02485,442.57412 421.32781,342.6174 458.97837,302.59573 475.41189,273.83405 480.2341,206.95752 460.78201,171.11172 442.29384,135.43228 441.3979,132.46481 413.44173,93.918884 321.10639,194.76101 279.91022,318.74144 287.77243,466.23854 Z" fill="#ff5c64" />';
            zib_svgs['comment-color'] = '<path d="M 916.07974,259.8083 H 296.90951 c -55.61912,0 -100.68152,45.06237 -100.68152,100.68152 v 401.82121 c 0,55.62089 45.06237,100.68153 100.68152,100.68153 h 68.16663 c 12.54747,0 22.74232,10.18915 22.74232,22.74232 v 80.83477 c 0,18.76091 21.35486,29.43833 36.37565,18.21799 L 581.39965,867.45657 c 3.92109,-2.9559 8.68672,-4.52434 13.63333,-4.52434 h 320.98644 c 55.61914,0 100.68148,-45.06237 100.68148,-100.68152 V 360.48982 C 1016.7613,304.87067 971.69889,259.8083 916.07974,259.8083 Z M 813.58849,720.50619 h -415.0926 c -26.60308,0 -48.19924,-21.59616 -48.19924,-48.19925 0,-26.60308 21.59616,-48.19924 48.19924,-48.19924 h 415.15292 c 26.60308,0 48.19924,21.59616 48.19924,48.19924 -0.0603,26.60309 -21.59615,48.19925 -48.25956,48.19925 z m 0,-190.80627 h -415.0926 c -26.60307,0 -48.19924,-21.59615 -48.19924,-48.19924 0,-26.60308 21.59616,-48.19924 48.19924,-48.19924 h 415.15292 c 26.60307,0 48.19924,21.59616 48.19924,48.19924 0,26.60309 -21.59615,48.19924 -48.25956,48.19924 z" fill="#ff8e12"></path><path d="M 97.114901,651.07273 C 47.347224,647.51359 7.8950281,605.88972 7.8950281,555.21717 V 253.77585 c 0,-116.2554 94.2269419,-210.532354 210.5323619,-210.532354 h 579.23544 c 53.08552,0 96.09686,43.001329 96.09686,96.096864 v 31.67034 c 0,26.36179 -20.32934,49.40573 -46.69113,50.18995 -27.26665,0.84454 -49.70735,-21.05324 -49.70735,-48.19924 0,-18.64026 -15.08112,-33.72138 -33.72137,-33.66105 l -545.21245,0.30162 c -62.91841,0 -114.13388,51.21028 -114.13388,114.13387 v 281.47393 c 0,10.07418 6.21342,19.2435 15.74469,22.56134 19.30382,6.63569 32.93715,25.1553 32.3339,46.87211 -0.90486,28.23184 -27.146,48.38021 -55.257199,46.3895 z" fill="#fca315"></path><path d="M 916.07974,259.8083 H 296.90951 c -55.61915,0 -100.68152,45.06058 -100.68152,100.68152 v 401.82121 c 0,55.61916 45.06237,100.68153 100.68152,100.68153 h 68.16663 c 12.54747,0 22.74232,10.18915 22.74232,22.74232 v 80.83477 c 0,1.14616 0.0603,2.232 0.2413,3.31784 30.22256,-6.21341 59.78154,-14.29689 88.49598,-24.12978 l 104.84391,-78.30114 c 3.92109,-2.9559 8.68672,-4.52434 13.63333,-4.52434 h 49.40573 C 704.03927,823.35939 757.54707,775.28079 803.15236,720.44586 H 398.49589 c -26.60308,0 -48.19924,-21.59615 -48.19924,-48.19924 0,-26.60309 21.59616,-48.19924 48.19924,-48.19924 h 415.15292 c 18.15766,0 33.90235,10.01386 42.1668,24.85367 C 925.43003,540.9806 967.47618,413.63567 972.06084,276.75947 955.48754,265.69706 936.00588,259.79798 916.07974,259.8083 Z M 813.64881,529.69992 H 398.49589 c -26.60308,0 -48.19924,-21.59615 -48.19924,-48.19924 0,-26.60308 21.59618,-48.19924 48.19924,-48.19924 h 415.15292 c 26.60309,0 48.19924,21.59616 48.19924,48.19924 -0.0603,26.66341 -21.59616,48.19924 -48.19924,48.19924 z" fill="#fca315"></path><path d="m 218.42739,139.64198 538.63708,-0.30162 c 6.39439,-31.36872 10.79808,-63.461332 13.09041,-96.096864 H 218.42739 C 102.18231,43.243496 7.8950281,137.4703 7.8950281,253.77585 v 301.381 c 0,50.67671 39.3918709,92.29642 89.2198729,95.85556 28.171519,1.99071 54.412659,-18.15766 55.196879,-46.32918 0.66357,-21.71681 -13.03008,-40.23642 -32.27358,-46.87211 -9.53127,-3.25752 -15.74469,-12.48716 -15.74469,-22.56134 V 253.77585 c 0,-62.92359 51.21547,-114.13387 114.13388,-114.13387 z" fill="#fcb138"></path><path d="M 196.22799,360.48982 V 707.7174 c 55.19687,-12.06489 108.0411,-30.3432 157.80878,-54.05071 7.50835,-17.91252 25.03662,-29.56633 44.45912,-29.55899 h 11.16003 c 45.72594,-26.84438 88.315,-58.57505 126.98298,-94.34745 H 398.49589 c -26.60308,0 -48.19924,-21.59616 -48.19924,-48.19924 0,-26.60309 21.59616,-48.19924 48.19924,-48.19924 h 225.4325 c 39.87447,-52.72358 72.81162,-110.99701 97.424,-173.49315 H 296.90951 c -55.61915,-0.0603 -100.68152,45.00205 -100.68152,100.6212 z" fill="#fcb138"></path><path d="M 518.42092,43.30382 H 218.42739 c -116.24468,0 -210.5323619,94.20222 -210.5323619,210.53236 V 449.16677 C 40.62411,442.20718 72.833548,432.99584 104.29351,421.5985 V 253.83618 c 0,-62.91841 51.21547,-114.13388 114.13388,-114.13388 l 245.58086,-0.12064 c 20.45,-30.5845 38.66798,-62.737441 54.41267,-96.27784 z" fill="#f9c776"></path>';
            zib_svgs['wallet-color'] = '<path d="m 680.14953,699.80571 c -102.77395,0 -186.36599,-86.21462 -186.36599,-192.21295 0,-105.99832 83.59204,-192.21294 186.36599,-192.21294 H 1020.0991 V 197.67007 c 0,-80.98749 -63.64062,-146.624402 -142.16425,-146.624402 H 149.15081 c -78.523917,0 -142.1642132,65.634642 -142.1642132,146.624402 v 627.32218 c 0,80.98748 63.6402962,146.6244 142.1642132,146.6244 h 728.78404 c 78.52473,0 142.16425,-65.63692 142.16425,-146.6244 V 699.87188 H 680.14953 Z" fill="#fc7032" /><path d="m 680.14953,388.03036 c -63.89691,0 -115.92542,53.66082 -115.92542,119.5624 0,65.90159 52.05748,117.63857 115.92542,119.56241 H 1020.0991 V 388.03036 Z m 4.68321,163.62912 c -23.6085,0 -42.72625,-19.71754 -42.72625,-44.06672 0,-24.34917 19.11775,-44.06672 42.72625,-44.06672 23.6085,0 42.72625,19.71755 42.72625,44.06672 0,24.34918 -19.11775,44.06672 -42.72625,44.06672 z" fill="#fc7032" /><path d="M 1013.812,388.03036 H 680.14953 c -63.89662,0 -115.92542,53.66082 -115.92542,119.5624 0,65.90159 52.02851,119.56241 115.92542,119.56241 H 910.97391 C 957.03614,554.70313 992.19227,474.17881 1013.812,388.03036 Z M 684.83274,551.65948 c -23.6085,0 -42.72625,-19.71754 -42.72625,-44.06672 0,-24.34917 19.11775,-44.06672 42.72625,-44.06672 23.6085,0 42.72625,19.71755 42.72625,44.06672 0,24.34918 -19.11775,44.06672 -42.72625,44.06672 z" fill="#ff7e3e" /><path d="m 680.14953,699.80571 c -102.77395,0 -186.36599,-86.21462 -186.36599,-192.21295 0,-105.99832 83.59204,-192.21294 186.36599,-192.21294 H 1020.0991 V 197.67007 c 0,-80.98749 -63.64062,-146.624402 -142.16425,-146.624402 H 149.15081 c -78.523917,0 -142.1642132,65.636912 -142.1642132,146.624402 v 627.32218 c 0,80.98965 63.6402962,146.6244 142.1642132,146.6244 H 431.81124 C 602.07469,931.38757 751.10333,833.92469 858.9454,699.87188 H 680.14953 Z" fill="#ff7e3e" /><path d="m 149.15081,51.045668 c -78.523917,0 -142.1642132,65.636912 -142.1642132,146.624402 v 506.89961 c 11.7400952,0.52933 23.6084972,0.86016 35.4768992,0.86016 170.455914,0 328.209434,-56.30748 456.708944,-151.7192 -3.52845,-14.75507 -5.45305,-30.17181 -5.45305,-46.05171 0,-105.99832 83.82892,-192.21294 186.36599,-192.21294 H 712.3546 C 759.31498,235.38483 793.05973,146.19273 810.70195,51.111834 H 149.15081 Z" fill="#ff9552" /><path d="m 564.67319,499.32198 c 36.05428,-33.34778 69.09334,-70.13622 98.66812,-109.83596 -53.37574,8.00611 -94.94722,53.59465 -98.66812,109.83596 z" fill="#ff9552" /><path d="M 502.76504,51.045668 H 149.15081 C 70.626893,51.045668 6.9865968,116.65998 6.9865968,197.67007 V 402.6531 C 214.26663,357.85855 391.39452,228.43737 502.76504,51.045668 Z" fill="#ffa56a" />';
            zib_svgs['book-color'] = '<path d="M 166.74332,30.412781 V 709.22842 c 0,0 253.18864,-29.46445 303.13786,57.06238 0,-146.92229 2.66309,-667.283176 2.66309,-667.283176 0,0 -55.01559,-85.660227 -305.80095,-68.594843 z m 692.27411,0 V 709.22842 c 0,0 -253.18864,-29.46445 -303.13786,57.06238 0,-146.92229 -2.66309,-667.283176 -2.66309,-667.283176 0,0 55.01559,-85.660227 305.80095,-68.594843 z" fill="#3a9ced" /><path d="m 512.4257,996.27351 c -11.62667,0 -23.18839,-3.93304 -32.73655,-11.66579 L 379.20613,903.14718 H 65.480862 c -29.128759,0 -52.742219,-24.2345 -52.742219,-54.12927 V 141.73775 L 118.28803,95.341233 V 794.88865 h 279.36489 c 11.88656,0 23.38325,4.13302 32.67159,11.66579 l 85.0241,68.92815 98.85918,-66.59499 c 8.60292,-5.80122 18.6755,-8.88392 28.96925,-8.866 H 906.69327 V 102.14072 l 105.54943,46.39651 v 705.61363 c 0,29.89477 -23.61353,54.12926 -52.74225,54.12926 H 658.96073 L 541.4599,987.40751 c -8.63556,5.78238 -18.72317,8.86278 -29.0342,8.866 z" fill="#138ee8" /><path d="m 906.62832,462.38031 c 30.78795,-86.86014 47.6109,-180.58643 47.6109,-278.37907 0,-20.79844 -0.77945,-41.46355 -2.27338,-61.86202 L 906.62832,102.20738 Z M 643.11209,800.0216 c -10.26736,0 -20.33044,3.06643 -28.96925,8.866 l -98.85919,66.59499 -85.02409,-68.92815 c -9.30617,-7.5416 -20.81399,-11.65061 -32.6716,-11.66579 H 118.22308 V 95.341233 L 12.67369,141.73775 v 707.28016 c 0,29.89477 23.613496,54.12927 52.742219,54.12927 H 379.20613 l 55.47027,44.99661 c 90.48018,-34.13076 173.2309,-84.6603 244.74468,-148.12219 z" fill="#3a9ced" /><path d="M 118.22308,689.16326 V 95.341233 L 12.67369,141.73775 v 564.02426 c 35.91927,-3.13309 71.189005,-8.73267 105.54939,-16.59875 z M 166.74332,30.412781 V 676.29756 c 113.99335,-34.13076 217.39927,-93.85961 303.9173,-172.65369 0.77944,-191.85224 1.88365,-404.636246 1.88365,-404.636246 0,0 -55.01559,-85.660227 -305.80095,-68.594843 z m 386.53812,68.594843 c 0,0 0.77944,152.255226 1.49392,315.376296 C 641.87797,306.65868 702.41461,175.53521 726.12262,31.479367 587.77173,45.478315 553.28144,99.007624 553.28144,99.007624 Z" fill="#59adf8" /><path d="M 118.22308,325.0573 V 95.341233 L 12.67369,141.73775 v 231.3826 C 49.177541,359.72136 84.447276,343.58924 118.22308,325.0573 Z M 406.55154,55.410902 C 360.69439,37.345593 285.80304,22.280059 166.74332,30.412781 V 296.12614 C 262.39631,234.23391 344.13854,152.1825 406.55154,55.410902 Z" fill="#6bc2fc" />';
            zib_svgs['posts'] = '<path d="M810.666667 256h42.666666a128 128 0 0 1 128 128v363.221333A106.112 106.112 0 0 1 875.221333 853.333333h-53.76a42.666667 42.666667 0 0 0-38.442666 24.277334l-26.026667 54.442666a85.333333 85.333333 0 0 1-155.648-3.584l-20.693333-49.066666a42.666667 42.666667 0 0 0-39.296-26.069334h-113.92a42.666667 42.666667 0 0 1 0-85.333333h113.92a128 128 0 0 1 117.930666 78.250667l20.693334 49.066666 26.026666-54.485333A128 128 0 0 1 821.504 768h53.717333c11.477333 0 20.778667-9.301333 20.778667-20.778667V384a42.666667 42.666667 0 0 0-42.666667-42.666667h-42.666666v255.317334a128.128 128.128 0 0 1-127.872 128.298666h-213.589334c-35.712 0-90.197333 22.485333-115.370666 47.530667l-37.418667 37.205333C272.981333 852.906667 213.333333 829.098667 213.333333 767.232h85.333334v0.682667H213.333333c0-24.277333-19.541333-44.373333-43.605333-44.885334A130.261333 130.261333 0 0 1 42.666667 593.450667V255.658667A127.744 127.744 0 0 1 170.410667 128h512.512A128.085333 128.085333 0 0 1 810.666667 256zM298.666667 767.914667H213.333333v-0.682667h85.333334v0.682667z m-10.24-50.688l5.248-5.248c41.130667-40.96 117.290667-72.362667 175.530666-72.362667h213.589334c23.381333 0 42.538667-19.2 42.538666-42.965333V256.298667C725.333333 232.576 706.218667 213.333333 682.922667 213.333333H170.410667A42.410667 42.410667 0 0 0 128 255.658667v337.792c0 23.68 19.669333 43.733333 43.605333 44.288A130.133333 130.133333 0 0 1 288.426667 717.226667z"></path><path d="M256 384h341.333333a42.666667 42.666667 0 0 0 0-85.333333H256a42.666667 42.666667 0 1 0 0 85.333333zM256 554.666667h256a42.666667 42.666667 0 0 0 0-85.333334H256a42.666667 42.666667 0 1 0 0 85.333334z"></path>';
            zib_svgs['points-color'] = '<path d="M716.032 626.2784c-58.6752-0.1024-114.5344-10.496-164.2496-42.0352-61.0304-38.7072-60.9792-95.9488-0.3584-134.5024 90.5216-57.4976 245.76-56.4224 335.5648 2.304 55.296 36.1984 54.4256 95.5392-1.9456 130.7136-51.3536 32.0512-108.4416 43.8784-169.0112 43.52z" fill="#FF8E12"></path><path d="M118.9376 643.8912c92.3648 96.9216 208.0768 117.2992 331.1104 122.5216-3.9424 54.6304 6.7072 99.1744 50.1248 132.352l-1.0752 7.8336c-26.4704 0-44.032 0.8192-70.4-0.512-88.6784-4.4032-173.7216-21.8112-248.1152-71.1168-48.128-31.8976-82.1248-72.9088-77.2608-132.7104 1.4848-17.8688 9.2672-35.3792 15.616-58.368z" fill="#FCA315"></path><path d="M517.7344 611.5328c91.5968 97.9968 316.3136 89.1392 396.7488 1.8432 21.0944 25.5488 18.944 59.648-6.8608 87.9104-34.048 37.2224-80.2304 52.0704-129.3312 59.7504-82.3808 12.8512-161.1776 5.1712-230.9632-42.9568-41.6256-28.7232-51.5584-67.84-29.5936-106.5472z" fill="#FF8E12"></path><path d="M517.376 749.7728c88.7808 97.792 312.6784 94.1056 397.3632 3.1744 20.6848 26.88 18.2272 60.7232-7.2192 88.3712-37.5296 40.7552-88.4736 55.04-141.8752 61.8496-77.9776 9.9328-152.6784 1.024-218.0608-45.0048-41.728-29.3888-52.0704-67.5328-30.208-108.3904z" fill="#FF8E12"></path><path d="M795.648 285.2864l-0.0512-0.0512c7.8336-43.6736-15.2064-90.2144-62.6688-122.0608-85.0944-57.1392-182.3232-72.704-297.4208-75.1104-18.7904 1.8432-51.3024 4.2496-83.6096 8.2944-66.6112 8.2944-128.7168 28.8768-183.7568 66.1504-83.456 56.576-88.1664 138.3936-10.1376 201.1648 23.2448 18.688 50.9952 33.3824 78.848 45.4656 59.392 25.7024 123.2384 33.6384 187.904 37.7856 1.4336 0.1024 2.8672 0.1536 4.2496 0.2048h0.0512c2.9696 0.1536 5.888 0.2048 8.704 0.1536 18.0224 0.256 36.4544-0.1024 43.008-1.2288 4.0448-8.0896 20.8384-25.1904 28.16-32.4608 58.4192-47.9232 132.5056-60.2624 207.7696-57.6 0 0 24.4224 0.7168 39.3216 2.5088 23.9616-15.9232 34.6624-52.0704 38.144-66.7648 0.1536-0.7168 0.3584-1.4336 0.512-2.1504 0.6656-2.6112 0.9728-4.3008 0.9728-4.3008zM472.8832 576.0512c-7.3728-11.3152-15.9232-38.144-15.9232-38.144l-30.3616-0.7168c-114.2272-6.3488-220.1088-32.768-302.7456-117.504-33.7408 49.0496-27.0336 107.1616 17.3568 152.4224 58.624 59.7504 135.7824 83.7632 216.9856 97.7408 10.7008 1.8432 21.4528 3.0208 32.0512 3.84 25.088 2.816 55.1936 5.0176 66.3552 4.352-7.3216-40.0896 3.5328-80.384 16.2816-101.9904zM517.376 749.7728c-21.8624 40.8576-11.52 79.0016 30.208 108.3904 11.008 7.7312 22.272 14.336 33.7408 20.0704 26.0608-18.5856 50.5344-39.1168 73.3696-61.44-54.784-9.3696-105.0112-31.4368-137.3184-67.0208zM761.0368 679.2704c-89.5488 10.496-189.44-10.0864-243.3024-67.7376-21.9648 38.7584-12.032 77.8752 29.5424 106.5472 47.616 32.8704 99.4816 46.848 153.8048 48.3328 22.3744-27.2384 42.4448-56.3712 59.9552-87.1424zM551.4752 449.7408c-60.672 38.5536-60.672 95.8464 0.3584 134.5024 49.7152 31.488 105.5744 41.9328 164.2496 42.0352 25.6512 0.1536 50.6368-1.8944 74.8544-6.7584 25.8048-59.4432 42.5984-123.648 48.64-191.0272-90.3168-33.8432-212.0192-27.0848-288.1024 21.248z" fill="#FCA315"></path><path d="M118.9376 643.8912c-6.3488 22.9888-14.1312 40.4992-15.5648 58.4192-2.0992 25.5488 2.9696 47.6672 13.1584 67.1232 50.688-5.3248 99.584-16.6912 145.8688-33.4336-51.8656-18.1248-100.2496-46.6944-143.4624-92.1088zM426.5984 537.1392c-114.2272-6.3488-220.1088-32.768-302.7456-117.504-33.7408 49.0496-27.0336 107.1616 17.3568 152.4224 58.624 59.7504 135.7824 83.7632 216.9856 97.7408 9.984 1.7408 20.0704 2.816 30.0032 3.6352 24.1152-15.616 47.0528-32.8192 68.7104-51.5072 3.328-18.5856 9.3696-34.7648 16.0256-45.9776-7.3728-11.3152-15.9232-38.144-15.9232-38.144l-30.4128-0.6656zM351.8976 96.3584c-66.6112 8.2944-128.7168 28.8768-183.7568 66.1504-83.456 56.576-88.1664 138.3936-10.1376 201.1648 23.2448 18.688 50.9952 33.3824 78.848 45.4656 59.392 25.7024 123.2384 33.6384 187.904 37.7856 1.4336 0.1024 2.8672 0.1536 4.2496 0.2048h0.0512c2.9696 0.1536 5.888 0.2048 8.704 0.1536 18.0224 0.256 36.4544-0.1024 43.008-1.2288 4.0448-8.0896 20.8384-25.1904 28.16-32.4608 37.3248-30.6176 81.1008-46.6432 127.4368-53.6064 23.1424-65.0752 35.7888-135.168 35.7888-208.2304 0-7.3216-0.1536-14.6432-0.4096-21.9136-69.9392-30.3104-147.8656-39.9872-236.288-41.8816-18.7392 1.9456-51.2512 4.352-83.5584 8.3968z" fill="#FFBC42" p-id="7872"></path><path d="M123.8528 419.6864c-20.8896 30.3104-26.2144 64.1536-16.7936 96.256 30.5152-11.1104 59.904-24.5248 88.0128-40.0384a352.2816 352.2816 0 0 1-71.2192-56.2176zM435.5072 88.064c-18.7904 1.8432-51.3024 4.2496-83.6096 8.2944-66.6112 8.2944-128.7168 28.8768-183.7568 66.1504-83.456 56.576-88.1664 138.3936-10.1376 201.1648 23.2448 18.688 50.9952 33.3824 78.848 45.4656 12.544 5.4272 25.2928 10.0352 38.2464 14.0288 106.2912-82.3808 185.088-198.5024 220.3648-332.3392-19.456-1.4336-39.424-2.3552-59.9552-2.7648z" fill="#FFC65E"></path>';
            zib_svgs['money-color-2'] = '<path d="M 783.74365,87.860049 H 243.43248 c -75.7128,0 -137.08867,58.224241 -137.08867,130.050721 v 622.10914 c 0,36.60768 41.73278,59.55128 75.18894,41.30437 l 116.63027,-63.58772 c 18.75878,-10.22727 42.31306,-7.91034 58.46086,5.75054 L 480.5399,928.3792 c 19.02016,16.10649 47.74599,16.13027 66.79575,0.0553 L 672.4174,822.87887 c 16.21713,-13.70231 39.89249,-15.9349 58.63571,-5.52937 l 114.18227,63.20067 c 33.45616,18.52338 75.48036,-4.3682 75.48036,-41.13849 V 217.91077 C 920.83231,146.08429 859.45716,87.860049 783.74365,87.860049 Z M 649.91901,548.67753 c 21.94452,0.35445 39.53842,17.33171 39.53842,38.15264 0,20.82093 -17.5939,37.79819 -39.53842,38.15264 h -96.1719 v 45.50669 c -0.37362,20.81792 -18.26964,37.50857 -40.21733,37.50857 -21.9477,0 -39.84372,-16.69065 -40.21734,-37.50857 v -45.50669 h -96.17189 c -21.94453,-0.35445 -39.53842,-17.33171 -39.53842,-38.15264 0,-20.82093 17.59389,-37.79819 39.53842,-38.15264 h 96.17189 v -39.2585 h -96.17189 c -21.94453,-0.35445 -39.53842,-17.33171 -39.53842,-38.15264 0,-20.82093 17.59389,-37.7982 39.53842,-38.15264 h 47.32823 l -68.2529,-84.15697 c -12.35664,-15.26105 -7.46061,-35.88559 10.95776,-46.11492 18.41838,-10.22933 43.42307,-6.1929 55.7797,9.06816 l 91.1593,112.30145 89.81872,-113.51791 c 12.18177,-15.37164 37.06989,-19.68455 55.66312,-9.6211 18.59323,10.06345 23.78069,30.63269 11.6572,46.00434 l -68.07804,86.03695 h 46.80365 c 21.94453,0.35444 39.53842,17.33171 39.53842,38.15264 0,20.82093 -17.59389,37.79819 -39.53842,38.15264 H 553.8054 v 39.2585 z" fill="#4869f0" /><path d="M 783.74365,87.860049 H 243.43248 c -75.71351,0 -137.08867,58.224241 -137.08867,130.050721 v 622.10914 c 0,15.8154 7.81033,29.08447 19.35095,37.5444 17.13609,2.43292 34.44703,4.31291 51.99111,5.52937 1.28229,-0.55294 2.56459,-1.10587 3.84688,-1.7694 l 116.63027,-63.58772 c 18.75878,-10.22727 42.31306,-7.91034 58.46086,5.75054 l 47.09508,39.86674 c 292.77056,-73.43 508.66188,-326.39856 508.66188,-627.25145 0,-24.4951 -1.45715,-48.71373 -4.25488,-72.49001 C 886.44357,118.8798 838.94002,87.860049 783.74365,87.860049 Z M 649.91901,548.67753 c 21.94452,0.35445 39.53842,17.33171 39.53842,38.15264 0,20.82093 -17.5939,37.79819 -39.53842,38.15264 h -96.1719 v 45.50669 c -0.37362,20.81792 -18.26964,37.50857 -40.21733,37.50857 -21.9477,0 -39.84372,-16.69065 -40.21734,-37.50857 v -45.50669 h -96.17189 c -21.94453,-0.35445 -39.53842,-17.33171 -39.53842,-38.15264 0,-20.82093 17.59389,-37.79819 39.53842,-38.15264 h 96.17189 v -39.2585 h -96.17189 c -21.94453,-0.35445 -39.53842,-17.33171 -39.53842,-38.15264 0,-20.82093 17.59389,-37.7982 39.53842,-38.15264 h 47.32823 l -68.2529,-84.15697 c -12.35664,-15.26105 -7.46061,-35.88559 10.95776,-46.11492 18.41838,-10.22933 43.42307,-6.1929 55.7797,9.06816 l 91.1593,112.30145 89.81872,-113.51791 c 12.18177,-15.37164 37.06989,-19.68455 55.66312,-9.6211 18.59323,10.06345 23.78069,30.63269 11.6572,46.00434 l -68.07804,86.03695 h 46.80365 c 21.94453,0.35444 39.53842,17.33171 39.53842,38.15264 0,20.82093 -17.59389,37.79819 -39.53842,38.15264 H 553.8054 v 39.2585 z" fill="#597cf0" /><path d="m 243.43248,87.860049 c 0,72.981341 -137.08867,58.210631 -137.08867,130.050721 v 433.613 c 82.12497,-7.35406 159.99506,-28.42095 231.10398,-60.82304 -0.11658,-1.27176 -0.40801,-2.54351 -0.40801,-3.87056 0,-21.06689 18.01038,-38.15264 40.21734,-38.15264 h 38.46876 c 19.58409,-12.1646 38.52704,-25.26921 56.65398,-39.2585 h -95.18103 c -21.94452,-0.35445 -39.53842,-17.33171 -39.53842,-38.15264 0,-20.82093 17.5939,-37.7982 39.53842,-38.15264 h 47.32823 l -68.31118,-84.15697 c -12.35664,-15.26105 -7.46061,-35.88559 10.95776,-46.11492 18.41838,-10.22933 43.42307,-6.1929 55.7797,9.06816 l 91.1593,112.30145 89.81872,-113.51791 c 10.60805,-13.38107 30.89157,-18.3575 48.20251,-12.77284 C 686.52261,233.33771 709.89529,162.6171 719.8622,87.860049 H 243.43248 Z" fill="#6994f0" /><path d="M 106.34381,217.91077 V 384.84238 C 261.67599,330.4334 390.48804,223.99308 469.29071,87.860049 H 243.43248 c -75.70889,0 -137.08867,58.130701 -137.08867,130.050721 z" fill="#7a9bf0" />';
            zib_svgs['merchant-color'] = '<path d="m 208.11748,161.67385 h 605.24097 c 29.0295,0 52.52654,-23.91392 52.52654,-53.462 0,-29.548082 -23.49748,-53.461996 -52.52654,-53.461996 H 208.11748 c -29.03106,0 -52.52655,23.913914 -52.52655,53.461996 -0.0615,29.54808 23.49549,53.462 52.52655,53.462 z" fill="#1fbd45" /><path d="M 998.79255,404.88211 914.34414,217.1391 c -0.41844,-0.8985 -1.29907,-1.47989 -2.27575,-1.50244 H 111.93044 c -0.98411,0 -1.90671,0.62602 -2.27575,1.50244 L 29.204201,406.57236 c -14.700052,34.55623 -12.424312,74.74663 7.995843,106.11017 23.495481,36.05867 63.782226,59.84739 109.481556,59.84739 54.0027,0 100.31709,-33.3042 120.42971,-80.75642 0.83549,-2.07014 3.716,-2.07014 4.55148,0 20.11262,47.45222 66.42702,80.75642 120.42972,80.75642 54.0027,0 100.31708,-33.3042 120.4297,-80.75642 0.83549,-2.07014 3.716,-2.07014 4.55149,0 20.11262,47.45222 66.3655,80.75642 120.42971,80.75642 54.06421,0 100.31709,-33.3042 120.42971,-80.75642 0.83549,-2.07014 3.71599,-2.07014 4.55148,0 20.11262,47.45222 66.42702,80.75642 120.42972,80.75642 42.87002,0 80.94253,-20.90903 104.86857,-53.2742 24.23351,-32.80338 27.80101,-77.00029 11.00966,-114.37361 z M 760.14736,594.19016 c -34.0746,27.98304 -77.06764,44.07172 -122.70546,44.07172 -45.63781,0 -88.63085,-16.08868 -122.70545,-44.07172 -34.74237,28.54811 -78.05397,44.10419 -122.70546,44.07172 -45.63781,0 -88.63085,-16.08868 -122.70544,-44.07172 -34.74238,28.54811 -78.05398,44.10419 -122.70546,44.07172 -12.30129,0 -24.47958,-1.18944 -36.35033,-3.4431 v 271.81731 c 0,39.005 31.06077,70.61491 69.37932,70.61491 h 660.76424 c 38.31972,0 69.37933,-31.6139 69.37933,-70.61491 V 636.19602 c -8.91844,1.25203 -17.89839,2.00326 -26.93984,2.00326 -45.63782,0.0626 -88.63086,-16.08868 -122.70545,-44.00912 z" fill="#1cac3f" /><path d="M 912.06839,215.63666 H 111.93044 c -0.98407,0 -1.90671,0.62602 -2.27575,1.50244 L 29.204201,406.57236 c -14.700052,34.55623 -12.424312,74.74663 7.995843,106.11017 23.495481,36.05867 63.782226,59.84739 109.481556,59.84739 54.0027,0 100.31709,-33.3042 120.42971,-80.75642 0.83549,-2.07014 3.716,-2.07014 4.55148,0 20.11262,47.45222 66.42702,80.75642 120.42972,80.75642 54.0027,0 100.31708,-33.3042 120.4297,-80.75642 0.83549,-2.07014 3.716,-2.07014 4.55149,0 20.11262,47.45222 66.3655,80.75642 120.42971,80.75642 54.0027,0 100.31709,-33.3042 120.42971,-80.75642 0.83549,-2.07014 3.71599,-2.07014 4.55148,0 17.89839,42.19366 56.40146,73.11899 102.65434,79.50438 43.30057,-93.5898 67.59563,-198.07232 67.59563,-308.37681 0,-1.69025 -0.0615,-3.4431 -0.0615,-5.13335 L 914.40564,217.2017 c -0.4321,-0.92384 -1.33267,-1.52687 -2.33725,-1.56504 z m -151.92103,378.5535 c -34.0746,27.98304 -77.06764,44.07172 -122.70546,44.07172 -45.63781,0 -88.63085,-16.08868 -122.70545,-44.07172 -34.74237,28.54811 -78.05397,44.10419 -122.70546,44.07172 -45.63781,0 -88.63085,-16.08868 -122.70544,-44.07172 -34.74238,28.54811 -78.05398,44.10419 -122.70546,44.07172 -12.30129,0 -24.47958,-1.18944 -36.35033,-3.4431 v 271.81731 c 0,39.11122 31.04267,70.61491 69.37932,70.61491 h 159.79387 c 210.29069,-35.93347 389.27459,-165.64455 494.02014,-345.43711 -26.87833,-7.19922 -51.84997,-20.0326 -73.31573,-37.62373 z" fill="#1fbd45" /><path d="M 736.28284,54.749854 H 208.11748 c -29.02736,0 -52.52655,23.913914 -52.52655,53.461996 0,29.54808 23.49549,53.462 52.52655,53.462 h 513.21928 c 7.58856,-35.21326 12.58446,-70.953852 14.94608,-106.923996 z M 707.4978,215.63666 H 111.93044 c -0.98411,0 -1.90671,0.62602 -2.27575,1.50244 L 29.204201,406.57236 c -14.700052,34.55623 -12.424312,74.74663 7.995843,106.11017 23.495481,36.05867 63.782226,59.84739 109.481556,59.84739 54.0027,0 100.31709,-33.3042 120.42971,-80.75642 0.83549,-2.07014 3.716,-2.07014 4.55148,0 20.11262,47.45222 66.42702,80.75642 120.42972,80.75642 54.0027,0 100.31708,-33.3042 120.4297,-80.75642 0.83549,-2.07014 3.716,-2.07014 4.55149,0 3.69038,8.76427 8.36488,17.02771 13.71594,24.72774 C 611.8552,433.49116 673.30019,330.63629 707.4978,215.63666 Z M 374.56315,637.38545 c -38.49301,-3.50413 -75.09777,-18.5593 -105.1761,-43.25789 -34.74238,28.5481 -78.05397,44.10419 -122.70545,44.07172 -12.3013,0 -24.47958,-1.18944 -36.35034,-3.44311 v 90.2093 c 95.02753,-11.39354 184.39647,-41.88065 264.23189,-87.58002 z" fill="#39ca66" /><path d="M 492.59411,54.749854 H 208.11748 c -29.01779,0 -52.52655,23.913914 -52.52655,53.461996 0,29.54808 23.49549,53.462 52.52655,53.462 H 432.31775 C 455.25968,127.99404 475.4338,92.248374 492.59411,54.749854 Z M 391.66196,215.63666 H 111.93044 c -0.98364,0 -1.90671,0.62602 -2.27575,1.50244 L 29.204201,406.57236 c -6.212157,14.52363 -9.164468,30.1115 -9.225975,45.57416 C 167.40929,414.648 296.69593,330.38588 391.66196,215.63666 Z" fill="#4ed886" />';
            zib_svgs['medal-color'] = '<path d="M 512.03261,779.34977 C 300.22792,780.73628 128.67101,612.48577 127.81597,402.45898 126.96094,192.19105 295.64737,23.639121 508.49031,22.071757 720.23393,20.504393 892.76802,188.45349 894.60024,397.75688 896.43246,607.78368 725.85274,777.90297 512.03261,779.34977 Z M 756.38974,340.54809 c -2.13759,-31.34728 -20.58194,-48.1663 -47.6988,-55.40029 -18.13898,-4.82266 -37.07193,-8.74107 -55.76058,-9.28362 -32.79674,-1.02481 -55.76058,-12.17721 -65.22705,-45.63441 -3.66444,-13.08146 -11.84836,-24.89698 -18.07791,-37.31532 -11.72621,-23.45018 -29.31552,-38.94297 -56.98205,-40.20892 -29.43768,-1.38651 -47.63774,14.58854 -59.91361,38.8224 -10.32151,20.31545 -18.93295,41.59544 -30.84238,61.00664 -4.947,8.13824 -15.57388,15.61336 -24.9182,17.78355 -23.14705,5.36521 -47.08807,6.99286 -70.60156,10.91127 -26.07861,4.40067 -45.62229,17.18072 -54.47802,43.34365 -8.79466,25.74094 1.09933,46.05639 18.13898,64.26192 10.01614,10.73042 19.9712,22.00339 31.88063,30.50332 27.05579,19.4112 37.31623,42.62025 25.28465,74.99235 -4.7027,12.71976 -4.27518,27.18774 -7.14566,40.69118 -5.55774,26.28349 0.79396,49.37197 22.16987,65.4676 22.41416,16.8793 47.45451,15.31194 72.18948,2.71274 25.52894,-13.02118 51.2411,-35.68767 76.83111,-35.62739 25.59002,0.0603 51.30218,22.78706 76.77004,35.86852 23.69672,12.11694 47.27129,14.16657 69.86868,-1.80849 23.51349,-16.63818 28.70478,-40.51034 24.24638,-67.15553 -3.60337,-21.5814 -9.28325,-42.98194 -11.17654,-64.74419 -0.85504,-9.64532 2.87048,-22.12395 9.1611,-29.41822 15.39065,-17.90412 34.81219,-32.43238 50.08069,-50.39679 11.0544,-13.02118 26.20075,-24.83669 26.20075,-49.37197 z" fill="#718ff2" /><path d="m 406.49671,840.47697 c -4.15304,9.76588 -6.16848,16.03534 -9.34433,21.76225 -24.24638,43.46421 -48.55384,86.92842 -73.22774,130.1515 -13.68058,23.99278 -25.22357,25.31898 -44.33974,5.12408 -25.77323,-27.18774 -49.77532,-56.18398 -77.19755,-81.6235 -13.74166,-12.71977 -32.36923,-22.90763 -50.56929,-27.79058 -35.484,-9.52475 -72.311635,-13.86514 -108.345305,-21.46083 -25.590012,-5.36521 -30.41486,-16.33675 -17.589316,-38.88268 26.750419,-46.84008 54.172652,-93.31845 81.411661,-139.85711 19.0551,-32.49267 28.27727,-34.12031 54.41695,-7.65597 50.87466,51.48188 107.79564,94.34326 174.85491,123.21893 16.12354,6.93257 33.28534,11.57438 49.04243,19.10979 8.0007,3.91841 14.04703,11.93608 20.88732,17.90412 z m 599.19719,8.2588 c -8.85575,5.90776 -17.22289,15.19138 -27.30011,17.54242 -38.23233,8.74107 -77.3197,13.98571 -115.49096,23.20905 -14.41347,3.49643 -29.3766,11.81551 -40.00348,22.06366 -28.64372,27.73029 -54.84447,57.87191 -82.44992,86.6873 -18.13899,18.9289 -30.17057,18.0247 -42.87396,-4.3404 -25.46787,-44.60959 -49.95855,-89.70145 -74.69352,-134.67275 -10.32151,-18.74808 -4.88593,-31.22671 15.75709,-37.91815 88.80162,-28.63454 162.27366,-80.41784 226.46245,-146.30741 18.20006,-18.62752 30.10949,-17.18073 43.30148,4.76237 29.43768,49.01027 58.38676,98.26168 87.39692,147.51308 2.93155,4.94322 4.82481,10.429 9.89401,21.46083 z" fill="#6282ea" /><path d="m 510.93327,222.03125 c 13.06984,26.46434 24.18531,47.62376 34.07931,69.44629 12.09265,26.64519 33.10211,39.42523 61.68475,42.62025 23.20813,2.59218 46.35518,6.14889 73.16667,9.76588 -17.52824,17.66299 -32.24708,34.12031 -48.73706,48.70886 -24.6739,21.88281 -35.78938,46.7195 -27.11687,79.87528 5.55774,21.40055 7.57318,43.76563 12.15373,71.49592 -24.91819,-13.44316 -45.56121,-23.63103 -65.22705,-35.38626 -26.56719,-15.79421 -52.1572,-16.57789 -79.09085,-0.54255 -19.91013,11.8758 -41.10281,21.76225 -66.14316,34.84371 4.33626,-27.00689 7.08459,-50.09537 11.90944,-72.82215 6.29062,-29.77992 -0.30537,-53.77264 -24.55176,-74.14838 -17.65039,-14.82967 -32.55245,-32.79408 -51.05787,-51.7833 25.28464,-3.49642 48.67599,-7.65597 72.25056,-9.82616 29.01015,-2.65247 49.46995,-15.07081 61.31831,-42.25855 9.64969,-22.54593 21.92557,-43.82591 35.36185,-69.98884 z" fill="#849ff8" /><path d="m 385.54832,822.63313 c -15.7571,-7.5354 -32.9189,-12.17721 -49.04244,-19.10979 -67.05927,-28.87567 -123.98025,-71.79733 -174.8549,-123.21893 -26.13968,-26.46434 -35.36186,-24.83669 -54.41695,7.65597 -23.452424,40.02807 -46.96592,80.11642 -70.112972,120.32534 92.962082,47.68912 196.205152,72.54532 300.972752,72.46045 16.79535,0 33.34641,-0.84397 49.8364,-2.04963 l 9.1611,-16.45732 c 3.17585,-5.66663 5.19129,-11.99637 9.34432,-21.76225 -6.77921,-5.96804 -12.82554,-13.98571 -20.88731,-17.84384 z" fill="#708ef2" /><path d="m 631.12694,392.51224 c 16.42891,-14.58854 31.20882,-31.04586 48.73706,-48.70885 -26.81149,-3.617 -49.95854,-7.23399 -73.16667,-9.76589 -28.64371,-3.19501 -49.5921,-15.97505 -61.68475,-42.62024 -9.894,-21.76225 -21.00947,-42.98195 -34.07931,-69.44629 -13.43628,26.16292 -25.71216,47.50319 -35.484,69.86827 -11.84836,27.24802 -32.24708,39.66637 -61.31831,42.25855 -23.57457,2.17019 -46.96592,6.32974 -72.25056,9.82616 18.5665,19.04951 33.46856,37.01391 51.05788,51.7833 24.18531,20.37574 30.84237,44.36847 24.55175,74.14838 -4.76377,22.72678 -7.57318,45.81526 -11.90943,72.82215 25.10142,-13.08146 46.23303,-22.96791 66.14316,-34.84371 26.93364,-16.03534 52.52365,-15.25166 79.09085,0.54255 5.43558,3.2553 11.05439,6.39002 16.6732,9.52475 13.49736,-10.67013 26.5672,-21.88281 39.20952,-33.51748 -0.85503,-4.03897 -1.71007,-8.07795 -2.74833,-12.05664 -8.61144,-33.0955 2.50404,-57.93219 27.17794,-79.81501 z M 474.71638,579.39027 c -1.28255,0.7234 -2.50403,1.38652 -3.78659,2.10992 1.28256,-0.66312 2.50404,-1.38652 3.78659,-2.10992 z" fill="#839ef8" /><path d="M 508.49031,22.011474 C 295.64737,23.578838 126.96094,192.13077 127.81597,402.39869 c 0.42752,97.89998 37.92697,186.75747 99.30635,253.55129 61.92905,-6.32974 121.23192,-21.27998 176.80928,-43.40393 -14.41347,1.32623 -28.52157,-2.04963 -41.71355,-11.99636 -21.37591,-16.09562 -27.72761,-39.1841 -22.16987,-65.46759 2.87048,-13.50345 2.44296,-27.97143 7.14566,-40.69119 12.09265,-32.3721 1.83222,-55.58114 -25.28465,-74.99234 -11.84835,-8.49994 -21.80342,-19.77291 -31.88063,-30.50332 -17.03965,-18.20554 -26.93364,-38.52099 -18.13898,-64.26193 8.9168,-26.16293 28.39941,-38.94297 54.47802,-43.34365 23.51349,-3.91841 47.45451,-5.60634 70.60156,-10.91126 9.34432,-2.1702 19.9712,-9.7056 24.9182,-17.78356 11.84836,-19.35092 20.52087,-40.6309 30.84238,-61.00663 12.33695,-24.29415 30.53701,-40.20892 59.91361,-38.82241 27.66653,1.26595 45.25584,16.75874 56.98205,40.20892 6.16848,12.35806 14.41347,24.23386 18.07791,37.31532 9.4054,33.4572 32.36923,44.54932 65.22705,45.63441 18.68865,0.60284 37.6216,4.46096 55.76058,9.28362 14.16917,3.79785 25.83431,10.24815 34.20145,19.95375 24.9182,-48.46772 43.79007,-100.43187 55.6995,-154.9882 C 727.80711,70.840895 623.98128,21.167509 508.49031,22.011474 Z" fill="#849ff8" /><path d="m 271.88958,324.63332 c 8.9168,-26.16293 28.39941,-38.94297 54.47802,-43.34365 23.51349,-3.91841 47.45451,-5.60634 70.60156,-10.91126 9.34432,-2.1702 19.9712,-9.7056 24.9182,-17.78356 11.84836,-19.35092 20.52087,-40.6309 30.84238,-61.00663 12.33695,-24.29415 30.53701,-40.20892 59.91361,-38.82241 6.35169,0.30142 12.15373,1.4468 17.46717,3.13473 C 557.47167,117.50012 580.6798,76.085537 599.12415,32.139058 569.40691,25.228299 538.95928,21.848558 508.42924,22.071757 295.58629,23.639121 126.89986,192.19105 127.7549,402.45898 c 0,5.0035 0.24429,10.00701 0.42752,14.95024 51.48539,-10.54957 100.71105,-27.06717 147.00515,-48.76914 -6.77921,-13.02118 -8.97788,-27.36859 -3.29799,-44.00676 z" fill="#97aef8" />';
            zib_svgs['dingtalk'] = '<path d="M879.36 393.813a174.933 174.933 0 0 1-11.307 29.014v1.28c-32.853 70.186-118.4 208-118.4 208l-24.96 42.666h120.534l-231.04 306.56 52.266-208.64H571.52l32.853-138.026c-26.666 6.4-58.24 15.36-95.573 27.306 0 0-50.56 29.654-145.493-56.96 0 0-64-56.533-26.88-70.613a1098.24 1098.24 0 0 1 124.586-20.053c64-8.747 104.534-13.44 104.534-13.44s-199.68 2.986-247.04-4.48-106.667-86.614-120.32-156.16c0 0-19.84-38.187 42.666-20.054s320 70.4 320 70.4-335.786-103.04-357.973-128S137.813 124.8 143.36 56.107a15.147 15.147 0 0 1 20.053-13.44S411.52 156.16 581.333 218.453s317.227 94.72 298.027 175.36z"></path>';
            zib_svgs['huawei'] = '<path d="M436.8 136s-81.6-3.2-136 62.4-12.8 169.6 12.8 224c25.6 52.8 153.6 260.8 160 267.2 6.4 3.2 9.6 3.2 9.6 0s16-302.4 3.2-377.6c-9.6-75.2-43.2-166.4-49.6-176zM152 273.6c-9.6 0-75.2 68.8-81.6 132.8-6.4 65.6 22.4 110.4 100.8 160 78.4 56 264 156.8 270.4 152 3.2-9.6-72-145.6-136-243.2-60.8-97.6-144-201.6-153.6-201.6z m25.6 604.8c56 25.6 145.6-32 169.6-48 22.4-19.2 65.6-51.2 65.6-51.2l-320 11.2s28.8 64 84.8 88z m9.6-257.6C131.2 592 11.2 526.4 8 526.4S-14.4 608 24 672s110.4 81.6 142.4 84.8c38.4 6.4 256 3.2 256 0-8-3.2-177.6-107.2-235.2-136zM720 198.4c-52.8-65.6-136-62.4-136-62.4-6.4 9.6-41.6 100.8-51.2 176-12.8 72 3.2 371.2 3.2 377.6 0 3.2 6.4 6.4 9.6 0 6.4-3.2 136-214.4 160-267.2 27.2-54.4 64-155.2 14.4-224z m296 328c-3.2 0-123.2 65.6-179.2 94.4-56 28.8-230.4 132.8-230.4 136 0 3.2 217.6 6.4 256 0 32-6.4 104-25.6 142.4-84.8 33.6-64 14.4-145.6 11.2-145.6zM672 832c25.6 16 113.6 72 169.6 48 56-25.6 88-88 88-88L608 782.4c1.6-1.6 43.2 30.4 64 49.6z m278.4-422.4c-6.4-65.6-72-132.8-81.6-132.8-9.6 0-91.2 104-152 201.6-62.4 97.6-139.2 233.6-136 243.2 3.2 9.6 192-94.4 270.4-152 76.8-52.8 105.6-97.6 99.2-160z"></path>';
            zib_svgs['xiaomi'] = '<path d="M851.626667 853.333333a13.653333 13.653333 0 0 1-13.653334-13.653333V184.32a13.653333 13.653333 0 0 1 13.653334-13.653333h158.293333a13.653333 13.653333 0 0 1 14.08 13.653333v655.36a13.653333 13.653333 0 0 1-14.08 13.653333z m-265.386667 0s-12.8-3.84-12.8-13.653333v-402.346667A93.013333 93.013333 0 0 0 479.573333 341.333333H183.466667c-17.066667 0-12.8 12.8-12.8 12.8v485.546667c0 11.52-12.8 13.653333-12.8 13.653333H14.08a13.653333 13.653333 0 0 1-14.08-13.653333V184.32A13.653333 13.653333 0 0 1 14.08 170.666667h548.693333a182.613333 182.613333 0 0 1 181.333334 182.186666l0.426666 486.826667a13.653333 13.653333 0 0 1-13.653333 13.653333z m-294.4 0a12.8 12.8 0 0 1-12.8-12.8v-384a12.8 12.8 0 0 1 12.8-12.8h160.853333a12.8 12.8 0 0 1 12.373334 12.8v384a12.8 12.8 0 0 1-12.8 12.8z"></path>';
            zib_svgs['xunlei'] = '<path d="M124.154411 206.710498 261.74916 228.209956 405.364419 365.804705 619.497288 204.990897 993.583529 0.317738 769.990949 423.423404 1154.398608 573.917065 582.518882 726.132869 677.114716 1023.682262 576.498373 930.806028 388.164598 828.470084 171.451693 668.515441 100.074917 523.180582 126.733177 272.068036 0.317738 228.209956 83.735532 223.910318Z"></path>';
            zib_svgs['123pan'] = '<path d="M998.17244445 513.82044445c0 96.36977778 0.45511111 192.73955555-0.11377778 289.10933333-0.45511111 76.11733333-34.36088889 133.91644445-99.66933334 172.71466667-29.12711111 17.29422222-61.21244445 25.03111111-95.00444444 25.14488888-194.78755555 0.11377778-389.57511111 0.56888889-584.47644444-0.11377778-108.99911111-0.34133333-194.44622222-86.24355555-194.78755556-195.47022222-0.56888889-194.56-0.45511111-389.00622222 0-583.56622222 0.22755555-109.68177778 86.69866667-194.90133333 197.29066666-195.12888889 135.168-0.34133333 270.336-0.11377778 405.504-0.11377777 57.11644445 0 114.34666667-0.11377778 171.46311112 0 105.35822222 0.11377778 186.70933333 72.47644445 198.99733333 177.152 0.91022222 8.07822222 0.68266667 16.27022222 0.68266667 24.34844444 0.11377778 95.34577778 0.11377778 190.57777778 0.11377778 285.92355556zM258.27555555 286.94755555v80.4408889h132.096c12.06044445 0 24.00711111 0.68266667 35.72622223 3.5271111 28.10311111 6.59911111 41.52888889 23.89333333 40.96 53.13422223-0.45511111 24.34844445-16.95288889 42.55288889-43.008 47.55911111-19.22844445 3.64088889-38.68444445 1.47911111-58.02666667 2.048-53.02044445 1.59288889-90.112 29.12711111-106.496 79.53066666-5.91644445 18.20444445-8.64711111 37.09155555-8.76088889 56.20622223-0.11377778 40.61866667-0.11377778 81.12355555 0 121.74222222 0 3.072-0.91022222 6.37155555 1.59288889 9.216h309.02044444v-80.32711111H347.24977778c1.13777778-22.528-1.59288889-44.032 2.38933333-65.30844444 3.41333333-18.65955555 14.336-30.03733333 32.42666667-35.04355556 7.85066667-2.16177778 15.81511111-3.41333333 24.00711111-3.41333334 19.456-0.11377778 38.912 0.68266667 58.14044444-0.68266666 42.78044445-3.072 76.11733333-21.16266667 94.208-62.35022222 17.52177778-39.70844445 20.82133333-80.44088889 8.41955556-121.74222222-13.65333333-45.62488889-43.80444445-73.84177778-91.59111111-81.57866667-11.49155555-1.82044445-23.09688889-2.84444445-34.70222223-2.95822223-58.25422222-0.45511111-116.39466667-0.45511111-174.64888888-0.56888888-2.27555555 0-4.66488889 0.34133333-7.62311112 0.56888888z m363.52 373.3048889v79.41688888c1.25155555 0.56888889 1.93422222 1.024 2.50311112 1.024 60.30222222-0.45511111 120.71822222 3.29955555 180.79288888-2.84444444 32.99555555-3.41333333 61.55377778-17.52177778 83.62666667-43.008 34.816-40.16355555 37.66044445-129.82044445-25.48622222-176.58311111-3.18577778-2.38933333-7.168-3.98222222-9.216-8.41955556 19.456-12.40177778 36.18133333-26.73777778 46.76266667-47.104 40.39111111-77.36888889-14.67733333-172.71466667-102.05866667-175.21777777-56.43377778-1.59288889-112.86755555-0.79644445-169.30133333-1.13777778-2.38933333 0-4.77866667 0.34133333-7.28177778 0.56888888V367.50222222c39.02577778 0 77.14133333-0.11377778 115.25688889 0 8.76088889 0 17.74933333 0 26.39644444 1.25155556 28.55822222 4.20977778 42.78044445 23.32444445 41.75644445 55.06844444-0.91022222 28.10311111-15.13244445 42.43911111-44.032 45.51111111-28.55822222 3.072-57.11644445 0.91022222-85.67466667 1.70666667-3.75466667 0.11377778-7.73688889-1.25155555-11.264 1.59288889v77.71022222c4.55111111 2.16177778 8.87466667 1.13777778 12.97066667 1.25155556 28.21688889 0.91022222 56.43377778-1.70666667 84.53688888 1.82044444 18.54577778 2.27555555 33.792 9.67111111 39.936 28.21688889 6.94044445 21.16266667 7.39555555 42.43911111-7.50933333 61.32622222-4.89244445 6.25777778-11.49155555 10.35377778-19.11466667 12.62933333-9.55733333 2.84444445-19.22844445 4.43733333-29.1271111 4.43733334-37.43288889 0.11377778-74.752 0.11377778-112.1848889 0.22755556h-12.288z m-418.816 80.09955555V286.94755555H106.95111111v453.40444445h96.02844444z"></path>';
            zib_svgs['alipan'] = '<path d="M841.984 576.554667a18.816 18.816 0 0 1-13.184-21.973334c41.941333-200.448-75.605333-402.346667-269.226667-456.021333-199.509333-55.125333-405.333333 67.285333-459.52 273.109333v0.981334a460.586667 460.586667 0 0 0 62.464 371.2 439.893333 439.893333 0 0 0 208.768 167.765333c236.544 89.301333 491.178667-44.373333 566.272-283.349333a23.04 23.04 0 0 0-15.573333-29.269334l-80-22.442666z m-393.130667 194.133333c-72.704-20.010667-133.162667-68.266667-170.752-135.125333a298.112 298.112 0 0 1-28.288-219.989334C282.026667 293.12 404.48 220.501333 523.52 253.141333c112.64 31.232 182.4 146.346667 161.92 262.912a21.205333 21.205333 0 0 0 15.104 24.405334l75.605333 20.949333a17.493333 17.493333 0 0 1 11.733334 22.954667c-47.36 142.933333-195.114667 225.834667-338.986667 186.325333z"></path>';
            zib_svgs['quark'] = '<path d="M466.4832 1021.6448c-120.4736-10.6496-235.4176-65.024-317.6448-149.76-82.5344-85.2992-124.416-168.7552-144.4352-288.1024-5.2224-30.9248-5.9904-104.8064-1.28-135.2192 11.1616-75.1616 36.1472-146.432 70.2464-201.216C169.8816 91.6992 331.9296 0 509.952 0c75.9808 0 144.384 13.824 210.2784 42.6496 57.4976 25.2416 120.7296 70.144 163.1232 116.224 66.3552 72.0384 100.4544 133.376 125.44 225.9968 19.7632 73.0624 20.2752 175.7696 1.536 248.32-21.0944 80.384-49.7152 137.7792-101.2224 201.5232-44.7488 55.6544-91.8016 94.8736-153.7536 128.2048-65.0752 35.1232-125.184 52.5312-201.216 58.7776-37.1712 3.072-51.456 3.072-87.6544 0v-0.0512z m91.8528-260.5056c12.8-5.4784 22.6304-20.8384 22.6304-35.6352 0-25.4976 4.9664-54.3744 11.4688-67.072 13.312-26.0608 30.976-35.1232 84.5824-43.4688 20.7872-3.072 42.1376-7.5264 47.36-9.6256 14.848-6.5024 27.0848-18.944 35.1232-36.352 7.2704-15.872 7.5264-17.408 7.5264-58.0096-0.256-45.056-1.792-54.8864-17.408-95.232C726.4256 355.2768 665.6 294.912 605.184 273.1008a427.1104 427.1104 0 0 0-53.8624-13.5168c-28.6208-4.7104-34.048-4.9664-58.7776-2.048-48.896 5.632-79.104 15.3088-112.9472 35.584-21.3504 12.9536-22.8864 14.336-48.64 39.7312-37.7344 37.2224-57.2416 73.3696-69.2224 127.488-20.8384 94.8736 16.896 194.9696 96 255.3344 33.0752 25.1904 81.408 45.5168 116.5824 48.896 30.208 3.072 72.8576 1.28 84.0192-3.4304z"></path>';
            zib_svgs['360yunpan'] = '<path d="m 472.51068,161.14113 c 60.83076,-14.15228 126.70267,-4.36113 180.93361,26.95061 52.84075,29.64424 94.26521,79.41236 114.47191,137.13313 52.99522,2.75064 104.97941,22.06215 147.27448,54.58531 36.91691,28.14778 66.47572,66.12946 84.85692,109.12787 18.1566,42.11478 25.3321,88.98974 20.6561,134.71029 -4.311,45.52101 -20.5297,89.81635 -46.47966,127.19945 -21.44242,31.02669 -49.3302,57.44998 -81.22002,77.16055 -35.69525,22.11916 -76.5861,35.3878 -118.26332,38.76554 -45.22988,4.31837 -90.97933,-7.58208 -130.81702,-29.08841 -44.24694,-24.24272 -81.10768,-60.17212 -112.59027,-99.56475 -20.71223,-25.34013 -39.26196,-52.37625 -58.20488,-79.07033 -30.12049,-41.70145 -60.54992,-83.43143 -95.83794,-120.84304 -18.11441,-18.86969 -37.57689,-36.7275 -59.8478,-50.42372 -21.58284,-12.76982 -45.76349,-21.63459 -70.84284,-23.08831 -49.54085,-2.35158 -98.95531,22.83178 -127.78391,63.60686 -17.67913,24.71303 -27.873758,54.92737 -28.323104,85.498 -0.758274,31.51125 8.63594,63.13653 26.301024,89.06099 26.89079,40.19075 73.51085,65.80167 121.40875,66.34325 39.37431,0.96914 78.80477,-14.6226 107.12787,-42.41407 7.58278,-7.04051 13.28391,-16.44686 22.8326,-21.05027 17.11742,-9.33509 40.27299,-4.70318 52.3914,10.77454 12.21671,14.52283 12.89073,37.46862 1.36209,52.60428 -32.04427,39.30713 -76.97928,67.49766 -125.90227,79.19858 -53.89391,13.2259 -112.35155,6.39918 -161.72388,-19.31151 C 88.021513,805.19081 49.896971,765.44188 27.822651,717.7688 5.1725922,669.39738 -0.51448766,613.05907 12.165606,561.05337 27.710311,495.12344 72.813814,437.48819 131.93144,406.1907 c 34.3191,-18.32811 73.17384,-28.09077 111.97241,-27.44942 52.36332,1.4537 103.11179,22.07641 144.42391,54.30027 44.07843,34.36167 80.32131,77.67362 114.09278,122.15424 14.42133,19.5538 29.37626,38.72279 43.09547,58.78966 30.10646,42.44257 59.59506,86.2676 98.84298,120.70052 24.96701,21.84838 54.86282,38.62304 87.4688,44.87968 20.19266,4.31837 41.21382,2.32309 61.20989,-2.12355 45.932,-9.77691 87.21604,-38.83682 113.37663,-78.25796 25.68317,-38.29523 35.84971,-86.72366 28.39331,-132.3872 -7.24577,-46.34763 -32.84468,-89.26053 -69.59309,-117.65059 -32.05831,-25.15485 -72.54195,-38.89382 -113.03963,-38.56601 -16.76636,0.58432 -33.47657,2.23756 -50.20081,3.54874 -4.31095,-18.51339 -6.89472,-37.45435 -12.62393,-55.58295 -15.23578,-48.07212 -52.78459,-87.93509 -99.12381,-106.13494 -29.67115,-11.57266 -62.57199,-14.93614 -93.82991,-8.75075 -39.92194,7.62484 -76.90906,30.20008 -102.05862,62.60921 -4.90073,6.01436 -8.62191,12.96936 -13.98603,18.59891 -10.77035,11.07384 -27.69119,15.29244 -42.30911,10.68903 -17.08935,-4.83144 -29.83965,-21.67734 -30.20475,-39.66343 -0.50551,-10.21871 3.31396,-20.12387 9.21168,-28.27605 36.15864,-53.68743 92.88907,-92.52423 155.46107,-106.47698 z"></path>';

            $("[class^='zibsvg-']").each(function () {
                var _t = $(this);
                var svgname = _t.attr('class').replace('zibsvg-', '');

                if (_t.attr('is-show') != svgname) {
                    if (zib_svgs[svgname]) {
                        var svg_html = '<svg class="svg-icon" viewBox="0 0 1024 1024">' + zib_svgs[svgname] + '</svg>';
                        _t.html(svg_html).attr('is-show', svgname);
                    } else {
                        _t.remove();
                    }
                }
            });
        }

        //付费下载粘贴链接自动识别地址及提取码
        $('body').on('paste', '.pay-download-group input[data-depend-id="link"]', function (event) {
            var $this = $(this);
            var _val = event.originalEvent.clipboardData.getData('text');
            if (_val) {
                //链接判断
                var urlRegex = '(https?://.*?)[\r\n 提取]';
                var url_matches = _val.match(urlRegex);

                if (url_matches && url_matches[1]) {
                    event.preventDefault();
                    $this.val(url_matches[1]);
                }

                //提取码
                var codeRegex = '[提取码|密码][:|：]( |)([a-zA-Z0-9]{4,6})';
                var code_matches = _val.match(codeRegex);
                if (code_matches && code_matches[2]) {
                    var code = code_matches[2];
                    var parents = $($this.parents('.csf-cloneable-content')[0]);
                    parents.find('textarea[data-depend-id="more"]').val('提取码：' + code);
                    parents.find('input[data-depend-id="copy_key"]').val('提取码');
                    parents.find('input[data-depend-id="copy_val"]').val(code);
                }
            }
        });
        //使用自定义svg图标，需要修改
        //inc/codestar-framework/assets/js/main.js第1025行
        //添加 $modal.trigger('icon.loaded');
        $('#csf-modal-icon').on('icon.loaded', show_svg);
        show_svg();
    });
})(jQuery, window, document);
