<?php
/*
 * @Author        : Qinver
 * @Url           : zibll.com
 * @Date          : 2020-11-11 11:41:45
 * @LastEditTime: 2024-10-11 23:03:24
 * @Email         : 770349780@qq.com
 * @Project       : Zibll子比主题
 * @Description   : 一款极其优雅的Wordpress主题|后台文章编辑配置项，仅在后天引用
 * @Read me       : 感谢您使用子比主题，主题源码有详细的注释，支持二次开发。
 * @Remind        : 使用盗版主题会存在各种未知风险。支持正版，从我做起！
 */

//链接列表模板
function zib_cfs_link_category()
{
    $options_linkcats     = array();
    $options_linkcats[0]  = '全部选择';
    $options_linkcats_obj = get_terms(['taxonomy' => 'link_category'], ['hide_empty' => false]);
    foreach ($options_linkcats_obj as $tag) {
        $options_linkcats[$tag->term_id] = $tag->name;
    }
    return $options_linkcats;
}

//页面模板-配置项
function zib_meta_box_page_templates_meta($post)
{

    $saved_template = (is_object($post) && !empty($post->page_template)) ? $post->page_template : 'default';

    $fields = array();

    //文档导航页面模板
    if ($saved_template === 'pages/documentnav.php') {
        $fields = array_merge($fields, array(
            array(
                'type'    => 'submessage',
                'style'   => 'info',
                'content' => '<b>文档导航页面模板：</b><br>选择一个一级分类（选择的一级分类下必须要有一些子分类），用于此页面的内容显示，系统会自动获取该分类下的二级分类以及文章，适合用作产品文档、帮助文档等页面<br><a target="_blank" href="https://www.zibll.com/%e4%b8%bb%e9%a2%98%e6%96%87%e6%a1%a3">查看演示</a>',
            ),
            array(
                'title'  => ' ',
                'id'     => 'documentnav_options',
                'type'   => 'fieldset',
                'fields' => array(
                    array(
                        'id'          => 'cat',
                        'title'       => '选择分类',
                        'default'     => '',
                        'options'     => 'categories',
                        'placeholder' => '选择分类',
                        'subtitle'    => '请选择一个一级分类',
                        'type'        => 'select',
                    ),
                    array(
                        'id'      => 'initial_content',
                        'title'   => '初始内容',
                        'default' => 'updated_posts',
                        'type'    => 'select',
                        'options' => array(
                            'page_content'  => __('显示页面内容'),
                            'date_posts'    => __('最近发布文章'),
                            'updated_posts' => __('最近更新文章'),
                            'views_posts'   => __('查看最多文章'),
                        ),
                    ),
                )),
        ));
    } else if ($saved_template === 'pages/links.php') {
        $fields = array_merge($fields, array(
            array(
                'type'    => 'submessage',
                'style'   => 'info',
                'content' => '<b>网址导航页面模板：</b>用于显示链接的页面，支持链接提交，可用于创建‘友情链接’、‘网址导航’等页面 <br><a target="_blank" href="https://www.zibll.com/951.html">查看教程</a>',
            ),
            array(
                'title'   => __('显示页面内容', 'zib_language'),
                'id'      => 'page_links_content_s',
                'type'    => "switcher",
                'default' => false,
            ),
            array(
                'dependency' => array('page_links_content_s', '!=', ''),
                'id'         => 'page_links_content_position',
                'title'      => ' ',
                'subtitle'   => '显示位置',
                'default'    => 'top',
                'class'      => 'compact',
                'inline'     => true,
                'type'       => 'radio',
                'options'    => array(
                    'top'    => __('链接列表上面'),
                    'bottom' => __('链接列表下面'),
                ),
            ),
            array(
                'title'   => __('显示搜索引擎模块', 'zib_language'),
                'id'      => 'page_links_search_s',
                'type'    => "switcher",
                'default' => false,
            ),

            array(
                'dependency'  => array('page_links_search_s', '!=', ''),
                'id'          => 'page_links_search_types',
                'title'       => ' ',
                'subtitle'    => '选择显示的搜索引擎类型',
                'placeholder' => '选择显示的搜索引擎类型',
                'desc'        => '启用后，会在页面上方显示搜索引擎搜索框，用户可以直接在页面上搜索，支持多选，支持拖动排序（至少选择一个）<br>启用后会调用当前页面的特色图片作为搜索背景图',
                'default'     => ['baidu', 'bing', 'sogou', '360'],
                'type'        => 'select',
                'class'       => 'compact',
                'options'     => array(
                    'self'   => '站内',
                    'baidu'  => '百度',
                    'google' => '谷歌',
                    'bing'   => '必应',
                    'sogou'  => '搜狗',
                    '360'    => '360',
                ),
                'chosen'      => true,
                'multiple'    => true,
                'sortable'    => true,
            ),
            array(
                'id'          => 'page_links_category',
                'title'       => '选择显示分类(必填)',
                'placeholder' => '选择分类',
                'default'     => [],
                'type'        => 'select',
                'options'     => 'categories',
                'chosen'      => true,
                'multiple'    => true,
                'sortable'    => true,
                'query_args'  => array(
                    'taxonomy'   => array('link_category'),
                    'orderby'    => 'taxonomy',
                    'hide_empty' => false,
                ),
                'desc'        => '选择要显示的链接分类，支持多选，支持拖动排序<br>当选择多个分类的时候，会以网址导航的形式显示，一个都不选则不会显示任何链接，当然你可以开启模块布局后添加其它小工具模块'
            ),
            array(
                'id'       => 'page_links_style',
                'title'    => '显示样式',
                'subtitle' => ' ',
                'default'  => 'card',
                'inline'   => true,
                'type'     => 'radio',
                'options'  => array(
                    'card'    => __('图文列表'),
                    'bigcard' => __('大卡片'),
                    'image'   => __('纯图片'),
                ),
            ),
            array(
                'title'   => '限制数量',
                'id'      => 'page_links_limit',
                'default' => 0,
                'type'    => 'spinner',
                'min'     => 0,
                'step'    => 5,
                'unit'    => '个',
                'desc'    => '每个分类最多显示多少个链接，填0则为不限制',
            ),
            array(
                'id'      => 'page_links_orderby',
                'title'   => '排序方式',
                'default' => 'name',
                'type'    => 'select',
                'options' => array(
                    'name'    => __('名称排序'),
                    'updated' => __('更新时间'),
                    'rating'  => __('链接评分'),
                    'rand'    => __('随机排序'),
                ),
            ),
            array(
                'id'       => 'page_links_order',
                'title'    => ' ',
                'subtitle' => ' ',
                'default'  => 'ASC',
                'class'    => 'compact',
                'inline'   => true,
                'type'     => 'radio',
                'options'  => array(
                    'ASC'  => __('升序'),
                    'DESC' => __('降序'),
                ),
            ),
            array(
                'title'   => __('外链重定向', 'zib_language'),
                'id'      => 'page_links_go_s',
                'type'    => "switcher",
                'default' => false,
            ),
            array(
                'title'   => __('新标签页打开', 'zib_language'),
                'id'      => 'page_links_blank_s',
                'type'    => "switcher",
                'default' => false,
            ),
            array(
                'title'   => __('显示提交链接模块', 'zib_language'),
                'id'      => 'page_links_submit_s',
                'type'    => "switcher",
                'default' => false,
            ),
            array(
                'dependency' => array('page_links_submit_s', '!=', ''),
                'title'      => ' ',
                'subtitle'   => __('登录后才能提交', 'zib_language'),
                'id'         => 'page_links_submit_sign_s',
                'type'       => "switcher",
                'class'      => 'compact',
                'default'    => true,
            ),
            array(
                'dependency'  => array('page_links_submit_s', '!=', ''),
                'id'          => 'page_links_submit_cats',
                'title'       => ' ',
                'subtitle'    => '提交时允许选择的分类',
                'placeholder' => '选择分类',
                'class'       => 'compact',
                'default'     => [],
                'type'        => 'select',
                'options'     => 'categories',
                'chosen'      => true,
                'multiple'    => true,
                'sortable'    => true,
                'query_args'  => array(
                    'taxonomy'   => array('link_category'),
                    'orderby'    => 'taxonomy',
                    'hide_empty' => false,
                ),
                'desc'        => '选择用户提交链接时可以选择的分类，留空则会展示全部分类',
            ),
            array(
                'dependency' => array('page_links_submit_s', '!=', ''),
                'title'      => ' ',
                'subtitle'   => '提交链接模块：标题',
                'id'         => 'page_links_submit_title',
                'class'      => 'compact',
                'default'    => '申请入驻',
                'type'       => 'text',
            ),
            array(
                'dependency' => array('page_links_submit_s', '!=', ''),
                'id'         => 'page_links_submit_dec',
                'title'      => ' ',
                'subtitle'   => '提交链接模块：提交说明',
                'class'      => 'compact',
                'default'    => '<div>
    <li>您的网站已稳定运行，且有一定的文章量 </li>
    <li>原创、技术、设计类网站优先考虑</li>
    <li>不收录有反动、色情、赌博等不良内容或提供不良内容链接的网站</li>
    <li>您需要将本站链接放置在您的网站中</li>
    <li>请选择正方形的LOGO图像</li>
</div>',
                'attributes' => array(
                    'rows' => 6,
                ),
                'sanitize'   => false,
                'type'       => 'textarea',
            ),
        ));
    } else {
        $fields = array(
            array(
                'type'    => 'submessage',
                'style'   => 'warning',
                'content' => '如果您选择了页面模板，部分模板有相关配置选项在此处进行配置<br>请先选一个页面模板，保存后，刷新页面后再查看此处的配置项',
            ),
        );
    }

    $value = array();
    if (!empty($post->ID)) {
        $option_meta_keys = zib_get_option_meta_keys('post_meta');
        $zib_meta         = get_post_meta($post->ID, 'zib_other_data', true);
        foreach ($fields as $field) {
            if (!empty($field['id'])) {
                if (in_array($field['id'], $option_meta_keys)) {
                    if (isset($zib_meta[$field['id']])) {
                        $value[$field['id']] = $zib_meta[$field['id']];
                    }
                } else {
                    $meta = get_post_meta($post->ID, $field['id']);
                    if (isset($meta[0])) {
                        $value[$field['id']] = $meta[0];
                    }
                }
            }
        }
    }

    $csf_args = array(
        'class'  => '',
        'value'  => $value,
        'form'   => false,
        'nonce'  => false,
        'fields' => $fields,
    );

    ZCSF::instance('post_meta', $csf_args);
}

function zib_save_meta_box_page_templates_meta($post_id)
{

    if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)) {
        return $post_id;
    }

    $fields = array(
        'documentnav_options',
        'page_links_content_s',
        'page_links_content_position',
        'page_links_orderby',
        'page_links_order',
        'page_links_limit',
        'page_links_search_s',
        'page_links_search_types',
        'page_links_category',
        'page_links_style',
        'page_links_submit_s',
        'page_links_submit_sign_s',
        'page_links_submit_cats',
        'page_links_submit_title',
        'page_links_submit_dec',
        'page_links_go_s',
        'page_links_blank_s',
    );

    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            zib_update_post_meta($post_id, $field, $_POST[$field]);
        }
    }
}

function zib_add_meta_box_page_templates_meta()
{
    add_meta_box('page_templates', '页面模板配置', 'zib_meta_box_page_templates_meta', array('page'), 'advanced', 'high');
}
add_action('add_meta_boxes', 'zib_add_meta_box_page_templates_meta');
add_action('save_post', 'zib_save_meta_box_page_templates_meta');

//高级筛选
CSF::createMetabox('custom_filter', array(
    'title'     => '高级自定义筛选',
    'post_type' => array('post'),
    'context'   => 'side',
    'data_type' => 'unserialize',
));
CSF::createSection('custom_filter', array(
    'fields' => post_custom_filter::csf_fields(),
));

/**
 * @description: 一个构建后台列表批量编辑的input
 * @param {*}
 * @return {*}
 */
function zib_get_quick_edit_custom_input($fields_args, $id, $title = '', $desc = '')
{

    $item_html = '';
    foreach ($fields_args as $fields) {
        $options_html = ' ';
        switch ($fields['type']) {
            case 'radio':
                $radio_options      = $fields['options'];
                $radio_options_html = '<div class="mr10"><label style="line-height: 1;"><input type="radio" name="zib_bulk_edit[' . $id . '][' . $fields['id'] . ']" value="ignore"><span class="opacity8">不更改</span></label></div>';
                foreach ($radio_options as $key => $value) {
                    $radio_options_html .= '<div class="mr10"><label style="line-height: 1;"><input type="radio" name="zib_bulk_edit[' . $id . '][' . $fields['id'] . ']" value="' . $key . '"><span class="opacity8">' . $value . '</span></label></div>';
                }
                $options_html = '<div class="flex ac hh mb10">' . $radio_options_html . '</div>';
                break;

            case 'select':
                $select_options      = $fields['options'];
                $select_options_html = '<option selected="selected" value="ignore">--不更改--</option>';
                foreach ($select_options as $key => $value) {
                    $select_options_html .= '<option value="' . $key . '">' . esc_attr($value) . '</option>';
                }
                $options_html = '<div class="flex ac hh mb10"><select name="zib_bulk_edit[' . $id . '][' . $fields['id'] . ']">' . $select_options_html . '</select></div>';
                break;

            case 'number':
                $options_html = '<div class="flex ac hh mb10">
                                    <select name="zib_bulk_edit[' . $id . '][' . $fields['id'] . '][operation]">
                                            <option value="ignore" selected="selected">不更改</option>
                                            <option value="set">设置为</option>
                                            <option value="plus">加</option>
                                            <option value="subtract">减</option>
                                            <option value="multiply">乘</option>
                                            <option value="division">除</option>
                                    </select>
                                    <input type="text" name="zib_bulk_edit[' . $id . '][' . $fields['id'] . '][val]" value="">
                                </div>';
                break;

            case 'checkbox':
            case 'switcher':
                $radio_options_html = '<div class="mr10"><label style="line-height: 1;"><input type="radio" name="zib_bulk_edit[' . $id . '][' . $fields['id'] . ']" value="ignore"><span class="opacity8">不更改</span></label></div>';
                $radio_options_html .= '<div class="mr10"><label style="line-height: 1;"><input type="radio" name="zib_bulk_edit[' . $id . '][' . $fields['id'] . ']" value="1"><span class="opacity8">开启</span></label></div>';
                $radio_options_html .= '<div class="mr10"><label style="line-height: 1;"><input type="radio" name="zib_bulk_edit[' . $id . '][' . $fields['id'] . ']" value="0"><span class="opacity8">关闭</span></label></div>';

                $options_html = '<div class="flex ac hh mb10">' . $radio_options_html . '</div>';
                break;
        }

        if ($options_html) {
            $fields_title = !empty($fields['title']) ? $fields['title'] : (!empty($fields['label']) ? $fields['label'] : '');

            $item_html .= '<div style="margin: -1px;background:#f8fcff;border: 1px solid #d2d2d2;padding: 0 10px;line-height: 2.5;">
                                <div>' . $fields_title . '</div>
                                ' . $options_html . '
                            </div>';
        }

    }

    $title = $title ? '<legend class="inline-edit-legend">' . $title . '</legend>' : '';

    return $item_html ? '<fieldset style="margin-top: 20px">' . $title . '<div class="flex hh">' . $item_html . '</div>' . $desc . '</fieldset>' : '';
}

//高级筛选批量编辑和快速编辑
add_action('bulk_edit_custom_box', array('post_custom_filter', 'bulk_edit_custom_box'), 10, 2);
add_action('quick_edit_custom_box', array('post_custom_filter', 'bulk_edit_custom_box'), 10, 2);
add_action('save_post', array('post_custom_filter', 'bulk_save_post'), 10, 3);

class post_custom_filter
{

    public static function csf_fields()
    {
        $fields = array();

        $opts = _pz('custom_filter');
        if ($opts && is_array($opts)) {
            foreach ($opts as $opt) {
                if ($opt['key']) {

                    $options = array();
                    foreach ($opt['vals'] as $val) {
                        if ($val['key']) {
                            $name                 = $val['name'] ?: $val['key'];
                            $options[$val['key']] = $name;
                        }
                    }

                    if ($options) {
                        $fields[] = array(
                            'id'          => $opt['key'],
                            'title'       => $opt['name'] ?: $opt['key'],
                            'options'     => $options,
                            'placeholder' => '请选择' . $opt['name'] ?: $opt['key'],
                            'chosen'      => true,
                            'multiple'    => true,
                            'type'        => 'select',
                        );
                    }

                }
            }
        }

        if ($fields) {
            $fields = array_merge(array(array(
                'type'    => 'submessage',
                'style'   => 'warning',
                'content' => '高级筛选：让文章实现更加精细化的分类，同时方便用户进行文章筛选
                <br><a target="_blank" href="' . zib_get_admin_csf_url('文章&列表/高级筛选') . '">管理高级筛选明细</a>',
            )), $fields);
        } else {
            $fields = array_merge(array(array(
                'type'    => 'submessage',
                'style'   => 'warning',
                'content' => '高级筛选：让文章实现更加精细化的分类，同时方便用户进行文章筛选
                <div class="c-yellow">您暂未添加高级筛选明细，请先点击下方链接进行配置</div>
                <a target="_blank" href="' . zib_get_admin_csf_url('文章&列表/高级筛选') . '">添加高级筛选明细</a>',
            )), $fields);
        }

        return $fields;
    }

    /**
     * @description: 后台添加批量修改帖子参数的选项
     * @param {*} $column_name
     * @param {*} $post_type
     * @return {*}
     */
    public static function bulk_edit_custom_box($column_name, $post_type)
    {
        if ($post_type === 'post') {
            if ($column_name === 'taxonomy-topics') {

                echo self::edit_select();
            }
        }

        if ($post_type === 'plate') {

        }
    }

    public static function bulk_save_post($post_ID, $post, $update)
    {
        if (!$update || $post->post_type !== 'post' || empty($_REQUEST['screen']) || $_REQUEST['screen'] !== 'edit-post') {
            return;
        }

        $opts = _pz('custom_filter');
        if ($opts && is_array($opts)) {
            foreach ($opts as $opt) {
                if ($opt['key'] && !empty($_REQUEST[$opt['key']])) {
                    update_post_meta($post_ID, $opt['key'], $_REQUEST[$opt['key']]);
                }
            }
        }

    }

    public static function edit_select()
    {
        $box = '';

        $opts = _pz('custom_filter');
        if ($opts && is_array($opts)) {
            foreach ($opts as $opt) {
                if ($opt['key']) {

                    $options = '';
                    foreach ($opt['vals'] as $val) {
                        if ($val['key']) {
                            $name = $val['name'] ?: $val['key'];
                            $options .= '<li class="popular-category"><label class="selectit  but but-sm" style="margin: 2px 5px;"><input value="' . $val['key'] . '" type="checkbox" name="' . $opt['key'] . '[]"> ' . $name . '</label></li>';
                        }
                    }

                    $box .= '<div class="inline-edit-col">
                                <span class="title inline-edit-categories-label">高级筛选：' . ($opt['name'] ?: $opt['key']) . '</span>
                                <ul class="cat-checklist category-checklist flex ac hh" style="height: auto;">' . $options . '</ul>
                            </div>';

                }
            }
        }

        return $box ? '<fieldset style="border: 1px solid #dbdbdb;padding: 0 10px;" class="inline-edit-col-left inline-edit-custom-filter">' . $box . '</fieldset>' : '';
    }
    public static function filters_options()
    {

        $opts    = _pz('custom_filter');
        $options = array();

        if ($opts && is_array($opts)) {
            foreach ($opts as $opt) {
                if ($opt['key']) {
                    $options[$opt['key']] = $opt['name'] ?: $opt['key'];

                }
            }
        }

        return $options;
    }

}

//批量编辑
add_action('bulk_edit_custom_box', array('zib_post_bulk_edit', 'edit_box'), 10, 2);
add_action('quick_edit_custom_box', array('zib_post_bulk_edit', 'edit_box'), 10, 2);
add_action('save_post', array('zib_post_bulk_edit', 'save'), 10, 3);
class zib_post_bulk_edit
{
    public static $permissible_posts_type = ['post'];
    public static $column_name            = 'taxonomy-topics';
    public static $bulk_id                = 'extended';

    public static function edit_box($column_name, $post_type)
    {
        if (!in_array($post_type, self::$permissible_posts_type) || $column_name !== self::$column_name) {
            return;
        }
        $fields_args = array(
            array(
                'id'    => 'views',
                'type'  => 'number',
                'title' => '阅读量',
            ),
            array(
                'id'    => 'like',
                'type'  => 'number',
                'title' => '点赞数',
            ),
            array(
                'id'      => 'show_layout',
                'type'    => 'radio',
                'title'   => '显示布局',
                'default' => 'false',
                'options' => array(
                    'false'         => '跟随主题',
                    'no_sidebar'    => '无侧边栏',
                    'sidebar_left'  => '侧边栏靠左',
                    'sidebar_right' => '侧边栏靠右',
                ),
            ),
            array(
                'id'    => 'no_article-navs',
                'type'  => 'checkbox',
                'label' => '不显示目录树',
            ),
            array(
                'id'    => 'article_maxheight_xz',
                'type'  => 'checkbox',
                'label' => '限制内容最大高度',
            ),
        );

        echo zib_get_quick_edit_custom_input($fields_args, self::$bulk_id);

    }

    public static function save($post_id, $post, $update)
    {
        if (!$update || empty($_REQUEST['zib_bulk_edit'][self::$bulk_id]) || !in_array($post->post_type, self::$permissible_posts_type) || empty($_REQUEST['screen']) || $_REQUEST['screen'] !== 'edit-post') {
            return;
        }

        $zibpay_bulk_edit = $_REQUEST['zib_bulk_edit'][self::$bulk_id];
        foreach ($zibpay_bulk_edit as $field_id => $field_value) {
            switch ($field_id) {
                case 'views':
                case 'like':
                    $operation = $field_value['operation'];
                    if ($operation !== 'ignore' && is_numeric($field_value['val'])) {

                        $old_val = get_post_meta($post_id, $field_id, true);
                        $val     = (float) $field_value['val'];

                        switch ($operation) {
                            case 'set': //统一设置为
                                $new_val = $val;
                                break;
                            case 'plus':
                                $new_val = round($old_val + $val, 2);
                                break;
                            case 'subtract':
                                $new_val = round($old_val - $val, 2);
                                break;
                            case 'multiply':
                                $new_val = round($old_val * $val, 2);
                                break;
                            case 'division':
                                if ($val != 0 && $old_val != 0) {
                                    $new_val = round($old_val / $val, 2);
                                }
                                break;
                        }
                        $new_val = (int) $new_val;
                        $new_val = $new_val < 0 ? 0 : $new_val;
                        update_post_meta($post_id, $field_id, $new_val);
                    }

                    break;
                case 'show_layout':
                case 'no_article-navs':
                case 'article_maxheight_xz':

                    if ($field_value !== 'ignore') {
                        zib_update_post_meta($post_id, $field_id, $field_value);
                    }

                    break;
            }
        }

    }
}

//文章 - 扩展
function zib_meta_box_post_main_meta($post)
{
    $fields = array(
        array(
            'title'   => '外链特色图像',
            'id'      => 'thumbnail_url',
            'library' => 'image',
            'type'    => 'upload',
            'default' => false,
            'desc'    => '支持直接输入链接用作特色图像<br/><span style="color:#ff4646;">此处设置仅在未设置wp特色图片时有效</span>',
        ),
    );
    if (_pz('article_image_cover')) {
        $fields = array_merge($fields, array(
            array(
                'title'   => '封面图',
                'id'      => 'cover_image',
                'library' => 'image',
                'type'    => 'upload',
                'default' => false,
                'desc'    => '在文章页顶部显示封面图',
            ),
        ));
    }

    if (_pz('list_thumb_slides_s') || _pz('article_slide_cover')) {
        $fields = array_merge($fields, array(
            array(
                'title'       => '特色幻灯片',
                'id'          => 'featured_slide',
                'type'        => 'gallery',
                'add_title'   => '添加图像',
                'edit_title'  => '编辑图像',
                'clear_title' => '清空图像',
                'default'     => false,
                'desc'        => '为该文章显示幻灯片封面或幻灯片略图（优先级>特色图像及封面图）',
            ),
        ));
    }

    if (_pz('list_thumb_video_s') || _pz('article_video_cover')) {
        $fields = array_merge($fields, array(
            array(
                'title'   => '特色视频',
                'id'      => 'featured_video',
                'type'    => 'upload',
                'preview' => false,
                'library' => 'video',
                'default' => false,
                'desc'    => '为该文章显示视频封面（优先级>幻灯片封面）',
            ),
            array(
                'dependency'  => array('featured_video', '!=', ''),
                'id'          => 'featured_video_title',
                'title'       => ' ',
                'subtitle'    => '本集标题',
                'desc'        => '如需添加剧集则需填写此处',
                'default'     => '',
                'placeholder' => '第1集',
                'class'       => 'compact',
                'type'        => 'text',
            ),
            array(
                'dependency'   => array('featured_video', '!=', '', '', 'visible'),
                'id'           => 'featured_video_episode',
                'type'         => 'group',
                'button_title' => '添加剧集',
                'class'        => 'compact',
                'title'        => '视频剧集',
                'subtitle'     => '为视频封面添加更多剧集',
                'default'      => array(),
                'fields'       => array(
                    array(
                        'id'       => 'title',
                        'title'    => ' ',
                        'subtitle' => '剧集标题',
                        'default'  => '',
                        'type'     => 'text',
                    ),
                    array(
                        'title'       => ' ',
                        'subtitle'    => '视频地址',
                        'id'          => 'url',
                        'class'       => 'compact',
                        'type'        => 'upload',
                        'preview'     => false,
                        'library'     => 'video',
                        'placeholder' => '选择视频或填写视频地址',
                        'default'     => false,
                    ),

                ),
            ),
            array(
                'id'    => 'subtitle',
                'type'  => 'text',
                'title' => '副标题',
            ),
            array(
                'id'       => 'views',
                'type'     => 'number',
                'title'    => '阅读量',
                'default'  => zib_get_mt_rand_number(_pz('post_default_mate', '', 'views')),
                'validate' => 'csf_validate_numeric',
            ),
            array(
                'id'       => 'like',
                'type'     => 'number',
                'title'    => '点赞数',
                'default'  => zib_get_mt_rand_number(_pz('post_default_mate', '', 'like')),
                'validate' => 'csf_validate_numeric',
            ),
            array(
                'id'      => 'show_layout',
                'type'    => 'radio',
                'title'   => '显示布局',
                'default' => 'false',
                'options' => array(
                    'false'         => '跟随主题',
                    'no_sidebar'    => '无侧边栏',
                    'sidebar_left'  => '侧边栏靠左',
                    'sidebar_right' => '侧边栏靠右',
                ),
            ),
            array(
                'id'    => 'no_article-navs',
                'type'  => 'checkbox',
                'label' => '不显示目录树',
            ),
            array(
                'id'    => 'article_maxheight_xz',
                'type'  => 'checkbox',
                'label' => '限制内容最大高度',
            ),
        ));
    }

    $value = array();
    if (!empty($post->ID)) {
        $option_meta_keys = zib_get_option_meta_keys('post_meta');
        $zib_meta         = get_post_meta($post->ID, 'zib_other_data', true);
        foreach ($fields as $field) {
            if (!empty($field['id'])) {
                if (in_array($field['id'], $option_meta_keys)) {
                    if (isset($zib_meta[$field['id']])) {
                        $value[$field['id']] = $zib_meta[$field['id']];
                    }
                } else {
                    $meta = get_post_meta($post->ID, $field['id']);
                    if (isset($meta[0])) {
                        $value[$field['id']] = $meta[0];
                    }
                }
            }
        }
    }

    $csf_args = array(
        'class'  => '',
        'value'  => $value,
        'form'   => false,
        'nonce'  => false,
        'fields' => $fields,
    );

    ZCSF::instance('post_meta', $csf_args);
}

function zib_save_meta_box_post_main_meta($post_id)
{

    if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)) {
        return $post_id;
    }

    $fields = array(
        'thumbnail_url',
        'cover_image',
        'featured_slide',
        'featured_video',
        'featured_video_title',
        'featured_video_episode',
        'subtitle',
        'views',
        'like',
        'show_layout',
        'no_article-navs',
        'article_maxheight_xz',
    );

    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            zib_update_post_meta($post_id, $field, $_POST[$field]);
        }
    }
}

function zib_add_meta_box_post_main_meta()
{
    add_meta_box('post_main', '文章扩展', 'zib_meta_box_post_main_meta', array('post'), 'side', 'high');
}
add_action('add_meta_boxes', 'zib_add_meta_box_post_main_meta');
add_action('save_post', 'zib_save_meta_box_post_main_meta');

//页面扩展
function zib_meta_box_page_main_meta($post)
{

    $fields = array(
        array(
            'type'    => 'submessage',
            'style'   => 'warning',
            'content' => '当选择了页面模板后，部分模板以下配置可能会失效',
        ),
        array(
            'id'      => 'show_layout',
            'type'    => 'radio',
            'title'   => '显示布局',
            'default' => '',
            'options' => array(
                ''              => '跟随主题',
                'no_sidebar'    => '无侧边栏',
                'sidebar_left'  => '侧边栏靠左',
                'sidebar_right' => '侧边栏靠右',
            ),
        ),
        array(
            'id'      => 'page_header_style',
            'type'    => 'radio',
            'title'   => '标题样式',
            'default' => '',
            'options' => array(
                ''    => __('跟随主题', 'zib_language'),
                'not' => __('不显示', 'zib_language'),
                1     => __('简单样式', 'zib_language'),
                2     => __('卡片样式', 'zib_language'),
                3     => __('图文样式', 'zib_language'),
            ),
        ),
        array(
            'id'      => 'page_content_style',
            'type'    => 'radio',
            'title'   => '内容样式',
            'desc'    => '全屏无背景样式通常用于全局使用HTML代码构建页面，属于高级用法，不建议新手使用',
            'default' => '',
            'options' => array(
                ''      => __('默认', 'zib_language'),
                'not'   => __('不显示', 'zib_language'),
                'nobox' => __('无背景', 'zib_language'),
                'full'  => __('全屏无背景', 'zib_language'),
            ),
        ),
        array(
            'title' => '模块布局',
            'id'    => 'widgets_register',
            'type'  => 'switcher',
            'label' => '为该页面创建小工具容器',
        ),
        array(
            'dependency' => array('widgets_register', '!=', ''),
            'id'         => 'widgets_register_container',
            'type'       => 'checkbox',
            'class'      => 'compact',
            'title'      => ' ',
            'subtitle'   => '创建容器位置',
            'desc'       => '请根据需要合理开启，如果用不到则不要开启<br>保存页面后即可进入小工具或模块配置添加模块<div class="c-yellow">注意：开启此功能的页面不能太多，太多会影响性能，建议控制在10个以内</div>',
            'options'    => array(
                'sidebar'        => __('侧边栏', 'zib_language'),
                'top_fluid'      => __('顶部全宽度', 'zib_language'),
                'top_content'    => __('主内容上面', 'zib_language'),
                'bottom_content' => __('主内容下面', 'zib_language'),
                'bottom_fluid'   => __('底部全宽度', 'zib_language'),
            ),
        ));

    $value = array();
    if (!empty($post->ID)) {
        $option_meta_keys = zib_get_option_meta_keys('post_meta');
        $zib_meta         = get_post_meta($post->ID, 'zib_other_data', true);
        foreach ($fields as $field) {
            if (!empty($field['id'])) {
                if (in_array($field['id'], $option_meta_keys)) {
                    if (isset($zib_meta[$field['id']])) {
                        $value[$field['id']] = $zib_meta[$field['id']];
                    }
                } else {
                    $meta = get_post_meta($post->ID, $field['id']);
                    if (isset($meta[0])) {
                        $value[$field['id']] = $meta[0];
                    }
                }
            }
        }
    }

    $csf_args = array(
        'class'  => '',
        'value'  => $value,
        'form'   => false,
        'nonce'  => false,
        'fields' => $fields,
    );

    ZCSF::instance('post_meta', $csf_args);
}

function zib_save_meta_box_page_main_meta($post_id)
{

    if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)) {
        return $post_id;
    }

    $fields = array(
        'show_layout',
        'page_header_style',
        'page_content_style',
        'widgets_register', //不能加入zib聚合
        'widgets_register_container', //不能加入zib聚合
    );

    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            zib_update_post_meta($post_id, $field, $_POST[$field]);
        }
    }
}

function zib_add_meta_box_page_main_meta()
{
    add_meta_box('post_main', '页面扩展', 'zib_meta_box_page_main_meta', array('page'), 'side', 'high');
}
add_action('add_meta_boxes', 'zib_add_meta_box_page_main_meta');
add_action('save_post', 'zib_save_meta_box_page_main_meta');

if ((_pz('xzh_post_on') || _pz('xzh_post_daily_push')) && _pz('xzh_post_token')) {
    CSF::createMetabox('baidu_resource_submission', array(
        'title'     => '百度资源提交',
        'post_type' => array('post', 'page', 'plate', 'forum_post'),
        'context'   => 'advanced',
        'data_type' => 'unserialize',
    ));
    CSF::createSection('baidu_resource_submission', array(
        'fields' => array(
            array(
                'title'   => __('百度资源提交', 'zib_language'),
                'type'    => 'content',
                'content' => zib_get_baidu_resource_submission_metabox(),
            ),
        ),
    ));

    //为term添加百度资源提交
    CSF::createTaxonomyOptions('term_baidu_resource_submission', array(
        'title'     => '百度资源提交',
        'taxonomy'  => ['category', 'post_tag', 'topics', 'plate_cat', 'forum_topic', 'forum_tag'],
        'data_type' => 'unserialize',
    ));
    CSF::createSection('term_baidu_resource_submission', array(
        'fields' => array(
            array(
                'title'   => __('百度资源提交', 'zib_language'),
                'type'    => 'content',
                'content' => zib_get_baidu_resource_submission_metabox(false),
            ),
        ),
    ));

}

function zib_get_baidu_resource_submission_metabox($is_post = true)
{
    if ($is_post) {
        if (isset($_GET['post'])) {
            $post_id = (int) $_GET['post'];
        } elseif (isset($_POST['post_ID'])) {
            $post_id = (int) $_POST['post_ID'];
        } else {
            $post_id = 0;
        }
        $tui = zib_get_post_meta($post_id, 'xzh_tui_back', true);
    } else {
        if (isset($_GET['tag_ID'])) {
            $term_id = (int) $_GET['tag_ID'];
        } else {
            $term_id = 0;
        }
        $tui = zib_get_term_meta($term_id, 'xzh_tui_back', true);
    }

    $Resubmit  = '';
    $show_text = '';
    if (!empty($tui['normal_push'])) {
        $show_text .= '<strong>普通收录：成功</strong> ' . json_encode($tui['normal_result']) . '<br>';
    } elseif (isset($tui['normal_push']) && false == $tui['normal_push']) {
        $show_text .= '<strong>普通收录：失败</strong> ' . json_encode($tui['normal_result']) . '<br>';
    }
    if (!empty($tui['daily_push'])) {
        $show_text .= '<strong>快速收录：成功</strong> ' . json_encode($tui['daily_result']) . '<br>';
    } elseif (isset($tui['daily_push']) && false == $tui['daily_push']) {
        $show_text .= '<strong>快速收录：失败</strong> ' . json_encode($tui['daily_result']) . '<br>';
    }
    if (!empty($tui['update_time'])) {
        $show_text .= '<strong>更新时间：</strong>' . $tui['update_time'] . '<br>';
        $Resubmit = '<span style="margin:0 20px 15px 0; display:inline-block;"><label><input type="checkbox" name="xzh_post_resubmit"> 重新提交</label></span>';
    }
    if (strstr(json_encode($tui), '成功') || strstr(json_encode($tui), '失败')) {
        $show_text .= json_encode($tui) . '<br>';
    }
    if ($show_text) {
        $show_text = '<div>提交结果:</div>' . $show_text;
    } else {
        $show_text = '发布、更新后刷新页面后可查看提交结果';
    }

    return $Resubmit . $show_text;
}

//文章、页面、帖子的独立seo
function zib_meta_box_seo_meta($post)
{

    $fields = array(
        array(
            'title'   => __('SEO预览', 'zib_language'),
            'type'    => 'content',
            'content' => zib_get_seo_preview_box(),
        ),
        array(
            'title' => __('标题', 'zib_language'),
            'id'    => 'title',
            'desc'  => 'Title 一般建议15到30个字符',
            'std'   => '',
            'type'  => 'text',
        ),
        array(
            'title' => __('关键词', 'zib_language'),
            'id'    => 'keywords',
            'desc'  => 'Keywords 每个关键词用逗号隔开',
            'std'   => '',
            'type'  => 'text',
        ),
        array(
            'title' => __('描述', 'zib_language'),
            'id'    => 'description',
            'desc'  => 'Description 一般建议50到150个字符',
            'std'   => '',
            'type'  => 'textarea',
        ),
        array(
            'type'       => 'accordion',
            'id'         => 'accordion',
            'accordions' => array(
                array(
                    'title'  => 'SEO优化建议',
                    'icon'   => 'fas fa-star',
                    'fields' => array(
                        array(
                            'title'   => ' ',
                            'type'    => 'content',
                            'content' => '<div style="color:#048cf0;margin-bottom:5px;">SEO标题优化建议：</div>
                        <li>主题默认会自动获取标题、副标题、网站名称作为SEO标题</li>
                        <li>标题内容应该紧扣页面的主要内容有吸引力</li>
                        <li>网站标题不要有过多的重复</li>
                        <li>第一个词放最重要的关键词</li>
                        <li>关键词只能重复2次，不要堆砌关键词</li>
                        <li>最后一个词放品牌词，不重要的词语</li>
                        <div style="color:#048cf0;margin-bottom:5px;margin-top:15px;">SEO关键词优化建议：</div>
                        <li>主题默认会自动获取分类及标签作为关键词，页面请单独自定义</li>
                        <li>关键词一般建议4到8个</li>
                        <li>尽量与网站定位一致</li>
                        <li>添加网站专属关键词</li>
                        <div style="color:#048cf0;margin-bottom:5px;margin-top:15px;">SEO描述优化建议：</div>
                        <li>主题默认会自动获取摘要、内容为SEO描述</li>
                        <li>description是对网页内容的精练概括</li>
                        <li>写成一段通顺有意义的话，要有吸引力</li>
                        <li>建议加入多个关键词，但不宜重复太多</li>
                        <div style="color:#f7497e;margin-bottom:5px;margin-top:15px;">优化建议来自互联网，仅供参考</div>',
                        ),
                    ),
                ),
            ),
        ),
    );

    $value = array();
    if (!empty($post->ID)) {
        $option_meta_keys = zib_get_option_meta_keys('post_meta');
        $zib_meta         = get_post_meta($post->ID, 'zib_other_data', true);
        foreach ($fields as $field) {
            if (!empty($field['id'])) {
                if (in_array($field['id'], $option_meta_keys)) {
                    if (isset($zib_meta[$field['id']])) {
                        $value[$field['id']] = $zib_meta[$field['id']];
                    }
                } else {
                    $meta = get_post_meta($post->ID, $field['id']);
                    if (isset($meta[0])) {
                        $value[$field['id']] = $meta[0];
                    }
                }
            }
        }
    }

    $csf_args = array(
        'class'  => '',
        'value'  => $value,
        'form'   => false,
        'nonce'  => false,
        'fields' => $fields,
    );

    ZCSF::instance('post_meta', $csf_args);
}

function zib_save_meta_box_seo_meta($post_id)
{

    if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)) {
        return $post_id;
    }

    $fields = array(
        'title',
        'keywords',
        'description',
    );

    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            zib_update_post_meta($post_id, $field, $_POST[$field]);
        }
    }
}

function zib_add_meta_box_seo_meta()
{
    add_meta_box('posts_seo', '独立SEO', 'zib_meta_box_seo_meta', array('post', 'page', 'plate', 'forum_post'), 'advanced', 'high');
}
if (_pz('post_keywords_description_s')) {
    add_action('add_meta_boxes', 'zib_add_meta_box_seo_meta');
    add_action('save_post', 'zib_save_meta_box_seo_meta');
}

function zib_get_seo_preview_box($type = 'post')
{
    $title       = '';
    $keywords    = '';
    $description = '';
    $html        = '';
    $permalink   = '';

    $after = (_pz('connector') ? _pz('connector') : '-') . get_bloginfo('name');
    if ($type == 'post') {
        if (isset($_GET['post'])) {
            $post_id = (int) $_GET['post'];
        } elseif (isset($_POST['post_ID'])) {
            $post_id = (int) $_POST['post_ID'];
        } else {
            $post_id = 0;
        }
        if ($post_id) {
            $post      = get_post($post_id);
            $permalink = get_permalink($post);

            $title = zib_get_post_meta($post->ID, 'title', true);
            $title = $title ? $title : $post->post_title . zib_get_post_meta($post->ID, 'subtitle', true) . $after;

            $keywords = zib_get_post_meta($post->ID, 'keywords', true);

            if (!$keywords) {
                if (get_the_tags($post->ID)) {
                    foreach (get_the_tags($post->ID) as $tag) {
                        $keywords .= $tag->name . ', ';
                    }
                }
                foreach (get_the_category($post->ID) as $category) {
                    $keywords .= $category->cat_name . ', ';
                }
                $keywords = substr_replace($keywords, '', -2);
            }
            $description = zib_get_post_meta($post->ID, 'description', true);
            if (!$description) {
                if (!empty($post->post_excerpt)) {
                    $description = $post->post_excerpt;
                } else {
                    $description = $post->post_content;
                }
                $description = trim(str_replace(array("\r\n", "\r", "\n", "　", " "), " ", str_replace("\"", "'", strip_tags($description))));

                /**删除短代码内容 */
                $description = preg_replace('/\[payshow.*payshow\]||\[hidecontent.*hidecontent\]||\[reply.*reply\]||\[postsbox.*\]/', '', $description);

                $description = mb_substr($description, 0, 200, 'utf-8');
                if (!$description) {
                    $description = get_bloginfo('name') . "-" . trim(wp_title('', false));
                }
            }
        }
    }
    $html .= '<style>
    .zib-widget.seo-preview {
        padding: 15px 20px;
        border-radius: 10px;
        max-width: 600px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.08);
    }
    .seo-title a{
        font-size: 18px;
        line-height: 22px;
        color: #2440b3;
        text-decoration: none;
    }
    .seo-description {
        margin:10px 0 5px 0;
    }
    .seo-keywords {
        opacity: .6;
        margin-top: 5px;
    }
    </style>';

    if (!$permalink) {
        return $html . '<div style=" text-align: center; padding: 30px 15px; color: #fc61a5; font-size: 14px; " class="zib-widget seo-preview"><div class="seo-title"><span class="dashicons dashicons-warning"></span> 请保存内容后 刷新页面查看SEO预览</div></div>';
    }
    $title       = $title ? $title : '<span style=" color: #fa4784; "><span class="dashicons dashicons-warning"></span> SEO标题或者文章标题为空</span>';
    $keywords    = $keywords ? $keywords : '<span style=" color: #fa4784; "><span class="dashicons dashicons-warning"></span> SEO关键词为空</span>';
    $description = $description ? $description : '<span style=" color: #fa4784; "><span class="dashicons dashicons-warning"></span> SEO描述或文章内容为空</span>';

    $html .= '<div class="zib-widget seo-preview">';
    $html .= '<div class="seo-header"></div>';
    $html .= '<div class="seo-title">';
    $html .= '<a class="" href="javascript:;">' . $title . '</a>';
    $html .= '</div>';

    $html .= '<div class="seo-description">' . $description . '</div>';
    $html .= '<a class="" href="javascript:;">' . $permalink . '</a>';
    $html .= '<div class="seo-keywords">';
    $html .= '<div class="">' . $keywords . '</div>';
    $html .= '</div>';

    $html .= '</div>';

    return $html;
}
